/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.service;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.service.ITestService;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.service.TestService1;
import org.eclipse.riena.core.service.TestService2;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.osgi.framework.ServiceRegistration;

@NonUITestCase
public class ServiceTest
extends RienaTestCase {
    public void testServiceGetWithRanking() {
        ServiceRegistration reg1 = this.getContext().registerService(ITestService.class.getName(), (Object)new TestService1(), (Dictionary)RienaConstants.newDefaultServiceProperties());
        ServiceRegistration reg2 = this.getContext().registerService(ITestService.class.getName(), (Object)new TestService2(), null);
        ITestService service = (ITestService)Service.get(ITestService.class);
        ServiceTest.assertEquals((String)"Hallo Welt", (String)service.hello("Welt"));
        reg2.unregister();
        service = (ITestService)Service.get(ITestService.class);
        ServiceTest.assertEquals((String)"Hello World", (String)service.hello("World"));
        reg1.unregister();
        service = (ITestService)Service.get(ITestService.class);
        ServiceTest.assertNull((Object)service);
    }

    public void testServiceGetWithFilter() {
        Hashtable<String, String> dict1 = new Hashtable<String, String>();
        ((Dictionary)dict1).put("kind", "1");
        ServiceRegistration reg1 = this.getContext().registerService(ITestService.class.getName(), (Object)new TestService1(), dict1);
        Hashtable<String, String> dict2 = new Hashtable<String, String>();
        ((Dictionary)dict2).put("kind", "2");
        ServiceRegistration reg2 = this.getContext().registerService(ITestService.class.getName(), (Object)new TestService2(), dict2);
        ITestService service = (ITestService)Service.get(ITestService.class, (String)"(kind=1)");
        ServiceTest.assertEquals((String)"Hello Welt", (String)service.hello("Welt"));
        service = (ITestService)Service.get(ITestService.class, (String)"(kind=2)");
        ServiceTest.assertEquals((String)"Hallo World", (String)service.hello("World"));
        reg2.unregister();
        reg1.unregister();
        service = (ITestService)Service.get(ITestService.class);
        ServiceTest.assertNull((Object)service);
    }
}

