/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.tests.collect.NonUITestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonUITestCase
public abstract class AbstractSerializerFactoryTestCase
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.removeUnwantedSerializerFactories();
    }

    private void removeUnwantedSerializerFactories() {
        HashMap staticDeSerMap = (HashMap)ReflectionUtils.getHidden(SerializerFactory.class, (String)"_staticDeserializerMap");
        staticDeSerMap.remove(InputStream.class);
        staticDeSerMap.remove(StackTraceElement.class);
        HashMap staticSerMap = (HashMap)ReflectionUtils.getHidden(SerializerFactory.class, (String)"_staticSerializerMap");
        staticSerMap.remove(InputStream.class);
    }

    protected boolean isBackAndForthOk(Object object, Class<?> asReturnType, AbstractSerializerFactory ... abstractSerializerFactories) {
        return this.isBackAndForthOk(object, HessianSerializerVersion.One, asReturnType, abstractSerializerFactories) && this.isBackAndForthOk(object, HessianSerializerVersion.Two, asReturnType, abstractSerializerFactories);
    }

    protected boolean isBackAndForthOk(Object expected, HessianSerializerVersion version, Class<?> asReturnType, AbstractSerializerFactory ... abstractSerializerFactories) {
        Assert.isNotNull((Object)expected, (String)"expected value MUST not be null");
        try {
            return expected.equals(this.inAndOut(expected, version, asReturnType, abstractSerializerFactories));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Object inAndOut(Object object, HessianSerializerVersion version, Class<?> asReturnType, AbstractSerializerFactory ... abstractSerializerFactories) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Hessian2Output out = version == HessianSerializerVersion.Two ? new Hessian2Output((OutputStream)baos) : new HessianOutput((OutputStream)baos);
        SerializerFactory factory = out.findSerializerFactory();
        AbstractSerializerFactory[] abstractSerializerFactoryArray = abstractSerializerFactories;
        int n = abstractSerializerFactories.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSerializerFactory serializerFactory = abstractSerializerFactoryArray[n2];
            factory.addFactory(serializerFactory);
            ++n2;
        }
        factory.setAllowNonSerializable(true);
        out.writeObject(object);
        out.close();
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        Hessian2Input in = version == HessianSerializerVersion.Two ? new Hessian2Input((InputStream)is) : new HessianInput((InputStream)is);
        in.setSerializerFactory(factory);
        return in.readObject(asReturnType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HessianSerializerVersion {
        One,
        Two;

    }
}

