/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.ListRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.tests.FTActionListener;
import org.eclipse.riena.tests.TestSelectionListener;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ListRidgetTest
extends AbstractTableRidgetTest {
    protected Control createWidget(Composite parent) {
        return new org.eclipse.swt.widgets.List(parent, 2);
    }

    protected IRidget createRidget() {
        return new ListRidget();
    }

    protected org.eclipse.swt.widgets.List getWidget() {
        return (org.eclipse.swt.widgets.List)super.getWidget();
    }

    protected IListRidget getRidget() {
        return (IListRidget)super.getRidget();
    }

    protected void bindRidgetToModel() {
        this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, "firstname");
    }

    private Shell createSimplifiedTestList() {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        ListRidgetTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        Shell shell = new Shell(147456);
        shell.setLayout((Layout)new RowLayout(512));
        shell.setSize(130, 100);
        shell.setLocation(0, 0);
        shell.open();
        return shell;
    }

    public void testSimplifiedBinding() {
        Shell shell = this.createSimplifiedTestList();
        org.eclipse.swt.widgets.List control = new org.eclipse.swt.widgets.List((Composite)shell, 0);
        IListRidget ridget = (IListRidget)SwtRidgetFactory.createRidget((Object)control);
        UITestHelper.readAndDispatch((Widget)this.getWidget());
        SimplifiedModel model = new SimplifiedModel();
        ridget.bindToModel((Object)model, "values");
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((int)model.getValues().size(), (int)control.getItemCount());
        ListRidgetTest.assertNotNull((Object)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Janet", (String)control.getItem(0));
        ListRidgetTest.assertNotNull((Object)control.getItem(1));
        ListRidgetTest.assertEquals((String)"Jermaine", (String)control.getItem(1));
        ListRidgetTest.assertNotNull((Object)control.getItem(2));
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(2));
        control = null;
        shell.dispose();
        shell = null;
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        ListRidgetTest.assertSame(ListRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testUpdateFromModel() {
        org.eclipse.swt.widgets.List control = this.getWidget();
        IListRidget ridget = this.getRidget();
        int oldCount = this.manager.getPersons().size();
        ListRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        this.manager.getPersons().remove(this.person1);
        int newCount = oldCount - 1;
        ListRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        ridget.updateFromModel();
        ListRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        ListRidgetTest.assertEquals((int)newCount, (int)ridget.getObservableList().size());
        ListRidgetTest.assertEquals((int)newCount, (int)control.getItemCount());
    }

    public void testUpdateFromModelPreservesSelection() {
        IListRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        ListRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person1);
        ridget.updateFromModel();
        ListRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
    }

    public void testContainsOption() {
        IListRidget ridget = this.getRidget();
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person1));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person2));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
        ListRidgetTest.assertFalse((boolean)ridget.containsOption(null));
        ListRidgetTest.assertFalse((boolean)ridget.containsOption((Object)new Person("", "")));
        List<Person> persons = Arrays.asList(this.person3);
        PersonManager manager = new PersonManager(persons);
        ridget.bindToModel((Object)manager, "persons", Person.class, new String[]{"firstname"}, new String[]{""});
        ridget.updateFromModel();
        ListRidgetTest.assertFalse((boolean)ridget.containsOption((Object)this.person1));
        ListRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
    }

    public void testSetSelectionType() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ListRidgetTest.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        ListRidgetTest.assertTrue(((control.getStyle() & 2) != 0 ? 1 : 0) != 0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        ridget.setSelection(nArray);
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndices().length);
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        ridget.setSelection(nArray2);
        ListRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndices().length);
        ListRidgetTest.assertEquals((int)2, (int)control.getSelectionCount());
    }

    public void testAddDoubleClickListener() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        try {
            ridget.addDoubleClickListener(null);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTActionListener listener1 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener1);
        FTActionListener listener2 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener2);
        ridget.addDoubleClickListener((IActionListener)listener2);
        Event doubleClick = new Event();
        doubleClick.widget = control;
        doubleClick.type = 8;
        control.notifyListeners(8, doubleClick);
        ListRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ListRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeDoubleClickListener((IActionListener)listener1);
        control.notifyListeners(8, doubleClick);
        ListRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testSetComparator() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        TypedComparator comparator = new TypedComparator();
        try {
            ridget.setComparator(-1, (Comparator)comparator);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setComparator(1, (Comparator)comparator);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        int lastItemIndex = control.getItemCount() - 1;
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, (Comparator)comparator);
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((String)"John", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex));
    }

    public void testGetSortedColumn() {
        IListRidget ridget = this.getRidget();
        try {
            ridget.setSortedColumn(1);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setSortedColumn(-2);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(-1);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
    }

    public void testIsColumnSortable() {
        IListRidget ridget = this.getRidget();
        try {
            ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(-1));
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(1));
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(0));
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ListRidgetTest.assertTrue((boolean)ridget.isColumnSortable(0));
        ridget.setComparator(0, null);
        ListRidgetTest.assertFalse((boolean)ridget.isColumnSortable(0));
    }

    public void testSetColumnSortable() {
        IListRidget ridget = this.getRidget();
        try {
            ridget.setColumnSortable(0, true);
            ListRidgetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.ok();
        }
    }

    public void testSetSortedAscending() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"lastname"}, new String[]{""});
        ridget.updateFromModel();
        int lastItemIndex = control.getItemCount() - 1;
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        ridget.setSortedAscending(false);
        ListRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setSortedColumn(0);
        ListRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ListRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex));
        ridget.setSortedAscending(true);
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        ListRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0));
        ListRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex));
        ridget.setComparator(0, null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
    }

    public void testSetSortedAscendingFiresEvents() {
        IListRidget ridget = this.getRidget();
        ListRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.TRUE, Boolean.FALSE));
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.FALSE, Boolean.TRUE));
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
    }

    public void testSetSortedColumnFiresEvents() {
        IListRidget ridget = this.getRidget();
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", -1, 0));
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", 0, -1));
        ridget.setSortedColumn(-1);
        this.verifyPropertyChangeEvents();
    }

    public void testHasMoveableColumns() {
        IListRidget ridget = this.getRidget();
        ListRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        try {
            ridget.setMoveableColumns(true);
            ListRidgetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.ok();
        }
    }

    public void testOutputSingleSelectionCannotBeChangedFromUI() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), " ");
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), " ");
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), " ");
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), " ");
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testTogglingOutputDoesNotChangeSelection() {
        IListRidget ridget = this.getRidget();
        ridget.setSelection(0);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(true);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setSelection(null);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(false);
        ListRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
    }

    public void testDisabledListIsEmptyFromRidget() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ListRidgetTest.testDisabledListIsEmptyFromRidget()");
            return;
        }
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        ridget.setSelection((Object)this.person1);
        ListRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setSelection((Object)this.person2);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        ListRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledListIsEmptyFromModel() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ListRidgetTest.testDisabledListIsEmptyFromModel()");
            return;
        }
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        this.manager.setSelectedPerson(this.person1);
        ridget.updateSingleSelectionFromModel();
        ListRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person1, (Object)this.manager.getSelectedPerson());
        this.manager.setSelectedPerson(this.person2);
        ridget.updateSingleSelectionFromModel();
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        ListRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(control.getSelectionIndex()));
        ListRidgetTest.assertEquals((Object)this.person2, ridget.getSelection().get(0));
        ListRidgetTest.assertEquals((Object)this.person2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledDoesNotFireSelection() {
        IListRidget ridget = this.getRidget();
        FTPropertyChangeListener listener = new FTPropertyChangeListener();
        ridget.addPropertyChangeListener("selection", (PropertyChangeListener)listener);
        ridget.setSelection((Object)this.person1);
        int count = listener.getCount();
        ridget.setEnabled(false);
        ListRidgetTest.assertEquals((int)count, (int)listener.getCount());
        ridget.setSelection((Object)this.person2);
        count = listener.getCount();
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((count < listener.getCount() ? 1 : 0) != 0);
    }

    public void testDisableWithoutBoundModel() {
        ListRidget ridget = (ListRidget)this.createRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        ridget.setUIControl((Object)control);
        ListRidgetTest.assertNull((Object)ridget.getObservableList());
        ridget.setEnabled(false);
        ListRidgetTest.assertFalse((boolean)ridget.isEnabled());
        ListRidgetTest.assertFalse((boolean)control.isEnabled());
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ListRidgetTest.assertTrue((boolean)control.isEnabled());
    }

    public void testDisableAndClearOnBind() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ListRidgetTest.testDisableAndClearOnBind()");
            return;
        }
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        this.getRidget().bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        this.manager.setSelectedPerson(this.person1);
        ridget.updateSingleSelectionFromModel();
        ridget.setUIControl((Object)control);
        ListRidgetTest.assertFalse((boolean)control.isEnabled());
        ListRidgetTest.assertEquals((String)"", (String)control.getItem(0));
        ListRidgetTest.assertEquals((int)-1, (int)control.getSelectionIndex());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setEnabled(true);
        ListRidgetTest.assertTrue((boolean)control.isEnabled());
        ListRidgetTest.assertTrue((control.getItem(0).length() > 0 ? 1 : 0) != 0);
        ListRidgetTest.assertTrue((control.getSelectionIndex() > -1 ? 1 : 0) != 0);
        ListRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)control.getItemCount());
        ListRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    public void testAddSelectionListener() {
        IListRidget ridget = this.getRidget();
        org.eclipse.swt.widgets.List control = this.getWidget();
        try {
            ridget.addSelectionListener(null);
            ListRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.person1);
        ListRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.person2);
        ListRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.clearSelection();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        ListRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ListRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
        SelectionEvent selectionEvent = selectionListener.getSelectionEvent();
        ListRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        ListRidgetTest.assertTrue((boolean)selectionEvent.getOldSelection().isEmpty());
        ListRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent.getNewSelection());
        System.out.println("SelectionEvent: " + selectionListener.getSelectionEvent());
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        ListRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        ListRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ListRidgetTest.assertEquals((int)3, (int)selectionListener.getCount());
        SelectionEvent selectionEvent2 = selectionListener.getSelectionEvent();
        ListRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        ListRidgetTest.assertEquals((Object)selectionEvent.getNewSelection(), (Object)selectionEvent2.getOldSelection());
        ListRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent2.getNewSelection());
        System.out.println("SelectionEvent: " + selectionListener.getSelectionEvent());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
    }

    protected void clearUIControlRowSelection() {
        this.getWidget().deselectAll();
        this.fireSelectionEvent();
    }

    protected int getUIControlSelectedRowCount() {
        return this.getWidget().getSelectionCount();
    }

    protected int getUIControlSelectedRow() {
        return this.getWidget().getSelectionIndex();
    }

    protected Object getRowValue(int i) {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        return rowObservables.get(i);
    }

    protected int[] getSelectedRows() {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        Object[] elements = this.getRidget().getMultiSelectionObservable().toArray();
        int[] result = new int[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            result[i] = rowObservables.indexOf(element);
            ++i;
        }
        return result;
    }

    protected int[] getUIControlSelectedRows() {
        return this.getWidget().getSelectionIndices();
    }

    protected void setUIControlRowSelection(int[] indices) {
        this.getWidget().setSelection(indices);
        this.fireSelectionEvent();
    }

    protected void setUIControlRowSelectionInterval(int start, int end) {
        this.getWidget().setSelection(start, end);
        this.fireSelectionEvent();
    }

    protected boolean supportsMulti() {
        return true;
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private int count;

        private FTPropertyChangeListener() {
        }

        public int getCount() {
            return this.count;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimplifiedModel {
        private List<String> values = Arrays.asList("Janet", "Jermaine", "John");
        private static final String NAME_ONE = "Janet";
        private static final String NAME_TWO = "Jermaine";
        private static final String NAME_THREE = "John";

        public List<String> getValues() {
            return this.values;
        }
    }
}

