/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MarkerSupportTest
extends RienaTestCase {
    private static final String HIDE_DISABLED_RIDGET_CONTENT = "HIDE_DISABLED_RIDGET_CONTENT";
    private Display display;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
    }

    protected void tearDown() {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testHideDisabledRidgetContentSystemProperty() throws IOException {
        System.clearProperty(HIDE_DISABLED_RIDGET_CONTENT);
        MarkerSupportTest.assertTrue((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
        System.setProperty(HIDE_DISABLED_RIDGET_CONTENT, Boolean.FALSE.toString());
        MarkerSupportTest.assertFalse((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
        System.setProperty(HIDE_DISABLED_RIDGET_CONTENT, Boolean.TRUE.toString());
        MarkerSupportTest.assertTrue((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
    }

    public void testCreateErrorDecoration() throws Exception {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            MarkerSupport support = new MarkerSupport(null, null);
            Text text = new Text((Composite)this.shell, 0);
            LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
            ControlDecoration deco = (ControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"createErrorDecoration", (Object[])new Object[]{text});
            MarkerSupportTest.assertEquals((int)100, (int)deco.getMarginWidth());
            MarkerSupportTest.assertNotNull((Object)deco.getImage());
            LnfManager.setLnf((RienaDefaultLnf)new MyNonsenseLnf());
            deco = (ControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"createErrorDecoration", (Object[])new Object[]{text});
            MarkerSupportTest.assertEquals((int)1, (int)deco.getMarginWidth());
            MarkerSupportTest.assertNotNull((Object)deco.getImage());
            support = null;
            SwtUtilities.disposeWidget((Widget)text);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
        }
    }

    private static boolean getHideDisabledRidgetContent() throws IOException {
        MarkSupportClassLoader freshLoader = new MarkSupportClassLoader();
        Class<?> markerSupportClass = freshLoader.getFreshMarkSupportClass();
        return (Boolean)ReflectionUtils.getHidden(markerSupportClass, (String)HIDE_DISABLED_RIDGET_CONTENT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkSupportClassLoader
    extends ClassLoader {
        public MarkSupportClassLoader() {
            super(MarkSupportClassLoader.class.getClassLoader());
        }

        public Class<?> getFreshMarkSupportClass() throws IOException {
            String resource = String.valueOf(MarkerSupport.class.getName().replace('.', '/')) + ".class";
            URL classURL = MarkerSupportTest.class.getClassLoader().getResource(resource);
            InputStream is = classURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int ch = -1;
            while ((ch = is.read()) != -1) {
                baos.write(ch);
            }
            byte[] bytes = baos.toByteArray();
            Class<?> cl = super.defineClass(MarkerSupport.class.getName(), bytes, 0, bytes.length);
            this.resolveClass(cl);
            return cl;
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        protected void initSettingsDefaults() {
            this.getSettingTable().put("errorMarker.margin", 100);
            this.getSettingTable().put("errorMarker.horizontalPosition", 131072);
            this.getSettingTable().put("errorMarker.verticalPosition", 1024);
        }
    }

    private static class MyNonsenseLnf
    extends RienaDefaultLnf {
        private MyNonsenseLnf() {
        }

        protected void initSettingsDefaults() {
        }

        protected void initImageDefaults() {
        }
    }
}

