/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.MasterDetailsRidget;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.DefaultBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterDetailsRidgetTest
extends AbstractSWTRidgetTest {
    private static final IBindingManager BINDING_MAN = new DefaultBindingManager((IBindingPropertyLocator)SWTBindingPropertyLocator.getInstance(), (IControlRidgetMapper)SwtControlRidgetMapper.getInstance());
    private final String[] columnProperties = new String[]{"column1", "column2"};
    private final String[] columnHeaders = new String[]{"TestColumn1Header", "TestColumn2Header"};
    private List<MDBean> input;
    private MDDelegate delegate;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.input = this.createInput(3);
        MasterDetailsRidget ridget = this.getRidget();
        List uiControls = this.getWidget().getUIControls();
        BINDING_MAN.injectRidgets((IRidgetContainer)ridget, uiControls);
        BINDING_MAN.bind((IRidgetContainer)ridget, uiControls);
        this.delegate = new MDDelegate();
        ridget.setDelegate((IMasterDetailsDelegate)this.delegate);
        this.getShell().setSize(300, 300);
    }

    @Override
    protected void tearDown() throws Exception {
        this.delegate = null;
        this.input = null;
        super.tearDown();
    }

    @Override
    protected Widget createWidget(Composite parent) {
        return new MDWidget(parent, 0);
    }

    @Override
    protected IRidget createRidget() {
        return new MasterDetailsRidget();
    }

    protected MDWidget getWidget() {
        return (MDWidget)super.getWidget();
    }

    protected MasterDetailsRidget getRidget() {
        return (MasterDetailsRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        MasterDetailsRidgetTest.assertSame(MasterDetailsRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testBindToModel() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget composite = this.getWidget();
        Table table = composite.getTable();
        MasterDetailsRidgetTest.assertEquals((int)0, (int)table.getItemCount());
        this.bindToModel(false);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)table.getItemCount());
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertEquals((int)2, (int)table.getColumnCount());
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        MasterDetailsRidgetTest.assertEquals((String)"TestColumn1Header", (String)table.getColumn(0).getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestColumn2Header", (String)table.getColumn(1).getText());
        this.assertContent(table, 3);
    }

    public void testSetUIControl() {
        MasterDetailsRidget ridget = this.getRidget();
        Table table = this.getWidget().getTable();
        MasterDetailsComposite mdComposite2 = (MasterDetailsComposite)this.createWidget((Composite)this.getShell());
        Table table2 = mdComposite2.getTable();
        MasterDetailsRidgetTest.assertEquals((int)0, (int)table.getItemCount());
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        this.bindUIControl((IMasterDetailsRidget)ridget, mdComposite2);
        this.input.remove(0);
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        MasterDetailsRidgetTest.assertEquals((int)2, (int)table2.getItemCount());
        this.unbindUIControl((IMasterDetailsRidget)ridget, mdComposite2);
        this.input.remove(0);
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        MasterDetailsRidgetTest.assertEquals((int)2, (int)table2.getItemCount());
        try {
            ridget.setUIControl((Object)new Table((Composite)this.getShell(), 2));
            MasterDetailsRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("does not allow SWT.MULTI");
        }
    }

    public void testAddBean() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget("txtColumn1");
        ITextRidget txtColumn2 = (ITextRidget)ridget.getRidget("txtColumn2");
        this.bindToModel(true);
        int oldSize = this.input.size();
        ridget.setSelection((Object)this.input.get(0));
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C1", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C2", (String)widget.txtColumn2.getText());
        ridget.handleAdd();
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)widget.txtColumn1.isFocusControl());
        MasterDetailsRidgetTest.assertEquals((int)oldSize, (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
        widget.txtColumn1.setFocus();
        UITestHelper.sendString(widget.getDisplay(), "A\r");
        widget.txtColumn2.setFocus();
        UITestHelper.sendString(widget.getDisplay(), "B\r");
        ridget.handleApply();
        MDBean newEntry = this.input.get(oldSize);
        MasterDetailsRidgetTest.assertEquals((int)(oldSize + 1), (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((String)"A", (String)newEntry.column1);
        MasterDetailsRidgetTest.assertEquals((String)"B", (String)newEntry.column2);
        MasterDetailsRidgetTest.assertEquals((Object)((Object)newEntry), (Object)ridget.getSelection());
        this.delegate.setTxtColumn1IsEnabled(false);
        ridget.handleAdd();
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
    }

    public void testDeleteBean() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        Table table = widget.getTable();
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget("txtColumn1");
        ITextRidget txtColumn2 = (ITextRidget)ridget.getRidget("txtColumn2");
        this.bindToModel(true);
        this.assertContent(table, 3);
        MasterDetailsRidgetTest.assertEquals((int)3, (int)this.input.size());
        MDBean toDelete = this.input.get(1);
        ridget.setSelection((Object)toDelete);
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        ridget.handleRemove();
        MasterDetailsRidgetTest.assertEquals((int)2, (int)this.input.size());
        MasterDetailsRidgetTest.assertFalse((boolean)this.input.contains((Object)toDelete));
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn2.isEnabled());
    }

    public void testModifyBean() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        Table table = widget.getTable();
        this.bindToModel(true);
        this.assertContent(table, 3);
        MasterDetailsRidgetTest.assertEquals((int)3, (int)this.input.size());
        ridget.setSelection((Object)this.input.get(1));
        widget.txtColumn1.setFocus();
        UITestHelper.sendString(widget.getDisplay(), "A\r");
        widget.txtColumn2.setFocus();
        UITestHelper.sendString(widget.getDisplay(), "B\r");
        ridget.handleApply();
        MasterDetailsRidgetTest.assertEquals((int)3, (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((String)"A", (String)this.input.get(1).getColumn1());
        MasterDetailsRidgetTest.assertEquals((String)"B", (String)this.input.get(1).getColumn2());
    }

    public void testSetSelection() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ridget.setSelection((Object)this.input.get(0));
        MasterDetailsRidgetTest.assertEquals((Object)((Object)this.input.get(0)), (Object)ridget.getSelection());
        ridget.setSelection(null);
        MasterDetailsRidgetTest.assertEquals(null, (Object)ridget.getSelection());
    }

    public void testSetSelectionUpdatesUI() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        this.bindToModel(true);
        ridget.setSelection((Object)this.input.get(1));
        MasterDetailsRidgetTest.assertEquals((int)1, (int)widget.getTable().getSelectionCount());
        MasterDetailsRidgetTest.assertEquals((String)"TestR1C1", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestR1C2", (String)widget.txtColumn2.getText());
        ridget.setSelection(null);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)widget.getTable().getSelectionCount());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
    }

    public void testSetSelectionRevealsSelection() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        this.input = this.createInput(42);
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)widget.getTable().getTopIndex());
        ridget.setSelection((Object)this.input.get(30));
        MasterDetailsRidgetTest.assertTrue((widget.getTable().getTopIndex() > 0 ? 1 : 0) != 0);
    }

    public void testUpdateFromModelPreservesSelection() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        MDBean item2 = this.input.get(2);
        ridget.setSelection((Object)item2);
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
        this.input.remove((Object)this.input.get(1));
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
    }

    public void testUpdateFromModelRemovesSelection() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        MDBean item2 = this.input.get(2);
        ridget.setSelection((Object)item2);
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
        this.input.remove((Object)this.input.get(2));
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertNull((Object)ridget.getSelection());
    }

    public void testUpdateSelectionFromRidgetOnRebind() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        this.unbindUIControl((IMasterDetailsRidget)ridget, widget);
        this.bindToModel(true);
        ridget.setSelection((Object)this.input.get(0));
        MasterDetailsRidgetTest.assertEquals((int)0, (int)widget.getTable().getSelectionCount());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
        MDWidget widget2 = (MDWidget)this.createWidget((Composite)this.getShell());
        this.bindUIControl((IMasterDetailsRidget)ridget, widget2);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)widget2.getTable().getSelectionCount());
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C1", (String)widget2.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C2", (String)widget2.txtColumn2.getText());
    }

    public void testSetSelectionFiresEvents() {
        MasterDetailsRidget ridget = this.getRidget();
        MDBean item0 = this.input.get(0);
        FTPropertyChangeListener listener = new FTPropertyChangeListener();
        this.bindToModel(true);
        ridget.addPropertyChangeListener("selection", (PropertyChangeListener)listener);
        ridget.setSelection((Object)item0);
        List oldSelection = Collections.EMPTY_LIST;
        List newSelection = Arrays.asList(new Object[]{item0});
        this.assertPropertyChangeEvent(1, oldSelection, newSelection, listener);
        ridget.setSelection((Object)item0);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)listener.count);
        MDBean item1 = this.input.get(1);
        ridget.setSelection((Object)item1);
        oldSelection = newSelection;
        newSelection = Arrays.asList(new Object[]{item1});
        this.assertPropertyChangeEvent(2, oldSelection, newSelection, listener);
        ridget.setSelection(null);
        oldSelection = newSelection;
        newSelection = Collections.EMPTY_LIST;
        this.assertPropertyChangeEvent(3, oldSelection, newSelection, listener);
    }

    public void testHandleSelectionChange() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget("txtColumn1");
        ITextRidget txtColumn2 = (ITextRidget)ridget.getRidget("txtColumn2");
        MDBean item0 = this.input.get(0);
        ridget.setSelection((Object)item0);
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        ridget.setSelection(null);
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn2.isEnabled());
        this.delegate.setTxtColumn1IsEnabled(false);
        ridget.setSelection((Object)item0);
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        ridget.setSelection(null);
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn2.isEnabled());
    }

    public void testDeselectOnApplyWithOneItem() {
        MasterDetailsRidget ridget = this.getRidget();
        this.input = this.createInput(1);
        this.bindToModel(true);
        MDBean item0 = this.input.get(0);
        ridget.setSelection((Object)item0);
        MasterDetailsRidgetTest.assertEquals((Object)((Object)item0), (Object)ridget.getSelection());
        ridget.handleApply();
        MasterDetailsRidgetTest.assertEquals(null, (Object)ridget.getSelection());
    }

    private void assertContent(Table table, int items) {
        int i = 0;
        while (i < items) {
            String label0 = String.format("TestR%dC1", i);
            String label1 = String.format("TestR%dC2", i);
            MasterDetailsRidgetTest.assertEquals((String)label0, (String)table.getItem(i).getText(0));
            MasterDetailsRidgetTest.assertEquals((String)label1, (String)table.getItem(i).getText(1));
            ++i;
        }
    }

    private void assertPropertyChangeEvent(int count, Object oldValue, Object newValue, FTPropertyChangeListener listener) {
        MasterDetailsRidgetTest.assertEquals((int)count, (int)listener.count);
        MasterDetailsRidgetTest.assertEquals((String)"selection", (String)listener.event.getPropertyName());
        MasterDetailsRidgetTest.assertEquals((Object)oldValue, (Object)listener.event.getOldValue());
        MasterDetailsRidgetTest.assertEquals((Object)newValue, (Object)listener.event.getNewValue());
    }

    private void bindToModel(boolean withUpdate) {
        WritableList list = new WritableList(this.input, MDBean.class);
        this.getRidget().bindToModel((IObservableList)list, MDBean.class, this.columnProperties, this.columnHeaders);
        if (withUpdate) {
            this.getRidget().updateFromModel();
        }
    }

    private void bindUIControl(IMasterDetailsRidget ridget, MasterDetailsComposite control) {
        ridget.setUIControl((Object)control);
        BINDING_MAN.bind((IRidgetContainer)ridget, control.getUIControls());
    }

    private List<MDBean> createInput(int numItems) {
        ArrayList<MDBean> result = new ArrayList<MDBean>();
        int i = 0;
        while (i < numItems) {
            String c1 = String.format("TestR%dC1", i);
            String c2 = String.format("TestR%dC2", i);
            result.add(new MDBean(c1, c2));
            ++i;
        }
        return result;
    }

    private void unbindUIControl(IMasterDetailsRidget ridget, MasterDetailsComposite control) {
        ridget.setUIControl(null);
        BINDING_MAN.unbind((IRidgetContainer)ridget, control.getUIControls());
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private int count;
        private PropertyChangeEvent event;

        private FTPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ++this.count;
            this.event = event;
        }
    }

    private static final class MDBean
    extends AbstractBean {
        private static final String PROPERTY_COLUMN_1 = "column1";
        private static final String PROPERTY_COLUMN_2 = "column2";
        private String column1;
        private String column2;

        MDBean(String column1, String column2) {
            this.column1 = column1;
            this.column2 = column2;
        }

        public String getColumn1() {
            return this.column1;
        }

        public String getColumn2() {
            return this.column2;
        }

        public void setColumn1(String column1) {
            this.column1 = column1;
            this.firePropertyChanged(PROPERTY_COLUMN_1, this.column1, this.column1);
        }

        public void setColumn2(String column2) {
            this.column2 = column2;
            this.firePropertyChanged(PROPERTY_COLUMN_2, this.column2, this.column2);
        }

        public String toString() {
            return String.format("[%s, %s]", this.column1, this.column2);
        }
    }

    private static class MDDelegate
    implements IMasterDetailsDelegate {
        private final MDBean workingCopy = this.createWorkingCopy();
        private boolean txtColumn1Isenabled = true;

        private MDDelegate() {
        }

        public void configureRidgets(IRidgetContainer container) {
            ITextRidget txtColumn1 = (ITextRidget)container.getRidget("txtColumn1");
            txtColumn1.bindToModel((Object)this.workingCopy, "column1");
            txtColumn1.updateFromModel();
            ITextRidget txtColumn2 = (ITextRidget)container.getRidget("txtColumn2");
            txtColumn2.bindToModel((Object)this.workingCopy, "column2");
            txtColumn2.updateFromModel();
        }

        public Object copyBean(Object source, Object target) {
            MDBean from = source == null ? this.createWorkingCopy() : (MDBean)((Object)source);
            MDBean to = target == null ? this.createWorkingCopy() : (MDBean)((Object)target);
            to.setColumn1(from.getColumn1());
            to.setColumn2(from.getColumn2());
            return to;
        }

        public MDBean createWorkingCopy() {
            return new MDBean("", "");
        }

        public MDBean getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isChanged(Object source, Object target) {
            return true;
        }

        public String isValid(IRidgetContainer container) {
            return null;
        }

        public void updateDetails(IRidgetContainer container) {
            ITextRidget txtColumn1 = (ITextRidget)container.getRidget("txtColumn1");
            txtColumn1.setEnabled(this.isTxtColumn1IsEnabled());
            for (IRidget ridget : container.getRidgets()) {
                ridget.updateFromModel();
            }
        }

        public void setTxtColumn1IsEnabled(boolean enabled) {
            this.txtColumn1Isenabled = enabled;
        }

        public boolean isTxtColumn1IsEnabled() {
            return this.txtColumn1Isenabled;
        }
    }

    private static final class MDWidget
    extends MasterDetailsComposite {
        private Text txtColumn1;
        private Text txtColumn2;

        public MDWidget(Composite parent, int style) {
            super(parent, style, 1024);
        }

        protected void createDetails(Composite parent) {
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
            GridDataFactory hFill = GridDataFactory.fillDefaults().grab(true, false);
            this.txtColumn1 = UIControlsFactory.createText((Composite)parent);
            hFill.applyTo((Control)this.txtColumn1);
            this.addUIControl(this.txtColumn1, "txtColumn1");
            this.txtColumn2 = UIControlsFactory.createText((Composite)parent);
            hFill.applyTo((Control)this.txtColumn2);
            this.addUIControl(this.txtColumn2, "txtColumn2");
        }
    }
}

