/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.tests.FTActionListener;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuItemRidgetTest
extends AbstractSWTRidgetTest {
    private static final String ICON_ECLIPSE = "eclipse.gif";
    private static final String LABEL = "testlabel";
    private static final String LABEL2 = "testlabel2";

    protected MenuItemRidget createRidget() {
        return new MenuItemRidget();
    }

    protected MenuItem createWidget(Composite parent) {
        Menu menu = new Menu((Control)parent);
        return new MenuItem(menu, 0);
    }

    protected MenuItem getWidget() {
        return (MenuItem)super.getWidget();
    }

    protected MenuItemRidget getRidget() {
        return (MenuItemRidget)super.getRidget();
    }

    public void testIsVisible() {
        this.getShell().open();
        MenuItemRidgetTest.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isVisible());
        MenuItemRidgetTest.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getWidget().isDisposed());
        this.getRidget().setVisible(false);
        MenuItemRidgetTest.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isVisible());
        MenuItemRidgetTest.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getWidget().isDisposed());
        this.getRidget().setVisible(true);
        MenuItemRidgetTest.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isVisible());
        MenuItemRidgetTest.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getWidget().isDisposed());
        MenuItemRidgetTest.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().getUIControl().isDisposed());
    }

    public void testMenuItemRidget() {
        MenuItemRidget item = new MenuItemRidget();
        boolean textAlreadyInitialized = (Boolean)ReflectionUtils.getHidden((Object)item, (String)"textAlreadyInitialized");
        MenuItemRidgetTest.assertFalse((boolean)textAlreadyInitialized);
        boolean useRidgetIcon = (Boolean)ReflectionUtils.getHidden((Object)item, (String)"useRidgetIcon");
        MenuItemRidgetTest.assertFalse((boolean)useRidgetIcon);
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        MenuItemRidgetTest.assertSame(MenuItemRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public final void testSetText() throws Exception {
        MenuItemRidget ridget = this.getRidget();
        MenuItem widget = this.getWidget();
        ridget.setText("");
        MenuItemRidgetTest.assertEquals((String)"", (String)ridget.getText());
        MenuItemRidgetTest.assertEquals((String)"", (String)widget.getText());
        try {
            ridget.setText(null);
            MenuItemRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        ridget.setText(LABEL);
        MenuItemRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        MenuItemRidgetTest.assertEquals((String)LABEL, (String)widget.getText());
        ridget.setUIControl(null);
        ridget.setText(LABEL2);
        MenuItemRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        MenuItemRidgetTest.assertEquals((String)LABEL, (String)widget.getText());
        ridget.setUIControl((Object)widget);
        MenuItemRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        MenuItemRidgetTest.assertEquals((String)LABEL2, (String)widget.getText());
    }

    public final void testSetIcon() {
        MenuItemRidget ridget = this.getRidget();
        MenuItem widget = ridget.getUIControl();
        ridget.setIcon(ICON_ECLIPSE);
        MenuItemRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)ridget.getIcon());
        MenuItemRidgetTest.assertNotNull((Object)widget.getImage());
        ridget.setIcon(null);
        MenuItemRidgetTest.assertNull((Object)ridget.getIcon());
        MenuItemRidgetTest.assertNull((Object)widget.getImage());
        MenuItem button = this.createWidget((Composite)this.getShell());
        Image buttonImage = button.getDisplay().getSystemImage(2);
        button.setImage(buttonImage);
        MenuItemRidget buttonRidget = this.createRidget();
        buttonRidget.setUIControl((Object)button);
        MenuItemRidgetTest.assertSame((Object)buttonImage, (Object)button.getImage());
        buttonRidget.setIcon(null);
        MenuItemRidgetTest.assertNull((Object)buttonRidget.getIcon());
        MenuItemRidgetTest.assertNull((Object)button.getImage());
        buttonRidget.setIcon(ICON_ECLIPSE);
        MenuItemRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)buttonRidget.getIcon());
        MenuItemRidgetTest.assertNotNull((Object)button.getImage());
        MenuItemRidgetTest.assertNotSame((Object)buttonImage, (Object)button.getImage());
        button = this.createWidget((Composite)this.getShell());
        button.setImage(buttonImage);
        buttonRidget = this.createRidget();
        buttonRidget.setIcon(ICON_ECLIPSE);
        buttonRidget.setUIControl((Object)button);
        MenuItemRidgetTest.assertNotNull((Object)button.getImage());
        MenuItemRidgetTest.assertNotSame((Object)buttonImage, (Object)button.getImage());
    }

    public void testInitText() {
        MenuItemRidget ridget = this.getRidget();
        MenuItem widget = ridget.getUIControl();
        ReflectionUtils.setHidden((Object)ridget, (String)"textAlreadyInitialized", (Object)false);
        ReflectionUtils.setHidden((Object)ridget, (String)"text", null);
        widget.setText("Hello!");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        MenuItemRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        MenuItemRidgetTest.assertEquals((String)"Hello!", (String)widget.getText());
        MenuItemRidgetTest.assertTrue((boolean)((Boolean)ReflectionUtils.getHidden((Object)ridget, (String)"textAlreadyInitialized")));
        widget.setText("World");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        MenuItemRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        MenuItemRidgetTest.assertEquals((String)"World", (String)widget.getText());
    }

    public void testAddListener() {
        MenuItem widget = this.getWidget();
        MenuItemRidget ridget = this.getRidget();
        FTActionListener listener1 = new FTActionListener();
        FTActionListener listener2 = new FTActionListener();
        ridget.addListener((IActionListener)listener1);
        ridget.addListener((IActionListener)listener2);
        ridget.addListener((IActionListener)listener2);
        this.fireSelectionEvent(widget);
        MenuItemRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        MenuItemRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener1);
        this.fireSelectionEvent(widget);
        MenuItemRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        MenuItemRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener2);
        this.fireSelectionEvent(widget);
        MenuItemRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        MenuItemRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener2);
        this.fireSelectionEvent(widget);
        MenuItemRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        MenuItemRidgetTest.assertEquals((int)2, (int)listener2.getCount());
    }

    public void testApplyEnabledToUIControl() {
        MenuItemRidget ridget = this.createRidget();
        MenuItem item = this.createWidget((Composite)this.getShell());
        item.setEnabled(false);
        ridget.setEnabled(true);
        ridget.setUIControl((Object)item);
        MenuItemRidgetTest.assertTrue((boolean)ridget.isEnabled());
        MenuItemRidgetTest.assertTrue((boolean)item.isEnabled());
        MenuItemRidgetTest.assertEquals((int)0, (int)((IBasicMarkableRidget)ridget).getMarkersOfType(DisabledMarker.class).size());
    }

    private void fireSelectionEvent(MenuItem control) {
        Event event = new Event();
        event.type = 13;
        event.widget = control;
        control.notifyListeners(13, event);
    }
}

