/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.beans.common.IntegerBean;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidgetTest;
import org.eclipse.riena.tests.TestUtils;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.validation.MaxLength;
import org.eclipse.riena.ui.ridgets.validation.MaxNumberLength;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NumericTextRidgetTest
extends TextRidgetTest {
    private static final Integer INTEGER_ONE = 471;
    private static final Integer INTEGER_TWO = 23;

    protected IRidget createRidget() {
        return new NumericTextRidget();
    }

    protected INumericTextRidget getRidget() {
        return (INumericTextRidget)super.getRidget();
    }

    protected Control createWidget(Composite parent) {
        Text result = new Text((Composite)this.getShell(), 133124);
        result.setData("type", (Object)"numeric");
        result.setLayoutData((Object)new RowData(100, -1));
        return result;
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        NumericTextRidgetTest.assertSame(NumericTextRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testCreate() throws Exception {
        NumericTextRidgetTest.assertFalse((boolean)this.getRidget().isDirectWriting());
        NumericTextRidgetTest.assertEquals((String)"0", (String)this.getRidget().getText());
    }

    public void testSetText() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        ridget.setText("");
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.setText("-1234");
        NumericTextRidgetTest.assertEquals((String)this.localize("-1.234"), (String)ridget.getText());
        ridget.setText("1234");
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        ridget.setText(this.localize("98.765"));
        NumericTextRidgetTest.assertEquals((String)this.localize("98.765"), (String)ridget.getText());
        try {
            ridget.setText(this.localize("98.765,12"));
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
        try {
            ridget.setText("abcd");
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
        try {
            ridget.setText("a,bcd");
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
    }

    public void testSetTextNoGroup() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        ridget.setGrouping(false);
        ridget.setText("");
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.setText("-1234");
        NumericTextRidgetTest.assertEquals((String)"-1234", (String)ridget.getText());
        ridget.setText("1234");
        NumericTextRidgetTest.assertEquals((String)"1234", (String)ridget.getText());
        ridget.setText(this.localize("98.765"));
        NumericTextRidgetTest.assertEquals((String)"98765", (String)ridget.getText());
        try {
            ridget.setText(this.localize("98.765,12"));
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
        try {
            ridget.setText("abcd");
            NumericTextRidgetTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            this.ok();
        }
    }

    public void testSetTextNull() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setText("42");
        NumericTextRidgetTest.assertEquals((String)"42", (String)ridget.getText());
        ridget.setText(null);
        NumericTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
    }

    public void testGetText() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
    }

    public void testBindToModelPropertyName() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)ridget.getText());
    }

    public void testUpdateFromModel() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        model.setValue(Integer.valueOf(-7));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)this.localize("-7"), (String)ridget.getText());
    }

    public void testBindToModelIObservableValue() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean model = new IntegerBean(4711);
        IObservableValue modelOV = BeansObservables.observeValue((Object)model, (String)"value");
        ridget.bindToModel(modelOV);
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)this.localize("4.711"), (String)ridget.getText());
    }

    public void testFocusGainedDoesSelectOnSingleText() {
        Text control = this.getWidget();
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getSelectionText());
        control.setSelection(0, 0);
        Event e = new Event();
        e.type = 15;
        e.widget = control;
        e.widget.notifyListeners(e.type, e);
        NumericTextRidgetTest.assertEquals((int)0, (int)(control.getStyle() & 2));
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getSelectionText());
    }

    public void testFocusGainedDoesNotSelectOnMultiLineText() {
        NumericTextRidgetTest.assertTrue((boolean)true);
    }

    public void testCheckWidget() {
        INumericTextRidget ridget = this.getRidget();
        Text control = new Text((Composite)this.getShell(), 2);
        try {
            ridget.setUIControl((Object)control);
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setUIControl((Object)new Button((Composite)this.getShell(), 8));
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSignedTrue() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isSigned());
        this.expectNoPropertyChangeEvent();
        ridget.setSigned(true);
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isSigned());
        int caretPos = control.getText().length() - 1;
        this.focusIn(control);
        control.setSelection(caretPos, caretPos);
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)caretPos, (int)control.getCaretPosition());
        UITestHelper.sendString(control.getDisplay(), "-");
        NumericTextRidgetTest.assertEquals((String)this.localize("-1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)(caretPos + 1), (int)control.getCaretPosition());
        control.setSelection(1, 1);
        UITestHelper.sendString(control.getDisplay(), "\b");
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)0, (int)control.getCaretPosition());
    }

    public void testSetSignedFalse() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isSigned());
        this.expectPropertyChangeEvent("signed", Boolean.TRUE, Boolean.FALSE);
        ridget.setSigned(false);
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isSigned());
        int caretPos = control.getText().length() - 1;
        this.focusIn(control);
        control.setSelection(caretPos, caretPos);
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)caretPos, (int)control.getCaretPosition());
        UITestHelper.sendString(control.getDisplay(), "-");
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((int)caretPos, (int)control.getCaretPosition());
    }

    public void testSetSignedThrowsException() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setText("1234");
        ridget.setSigned(false);
        try {
            ridget.setText("-4711");
            NumericTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
    }

    public void testSetGrouping() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean model = new IntegerBean(1337);
        ridget.bindToModel((Object)model, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isGrouping());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)ridget.getText());
        ridget.setGrouping(false);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isGrouping());
        NumericTextRidgetTest.assertEquals((String)"1337", (String)ridget.getText());
        ridget.setGrouping(true);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isGrouping());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.337"), (String)ridget.getText());
    }

    public void testUpdateFromControlUserInput() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        Display display = control.getDisplay();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isDirectWriting());
        UITestHelper.sendString(display, "47");
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)0, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "0", "47"), new PropertyChangeEvent(ridget, "textAfter", "0", "47"));
        UITestHelper.sendString(display, "\r");
        UITestHelper.readAndDispatch((Widget)control);
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)47, (Object)bean.getValue());
        this.expectNoPropertyChangeEvent();
        UITestHelper.sendString(display, "1");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"471", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)47, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "47", "471"), new PropertyChangeEvent(ridget, "textAfter", "47", "471"));
        UITestHelper.sendString(display, "\t");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"471", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"471", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)471, (Object)bean.getValue());
    }

    public void testUpdateFromControlUserInputDirectWriting() {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        ridget.setDirectWriting(true);
        Display display = control.getDisplay();
        UITestHelper.sendString(display, "4");
        NumericTextRidgetTest.assertEquals((String)"4", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"4", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)4, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "4", "47"), new PropertyChangeEvent(ridget, "textAfter", "4", "47"));
        UITestHelper.sendString(display, "7");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)47, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "47", "471"), new PropertyChangeEvent(ridget, "textAfter", "47", "471"));
        UITestHelper.sendString(display, "1");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"471", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"471", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)471, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "471", this.localize("4.711")), new PropertyChangeEvent(ridget, "textAfter", "471", this.localize("4.711")));
        UITestHelper.sendString(display, "1");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)this.localize("4.711"), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("4.711"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)4711, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", this.localize("4.711"), "471"), new PropertyChangeEvent(ridget, "textAfter", this.localize("4.711"), "471"));
        UITestHelper.sendKeyAction(display, 0x1000003);
        UITestHelper.sendString(display, "\b");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"471", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"471", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)Integer.valueOf("471"), (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "471", "47"), new PropertyChangeEvent(ridget, "textAfter", "471", "47"));
        UITestHelper.sendString(display, String.valueOf('\u007f'));
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)47, (Object)bean.getValue());
        this.expectNoPropertyChangeEvent();
        bean.setValue(Integer.valueOf(4711));
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"47", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"47", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)4711, (Object)bean.getValue());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "47", "4"), new PropertyChangeEvent(ridget, "textAfter", "47", "4"));
        UITestHelper.sendString(display, "\b");
        this.verifyPropertyChangeEvents();
        NumericTextRidgetTest.assertEquals((String)"4", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"4", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)Integer.valueOf("4"), (Object)bean.getValue());
    }

    public void testUpdateFromRidgetOnRebind() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        bean.setValue(INTEGER_ONE);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
        ridget.setUIControl(null);
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "99");
        NumericTextRidgetTest.assertEquals((String)"99", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
        ridget.setUIControl((Object)control);
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
        ridget.setUIControl(null);
        bean.setValue(INTEGER_TWO);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_TWO, (Object)bean.getValue());
        ridget.setUIControl((Object)control);
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_TWO, (Object)bean.getValue());
    }

    public void testValidationOnUpdateToModel() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        ridget.addValidationRule((IValidator)new MinLength(3), ValidationTime.ON_UPDATE_TO_MODEL);
        bean.setValue(INTEGER_ONE);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "99\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        NumericTextRidgetTest.assertEquals((String)"99", (String)ridget.getText());
        this.focusIn(control);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000008);
        UITestHelper.sendString(control.getDisplay(), "9");
        NumericTextRidgetTest.assertFalse((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        UITestHelper.sendString(control.getDisplay(), "\r");
        NumericTextRidgetTest.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        NumericTextRidgetTest.assertEquals((String)"999", (String)ridget.getText());
    }

    public void testCharactersAreBlockedInControl() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        ridget.setDirectWriting(true);
        UITestHelper.sendString(control.getDisplay(), "12");
        NumericTextRidgetTest.assertEquals((String)"12", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)12, (Object)bean.getValue());
        UITestHelper.sendString(control.getDisplay(), "foo");
        NumericTextRidgetTest.assertEquals((String)"12", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)12, (Object)bean.getValue());
    }

    public void testValidationOnUpdateFromModelWithOnEditRule() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addValidationRule((IValidator)new MaxLength(5), ValidationTime.ON_UI_CONTROL_EDIT);
        bean.setValue(Integer.valueOf(123456));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)123456, (Object)bean.getValue());
        bean.setValue(Integer.valueOf(1234));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)1234, (Object)bean.getValue());
    }

    public void testValidationOnUpdateFromModelWithOnUpdateRule() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean(Integer.valueOf(123456));
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addValidationRule((IValidator)new MinLength(5), ValidationTime.ON_UPDATE_TO_MODEL);
        bean.setValue(Integer.valueOf(123));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"123", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)"123", (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)123, (Object)bean.getValue());
        bean.setValue(Integer.valueOf(1234));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)this.getWidget().getText());
        NumericTextRidgetTest.assertEquals((Object)1234, (Object)bean.getValue());
    }

    public void testUpdateFromRidgetWithValidationOnEditRule() {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean(Integer.valueOf(1234));
        ridget.addValidationRule((IValidator)new MinLength(5), ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertFalse((boolean)ridget.isDirectWriting());
        UITestHelper.sendString(control.getDisplay(), "98765\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("98.765"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98765, (Object)bean.getValue());
        this.focusIn(control);
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "12\t");
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98765, (Object)bean.getValue());
        this.focusIn(control);
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "43210\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("43.210"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)43210, (Object)bean.getValue());
    }

    public void testUpdateFromRidgetWithValidationOnUpdateRule() {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean();
        ridget.addValidationRule((IValidator)new EndsWithFive(), ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.bindToModel((Object)bean, "value");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertFalse((boolean)ridget.isDirectWriting());
        UITestHelper.sendString(control.getDisplay(), "98765\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("98.765"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98765, (Object)bean.getValue());
        this.focusIn(control);
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "98\t");
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"98", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98765, (Object)bean.getValue());
        this.focusIn(control);
        control.setSelection(2, 2);
        UITestHelper.sendString(control.getDisplay(), "555\t");
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)this.localize("98.555"), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)98555, (Object)bean.getValue());
    }

    public void testValidationMessageWithOnEditRule() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        ridget.addValidationRule((IValidator)new EvenNumberOfCharacters(), ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.setDirectWriting(true);
        ridget.addValidationMessage("ValidationErrorMessage");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkers().size());
        UITestHelper.sendString(control.getDisplay(), "1");
        NumericTextRidgetTest.assertEquals((int)2, (int)ridget.getMarkers().size());
        for (IMarker next : ridget.getMarkers()) {
            NumericTextRidgetTest.assertTrue((boolean)(next instanceof IMessageMarker));
            IMessageMarker marker = (IMessageMarker)next;
            NumericTextRidgetTest.assertTrue((marker.getMessage().equals("ValidationErrorMessage") || marker.getMessage().equals("Odd number of characters.") ? 1 : 0) != 0);
        }
        UITestHelper.sendString(control.getDisplay(), "2");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkers().size());
    }

    public void testValidationMessageWithOnUpdateRule() throws Exception {
        Text control = this.getWidget();
        INumericTextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)new IntegerBean(12345), "value");
        ridget.addValidationRule((IValidator)new EvenNumberOfCharacters(), ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.setDirectWriting(true);
        ridget.addValidationMessage("ValidationErrorMessage");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkers().size());
        UITestHelper.sendString(control.getDisplay(), "1\r");
        NumericTextRidgetTest.assertEquals((int)2, (int)ridget.getMarkers().size());
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "ValidationErrorMessage");
        UITestHelper.sendString(control.getDisplay(), "2\r");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkers().size());
    }

    public void testRevalidateOnEditRule() {
        INumericTextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)new IntegerBean(123), "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        EvenNumberOfCharacters rule = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)rule, ValidationTime.ON_UI_CONTROL_EDIT);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk1 = ridget.revalidate();
        NumericTextRidgetTest.assertFalse((boolean)isOk1);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)rule);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk2 = ridget.revalidate();
        NumericTextRidgetTest.assertTrue((boolean)isOk2);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testRevalidateOnUpdateRule() {
        INumericTextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)new IntegerBean(123), "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        EvenNumberOfCharacters rule = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)rule, ValidationTime.ON_UPDATE_TO_MODEL);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk1 = ridget.revalidate();
        NumericTextRidgetTest.assertFalse((boolean)isOk1);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)rule);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk2 = ridget.revalidate();
        NumericTextRidgetTest.assertTrue((boolean)isOk2);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testRevalidateDoesUpdate() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        EvenNumberOfCharacters evenChars = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)evenChars, ValidationTime.ON_UI_CONTROL_EDIT);
        IntegerBean bean = new IntegerBean(12);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        this.focusIn(control);
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "345\t");
        NumericTextRidgetTest.assertEquals((String)"345", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"345", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)12, (Object)bean.getValue());
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)evenChars);
        ridget.revalidate();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"345", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"345", (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)345, (Object)bean.getValue());
    }

    public void testReValidationOnUpdateFromModel() {
        INumericTextRidget ridget = this.getRidget();
        IntegerBean bean = new IntegerBean(12);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        EvenNumberOfCharacters rule = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)rule, ValidationTime.ON_UI_CONTROL_EDIT);
        bean.setValue(Integer.valueOf(321));
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((Object)321, (Object)bean.getValue());
        NumericTextRidgetTest.assertEquals((String)"321", (String)ridget.getText());
        ridget.removeValidationRule((IValidator)rule);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        NumericTextRidgetTest.assertEquals((Object)321, (Object)bean.getValue());
        NumericTextRidgetTest.assertEquals((String)"321", (String)ridget.getText());
    }

    public void testControlNotEditableWithOutputMarker() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        NumericTextRidgetTest.assertTrue((boolean)control.getEditable());
        ridget.setOutputOnly(true);
        NumericTextRidgetTest.assertFalse((boolean)control.getEditable());
        ridget.setOutputOnly(false);
        NumericTextRidgetTest.assertTrue((boolean)control.getEditable());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.setOutputOnly(true);
        control.selectAll();
        this.focusIn(control);
        UITestHelper.sendString(control.getDisplay(), "123\t");
        NumericTextRidgetTest.assertEquals((String)"0", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.setOutputOnly(false);
        control.selectAll();
        this.focusIn(control);
        UITestHelper.sendString(control.getDisplay(), "123\t");
        NumericTextRidgetTest.assertEquals((String)"123", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)"123", (String)ridget.getText());
    }

    public void testDisabledHasNoTextFromModel() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping TextRidgetTest2.testDisabledHasNoTextFromModel()");
            return;
        }
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        IntegerBean bean = new IntegerBean(INTEGER_TWO);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isEnabled());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_TWO, (Object)bean.getValue());
        ridget.setEnabled(false);
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_TWO.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_TWO, (Object)bean.getValue());
        bean.setValue(INTEGER_ONE);
        ridget.updateFromModel();
        NumericTextRidgetTest.assertEquals((String)"", (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
        ridget.setEnabled(true);
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)control.getText());
        NumericTextRidgetTest.assertEquals((String)INTEGER_ONE.toString(), (String)ridget.getText());
        NumericTextRidgetTest.assertEquals((Object)INTEGER_ONE, (Object)bean.getValue());
    }

    public void testMaxLength() throws Exception {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.addValidationRule((IValidator)new MaxNumberLength(5), ValidationTime.ON_UI_CONTROL_EDIT);
        this.focusIn(control);
        UITestHelper.sendString(control.getDisplay(), "1234");
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)control.getText());
        this.focusOut(control);
        NumericTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        this.focusIn(control);
        control.setSelection(control.getText().length());
        UITestHelper.sendString(control.getDisplay(), "5");
        NumericTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)control.getText());
        this.focusOut(control);
        NumericTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)control.getText());
        this.focusIn(control);
        control.setSelection(control.getText().length());
        UITestHelper.sendString(control.getDisplay(), "6");
        NumericTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)control.getText());
        this.focusOut(control);
        NumericTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)control.getText());
    }

    public void testSetMarkNegative() {
        INumericTextRidget ridget = this.getRidget();
        NumericTextRidgetTest.assertTrue((boolean)ridget.isMarkNegative());
        ridget.setMarkNegative(false);
        NumericTextRidgetTest.assertFalse((boolean)ridget.isMarkNegative());
        ridget.setMarkNegative(true);
        NumericTextRidgetTest.assertTrue((boolean)ridget.isMarkNegative());
    }

    public void testNegativeMarkerFromSetText() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setMarkNegative(true);
        ridget.setText("100");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setText("-100");
        NumericTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setText("0");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setText("-0");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setText("-1");
        ridget.setMarkNegative(false);
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        ridget.setMarkNegative(true);
        NumericTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
    }

    public void testNegativeMarkerFromControl() {
        INumericTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        Display display = control.getDisplay();
        ridget.setMarkNegative(true);
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        control.setFocus();
        UITestHelper.sendString(display, "123-\r");
        NumericTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        control.setSelection(0, 0);
        UITestHelper.sendKeyAction(display, 127);
        UITestHelper.sendString(display, "\r");
        NumericTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        UITestHelper.sendString(display, "-\r");
        NumericTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
    }

    public void testRemoveLeadingCruft() {
        NumericTextRidgetTest.assertEquals((String)"0", (String)NumericTextRidget.removeLeadingCruft((String)"-"));
        NumericTextRidgetTest.assertEquals((String)"0", (String)NumericTextRidget.removeLeadingCruft((String)"-0"));
        NumericTextRidgetTest.assertEquals((String)"0", (String)NumericTextRidget.removeLeadingCruft((String)"0"));
        NumericTextRidgetTest.assertEquals((String)"-1", (String)NumericTextRidget.removeLeadingCruft((String)"-01"));
        NumericTextRidgetTest.assertEquals((String)"-10", (String)NumericTextRidget.removeLeadingCruft((String)"-010"));
        NumericTextRidgetTest.assertEquals((String)"-101", (String)NumericTextRidget.removeLeadingCruft((String)"-0101"));
        NumericTextRidgetTest.assertEquals((String)"-23", (String)NumericTextRidget.removeLeadingCruft((String)"-0023"));
        NumericTextRidgetTest.assertEquals((String)"1", (String)NumericTextRidget.removeLeadingCruft((String)"01"));
        NumericTextRidgetTest.assertEquals((String)"10", (String)NumericTextRidget.removeLeadingCruft((String)"010"));
        NumericTextRidgetTest.assertEquals((String)"101", (String)NumericTextRidget.removeLeadingCruft((String)"0101"));
        NumericTextRidgetTest.assertEquals((String)"23", (String)NumericTextRidget.removeLeadingCruft((String)"0023"));
    }

    public void testDelete() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        ridget.setSigned(true);
        this.assertText("1^.234", 127, "1^34");
        this.assertText("^1.234", 127, "^234");
        this.assertText("12^.345", 127, "1.2^45");
        this.assertText("1.234^.567", 127, "123.4^67");
        this.assertText("1.234.5^67", 127, "123.45^7");
        this.assertText("-1^.234", 127, "-1^34");
        this.assertText("-^1.234", 127, "-^234");
        this.assertText("-1.234.5^67", 127, "-123.45^7");
    }

    public void testBackspace() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        ridget.setSigned(true);
        this.assertText("123.^456", "\b", "12^.456");
        this.assertText("1.^456", "\b", "^456");
        this.assertText("1.234.^567", "\b", "123^.567");
        this.assertText("1.23^4", "\b", "12^4");
        this.assertText("1.234.56^7", "\b", "123.45^7");
        this.assertText("-1.23^4", "\b", "-12^4");
        this.assertText("-1^.234", "\b", "-^234");
        this.assertText("-1.234.56^7", "\b", "-123.45^7");
    }

    public void testMandatoryMarker() {
        INumericTextRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        ridget.setText("123");
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, true);
        ridget.setText(null);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, false);
        ridget.setMandatory(false);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 0, false);
    }

    private void assertText(String before, String keySeq, String after) {
        TestUtils.assertText(this.getWidget(), this.localize(before), keySeq, this.localize(after));
    }

    private void assertText(String before, int keyCode, String after) {
        TestUtils.assertText(this.getWidget(), this.localize(before), keyCode, this.localize(after));
    }

    private void focusIn(Text control) {
        control.setFocus();
        NumericTextRidgetTest.assertTrue((boolean)control.isFocusControl());
    }

    private void focusOut(Text control) {
        UITestHelper.sendString(control.getDisplay(), "\t");
        NumericTextRidgetTest.assertFalse((boolean)control.isFocusControl());
    }

    private String localize(String number) {
        return TestUtils.getLocalizedNumber(number);
    }

    private static final class EndsWithFive
    implements IValidator {
        private EndsWithFive() {
        }

        public IStatus validate(Object value) {
            boolean isOk = false;
            String s = null;
            if (value instanceof Number) {
                s = ((Number)value).toString();
            } else if (value instanceof String) {
                s = (String)value;
            }
            if (s != null) {
                char lastChar = s.charAt(s.length() - 1);
                isOk = lastChar == '5';
            }
            return isOk ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
    }

    private static final class EvenNumberOfCharacters
    implements IValidator {
        private EvenNumberOfCharacters() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationRuleStatus.ok();
            }
            if (value instanceof String) {
                String string = (String)value;
                if (string.length() % 2 == 0) {
                    return ValidationRuleStatus.ok();
                }
                return ValidationRuleStatus.error((boolean)false, (String)"Odd number of characters.");
            }
            throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type " + String.class.getName());
        }
    }
}

