/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.beans.common.DateBean;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.beans.common.TestBean;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.tests.TestUtils;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.databinding.DateToStringConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToDateConverter;
import org.eclipse.riena.ui.ridgets.marker.TooltipMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.validation.MaxLength;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.ValidCharacters;
import org.eclipse.riena.ui.ridgets.validation.ValidEmailAddress;
import org.eclipse.riena.ui.ridgets.validation.ValidIntermediateDate;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TextRidgetTest2
extends AbstractSWTRidgetTest {
    private static final String TEXT_ONE = "TestText1";
    private static final String TEXT_TWO = "TestText2";
    private TestBean bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new TestBean();
        Shell shell = this.getShell();
        shell.layout();
    }

    protected IRidget createRidget() {
        return new TextRidget();
    }

    protected Control createWidget(Composite parent) {
        return new Text((Composite)this.getShell(), 2048);
    }

    protected ITextRidget getRidget() {
        return (ITextRidget)super.getRidget();
    }

    protected Text getWidget() {
        return (Text)super.getWidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        TextRidgetTest2.assertSame(TextRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testInitialValueFromModel() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        this.bean.setProperty((Object)TEXT_TWO);
        ridget.bindToModel((Object)this.bean, "property");
        TextRidgetTest2.assertEquals((String)"", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "", TEXT_TWO), new PropertyChangeEvent(ridget, "textAfter", "", TEXT_TWO));
        ridget.updateFromModel();
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
    }

    public void testUpdateFromModel() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        TextRidgetTest2.assertEquals((String)"", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"", (String)ridget.getText());
        TextRidgetTest2.assertEquals(null, (Object)this.bean.getProperty());
        this.bean.setProperty((Object)TEXT_ONE);
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_ONE, (Object)this.bean.getProperty());
        this.expectNoPropertyChangeEvent();
        this.bean.setProperty((Object)TEXT_TWO);
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", TEXT_ONE, TEXT_TWO), new PropertyChangeEvent(ridget, "textAfter", TEXT_ONE, TEXT_TWO));
        ridget.updateFromModel();
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
    }

    public void testUpdateFromModelDirectWriting() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.setDirectWriting(true);
        ridget.bindToModel((Object)this.bean, "property");
        this.bean.setProperty((Object)TEXT_ONE);
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_ONE, (Object)this.bean.getProperty());
        this.bean.setProperty((Object)TEXT_TWO);
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
    }

    public void testUpdateFromControlUserInput() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        Display display = control.getDisplay();
        ridget.bindToModel((Object)this.bean, "property");
        UITestHelper.sendString(display, "test");
        TextRidgetTest2.assertEquals((String)"test", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"", (String)ridget.getText());
        TextRidgetTest2.assertEquals(null, (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "", "test"), new PropertyChangeEvent(ridget, "textAfter", "", "test"));
        UITestHelper.sendString(display, "\r");
        UITestHelper.readAndDispatch((Widget)control);
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"test", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"test", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"test", (Object)this.bean.getProperty());
        this.expectNoPropertyChangeEvent();
        UITestHelper.sendString(display, "2");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"test2", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"test", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"test", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "test", "test2"), new PropertyChangeEvent(ridget, "textAfter", "test", "test2"));
        UITestHelper.sendString(display, "\t");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"test2", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"test2", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"test2", (Object)this.bean.getProperty());
    }

    public void testUpdateFromControlUserInputDirectWriting() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        ridget.setDirectWriting(true);
        Display display = control.getDisplay();
        UITestHelper.sendString(display, "t");
        TextRidgetTest2.assertEquals((String)"t", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"t", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"t", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "t", "te"), new PropertyChangeEvent(ridget, "textAfter", "t", "te"));
        UITestHelper.sendString(display, "e");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"te", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"te", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"te", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "te", "tes"), new PropertyChangeEvent(ridget, "textAfter", "te", "tes"));
        UITestHelper.sendString(display, "s");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"tes", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"tes", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"tes", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "tes", "test"), new PropertyChangeEvent(ridget, "textAfter", "tes", "test"));
        UITestHelper.sendString(display, "t");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"test", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"test", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"test", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "test", "tet"), new PropertyChangeEvent(ridget, "textAfter", "test", "tet"));
        UITestHelper.sendKeyAction(display, 0x1000003);
        UITestHelper.sendString(display, "\b");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"tet", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"tet", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"tet", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "tet", "te"), new PropertyChangeEvent(ridget, "textAfter", "tet", "te"));
        UITestHelper.sendString(display, String.valueOf('\u007f'));
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"te", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"te", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"te", (Object)this.bean.getProperty());
        this.expectNoPropertyChangeEvent();
        this.bean.setProperty((Object)"Test");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"te", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"te", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"Test", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "te", "t"), new PropertyChangeEvent(ridget, "textAfter", "te", "t"));
        UITestHelper.sendString(display, "\b");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"t", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"t", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"t", (Object)this.bean.getProperty());
    }

    public void testUpdateFromControlMethodCall() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        ((Text)ridget.getUIControl()).setText("test");
        TextRidgetTest2.assertEquals((String)"test", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"", (String)ridget.getText());
        TextRidgetTest2.assertEquals(null, (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "", "test"), new PropertyChangeEvent(ridget, "textAfter", "", "test"));
        UITestHelper.sendString(control.getDisplay(), "\r");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"test", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"test", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"test", (Object)this.bean.getProperty());
        this.expectNoPropertyChangeEvent();
        ((Text)ridget.getUIControl()).setText("TEST2");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"TEST2", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"test", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"test", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "test", "TEST2"), new PropertyChangeEvent(ridget, "textAfter", "test", "TEST2"));
        UITestHelper.sendString(control.getDisplay(), "\t");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"TEST2", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"TEST2", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"TEST2", (Object)this.bean.getProperty());
    }

    public void testUpdateFromControlMethodCallDirectWriting() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        ridget.setDirectWriting(true);
        ((Text)ridget.getUIControl()).setText("t");
        TextRidgetTest2.assertEquals((String)"t", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"t", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"t", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "t", "Test"), new PropertyChangeEvent(ridget, "textAfter", "t", "Test"));
        ((Text)ridget.getUIControl()).setText("Test");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"Test", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"Test", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"Test", (Object)this.bean.getProperty());
        this.expectNoPropertyChangeEvent();
        this.bean.setProperty((Object)"Toast");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"Test", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"Test", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"Toast", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", "Test", "Test2"), new PropertyChangeEvent(ridget, "textAfter", "Test", "Test2"));
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000008);
        UITestHelper.sendString(control.getDisplay(), "2");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"Test2", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"Test2", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"Test2", (Object)this.bean.getProperty());
    }

    public void testUpdateFromRidget() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        ridget.setText(TEXT_TWO);
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
        this.expectNoPropertyChangeEvent();
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "12");
        this.bean.setProperty((Object)"Bean34");
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)"12", (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"Bean34", (Object)this.bean.getProperty());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "text", TEXT_TWO, TEXT_ONE), new PropertyChangeEvent(ridget, "textAfter", TEXT_TWO, TEXT_ONE));
        ridget.setText(TEXT_ONE);
        this.verifyPropertyChangeEvents();
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_ONE, (Object)this.bean.getProperty());
    }

    public void testUpdateFromRidgetOnRebind() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        this.bean.setProperty((Object)TEXT_ONE);
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_ONE, (Object)this.bean.getProperty());
        ridget.setUIControl(null);
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "xy");
        TextRidgetTest2.assertEquals((String)"xy", (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_ONE, (Object)this.bean.getProperty());
        ridget.setUIControl((Object)control);
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_ONE, (Object)this.bean.getProperty());
        ridget.setUIControl(null);
        this.bean.setProperty((Object)TEXT_TWO);
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
        ridget.setUIControl((Object)control);
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
    }

    public void testCaretPositionAfterBind() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        this.bean.setProperty((Object)TEXT_ONE);
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((int)0, (int)control.getCaretPosition());
        UITestHelper.sendKeyAction(control.getDisplay(), 131072);
        UITestHelper.sendKeyAction(control.getDisplay(), 131072);
        this.bean.setProperty((Object)TEXT_TWO);
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((int)0, (int)control.getCaretPosition());
        Text text = new Text((Composite)this.getShell(), 2);
        text.setText("foo");
        text.setSelection(2, 2);
        ridget.setUIControl((Object)text);
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)text.getText());
        TextRidgetTest2.assertEquals((int)0, (int)text.getCaretPosition());
    }

    public void testValidationOnUpdateToModel() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        ridget.addValidationRule((IValidator)new MinLength(3), ValidationTime.ON_UPDATE_TO_MODEL);
        this.bean.setProperty((Object)TEXT_ONE);
        ridget.updateFromModel();
        TextRidgetTest2.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "xy\t");
        TextRidgetTest2.assertFalse((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        TextRidgetTest2.assertEquals((String)"xy", (String)ridget.getText());
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000008);
        UITestHelper.sendString(control.getDisplay(), "z");
        TextRidgetTest2.assertFalse((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        UITestHelper.sendString(control.getDisplay(), "\r");
        TextRidgetTest2.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        TextRidgetTest2.assertEquals((String)"xyz", (String)ridget.getText());
    }

    public void testValidationOnKeyPressedWithBlocking() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        ridget.addValidationRule((IValidator)new ValidCharacters("0123456789"), ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.setDirectWriting(true);
        UITestHelper.sendString(control.getDisplay(), "12");
        TextRidgetTest2.assertEquals((String)"12", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"12", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"12", (Object)this.bean.getProperty());
        UITestHelper.sendString(control.getDisplay(), "d");
        TextRidgetTest2.assertEquals((String)"12", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"12", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"12", (Object)this.bean.getProperty());
    }

    public void testValidationOnKeyPressedWithoutBlocking() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        DateBean dateBean = new DateBean();
        dateBean.setValue(new Date(0L));
        ridget.addValidationRule((IValidator)new ValidIntermediateDate("dd.MM.yyyy"), ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.setUIControlToModelConverter((IConverter)new StringToDateConverter("dd.MM.yyyy"));
        ridget.setModelToUIControlConverter((IConverter)new DateToStringConverter("dd.MM.yyyy"));
        ridget.setUIControl((Object)control);
        ridget.bindToModel((Object)dateBean, "value");
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)"01.01.1970", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"01.01.1970", (String)ridget.getText());
        TextRidgetTest2.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        UITestHelper.sendKeyAction(control.getDisplay(), 127);
        UITestHelper.sendString(control.getDisplay(), "4");
        ridget.addMarker((IMarker)new ErrorMarker());
        TextRidgetTest2.assertEquals((String)"41.01.1970", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"01.01.1970", (String)ridget.getText());
        TextRidgetTest2.assertFalse((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
    }

    public void testValidationOnSetTextWithOnEditRule() {
        ITextRidget ridget = this.getRidget();
        StringBean model = new StringBean();
        ridget.bindToModel((Object)model, "value");
        MaxLength onEditRule = new MaxLength(5);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        ridget.setText("tiny");
        ridget.addValidationRule((IValidator)onEditRule, ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.setText("too long");
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"too long", (String)ridget.getText());
        TextRidgetTest2.assertEquals((String)"too long", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"tiny", (String)model.getValue());
        ridget.setText("short");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"short", (String)ridget.getText());
        TextRidgetTest2.assertEquals((String)"short", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"short", (String)model.getValue());
    }

    public void testValidationOnSetTextWithOnUpdateRule() {
        ITextRidget ridget = this.getRidget();
        StringBean model = new StringBean();
        ridget.bindToModel((Object)model, "value");
        MinLength onUpdateRule = new MinLength(10);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        ridget.setText("this is long enough");
        ridget.addValidationRule((IValidator)onUpdateRule, ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.setText("tiny");
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"tiny", (String)ridget.getText());
        TextRidgetTest2.assertEquals((String)"tiny", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"this is long enough", (String)model.getValue());
        ridget.setText("this is not too short");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"this is not too short", (String)ridget.getText());
        TextRidgetTest2.assertEquals((String)"this is not too short", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"this is not too short", (String)model.getValue());
    }

    public void testValidationOnUpdateFromModelWithOnEditRule() {
        ITextRidget ridget = this.getRidget();
        StringBean model = new StringBean();
        ridget.bindToModel((Object)model, "value");
        MaxLength onEditRule = new MaxLength(5);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        ridget.setText("tiny");
        ridget.addValidationRule((IValidator)onEditRule, ValidationTime.ON_UI_CONTROL_EDIT);
        model.setValue("too long");
        ridget.updateFromModel();
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"too long", (String)ridget.getText());
        TextRidgetTest2.assertEquals((String)"too long", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"too long", (String)model.getValue());
        model.setValue("short");
        ridget.updateFromModel();
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"short", (String)ridget.getText());
        TextRidgetTest2.assertEquals((String)"short", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"short", (String)model.getValue());
    }

    public void testValidationOnUpdateFromModelWithOnUpdateRule() {
        ITextRidget ridget = this.getRidget();
        StringBean model = new StringBean();
        ridget.bindToModel((Object)model, "value");
        MinLength onUpdateRule = new MinLength(10);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        ridget.setText("something long");
        ridget.addValidationRule((IValidator)onUpdateRule, ValidationTime.ON_UPDATE_TO_MODEL);
        model.setValue("tiny");
        ridget.updateFromModel();
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"tiny", (String)ridget.getText());
        TextRidgetTest2.assertEquals((String)"tiny", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"tiny", (String)model.getValue());
        model.setValue("this is not too short");
        ridget.updateFromModel();
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"this is not too short", (String)ridget.getText());
        TextRidgetTest2.assertEquals((String)"this is not too short", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"this is not too short", (String)model.getValue());
    }

    public void testUpdateFromRidgetWithValidationOnEditRule() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.addValidationRule((IValidator)new ValidEmailAddress(), ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.bindToModel((Object)this.bean, "property");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertFalse((boolean)ridget.isDirectWriting());
        control.setText("a@");
        control.setSelection(3, 3);
        UITestHelper.sendString(control.getDisplay(), "b.com\t");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"a@b.com", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"a@b.com", (Object)this.bean.getProperty());
        control.setFocus();
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "invalid\t");
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"invalid", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"a@b.com", (Object)this.bean.getProperty());
        control.setText("c@");
        control.setFocus();
        control.setSelection(3, 3);
        UITestHelper.sendString(control.getDisplay(), "d.com\t");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"c@d.com", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"c@d.com", (Object)this.bean.getProperty());
    }

    public void testUpdateFromRidgetWithValidationOnUpdateRule() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.addValidationRule((IValidator)new ValidEmailAddress(), ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.bindToModel((Object)this.bean, "property");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertFalse((boolean)ridget.isDirectWriting());
        control.setText("a@");
        control.setSelection(3, 3);
        UITestHelper.sendString(control.getDisplay(), "b.com\t");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"a@b.com", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"a@b.com", (Object)this.bean.getProperty());
        control.setFocus();
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "invalid\t");
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"invalid", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"a@b.com", (Object)this.bean.getProperty());
        control.setText("c@");
        control.setFocus();
        control.setSelection(3, 3);
        UITestHelper.sendString(control.getDisplay(), "d.com\t");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"c@d.com", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"c@d.com", (Object)this.bean.getProperty());
    }

    public void testValidationMessageWithOnEditRule() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        ridget.addValidationRule((IValidator)new EvenNumberOfCharacters(), ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.setDirectWriting(true);
        ridget.addValidationMessage("TestTextTooShortMessage");
        TextRidgetTest2.assertEquals((int)0, (int)ridget.getMarkers().size());
        UITestHelper.sendString(control.getDisplay(), "a");
        TextRidgetTest2.assertEquals((int)2, (int)ridget.getMarkers().size());
        for (IMarker next : ridget.getMarkers()) {
            TextRidgetTest2.assertTrue((boolean)(next instanceof IMessageMarker));
            IMessageMarker marker = (IMessageMarker)next;
            TextRidgetTest2.assertTrue((marker.getMessage().equals("TestTextTooShortMessage") || marker.getMessage().equals("Odd number of characters.") ? 1 : 0) != 0);
        }
        UITestHelper.sendString(control.getDisplay(), "b");
        TextRidgetTest2.assertEquals((int)0, (int)ridget.getMarkers().size());
    }

    public void testValidationMessageWithOnUpdateRule() throws Exception {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        ridget.addValidationRule((IValidator)new EvenNumberOfCharacters(), ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.setDirectWriting(true);
        ridget.addValidationMessage("TestTextTooShortMessage");
        TextRidgetTest2.assertEquals((int)0, (int)ridget.getMarkers().size());
        UITestHelper.sendString(control.getDisplay(), "a\r");
        TextRidgetTest2.assertEquals((int)2, (int)ridget.getMarkers().size());
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "TestTextTooShortMessage");
        UITestHelper.sendString(control.getDisplay(), "b\r");
        TextRidgetTest2.assertEquals((int)0, (int)ridget.getMarkers().size());
    }

    public void testValidationMessageWithOnUpdateAndOnEditRules() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        MinLength ruleMin3 = new MinLength(3);
        MinLength ruleMin5 = new MinLength(5);
        ridget.addValidationRule((IValidator)ruleMin3, ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.addValidationRule((IValidator)ruleMin5, ValidationTime.ON_UPDATE_TO_MODEL);
        ridget.addValidationMessage("need 3", (IValidator)ruleMin3);
        ridget.addValidationMessage("need 5", (IValidator)ruleMin5);
        this.bean.setProperty((Object)"a");
        ridget.bindToModel((Object)this.bean, "property");
        ridget.updateFromModel();
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "need 3");
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "need 5");
        TestUtils.assertMessageCount((IMarkable)ridget, ValidationMessageMarker.class, 2);
        control.setSelection(1, 1);
        UITestHelper.sendString(control.getDisplay(), "b");
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "need 3");
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "need 5");
        TestUtils.assertMessageCount((IMarkable)ridget, ValidationMessageMarker.class, 2);
        UITestHelper.sendString(control.getDisplay(), "c");
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "need 5");
        TestUtils.assertMessageCount((IMarkable)ridget, ValidationMessageMarker.class, 1);
        UITestHelper.sendString(control.getDisplay(), "de");
        TestUtils.assertMessage((IMarkable)ridget, ValidationMessageMarker.class, "need 5");
        TestUtils.assertMessageCount((IMarkable)ridget, ValidationMessageMarker.class, 1);
        UITestHelper.sendString(control.getDisplay(), "\r");
        TestUtils.assertMessageCount((IMarkable)ridget, ValidationMessageMarker.class, 0);
    }

    public void testErrorMessageWithOnUpdateAndOnEditRules() {
        Text control = this.getWidget();
        ITextRidget ridget = this.getRidget();
        MinLength ruleMin3 = new MinLength(3);
        MinLength ruleMin5 = new MinLength(5);
        ridget.addValidationRule((IValidator)ruleMin3, ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.addValidationRule((IValidator)ruleMin5, ValidationTime.ON_UPDATE_TO_MODEL);
        this.bean.setProperty((Object)"a");
        ridget.bindToModel((Object)this.bean, "property");
        ridget.updateFromModel();
        TestUtils.assertMessage((IMarkable)ridget, ErrorMessageMarker.class, "String 'a' is less than 3 characters long.");
        TestUtils.assertMessage((IMarkable)ridget, ErrorMessageMarker.class, "String 'a' is less than 5 characters long.");
        TestUtils.assertMessageCount((IMarkable)ridget, ErrorMessageMarker.class, 2);
        control.setSelection(1, 1);
        UITestHelper.sendString(control.getDisplay(), "b");
        TestUtils.assertMessage((IMarkable)ridget, ErrorMessageMarker.class, "String 'ab' is less than 3 characters long.");
        TestUtils.assertMessage((IMarkable)ridget, ErrorMessageMarker.class, "String 'a' is less than 5 characters long.");
        TestUtils.assertMessageCount((IMarkable)ridget, ErrorMessageMarker.class, 2);
        UITestHelper.sendString(control.getDisplay(), "c");
        TestUtils.assertMessage((IMarkable)ridget, ErrorMessageMarker.class, "String 'a' is less than 5 characters long.");
        TestUtils.assertMessageCount((IMarkable)ridget, ErrorMessageMarker.class, 1);
        UITestHelper.sendString(control.getDisplay(), "de");
        TestUtils.assertMessage((IMarkable)ridget, ErrorMessageMarker.class, "String 'a' is less than 5 characters long.");
        TestUtils.assertMessageCount((IMarkable)ridget, ErrorMessageMarker.class, 1);
        UITestHelper.sendString(control.getDisplay(), "\r");
        TestUtils.assertMessageCount((IMarkable)ridget, ErrorMessageMarker.class, 0);
    }

    public void testRevalidateOnEditRule() {
        ITextRidget ridget = this.getRidget();
        ValidCharacters numbersOnly = new ValidCharacters("0123456789");
        ridget.bindToModel((Object)this.bean, "property");
        ridget.setText("abc");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addValidationRule((IValidator)numbersOnly, ValidationTime.ON_UI_CONTROL_EDIT);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk1 = ridget.revalidate();
        TextRidgetTest2.assertFalse((boolean)isOk1);
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)numbersOnly);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk2 = ridget.revalidate();
        TextRidgetTest2.assertTrue((boolean)isOk2);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testRevalidateOnUpdateRule() {
        ITextRidget ridget = this.getRidget();
        ValidCharacters numbersOnly = new ValidCharacters("0123456789");
        ridget.bindToModel((Object)this.bean, "property");
        ridget.setText("abc");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addValidationRule((IValidator)numbersOnly, ValidationTime.ON_UPDATE_TO_MODEL);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk1 = ridget.revalidate();
        TextRidgetTest2.assertFalse((boolean)isOk1);
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)numbersOnly);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        boolean isOk2 = ridget.revalidate();
        TextRidgetTest2.assertTrue((boolean)isOk2);
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testRevalidateDoesUpdate() {
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        EvenNumberOfCharacters evenChars = new EvenNumberOfCharacters();
        ridget.addValidationRule((IValidator)evenChars, ValidationTime.ON_UI_CONTROL_EDIT);
        this.bean.setProperty((Object)"ab");
        ridget.bindToModel((Object)this.bean, "property");
        ridget.updateFromModel();
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        control.setFocus();
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "abc\t");
        TextRidgetTest2.assertEquals((String)"abc", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"abc", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"ab", (Object)this.bean.getProperty());
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeValidationRule((IValidator)evenChars);
        ridget.revalidate();
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"abc", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"abc", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"abc", (Object)this.bean.getProperty());
    }

    public void testReValidationOnSetText() {
        ITextRidget ridget = this.getRidget();
        ValidCharacters numbersOnly = new ValidCharacters("0123456789");
        ridget.setText("123");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"123", (String)ridget.getText());
        ridget.addValidationRule((IValidator)numbersOnly, ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.setText("abc");
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"abc", (String)ridget.getText());
        ridget.removeValidationRule((IValidator)numbersOnly);
        ridget.setText("abc");
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"abc", (String)ridget.getText());
    }

    public void testReValidationOnUpdateFromModel() {
        ITextRidget ridget = this.getRidget();
        ValidCharacters numbersOnly = new ValidCharacters("0123456789");
        this.bean.setProperty((Object)"123");
        ridget.bindToModel((Object)this.bean, "property");
        ridget.updateFromModel();
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((String)"123", (String)ridget.getText());
        ridget.addValidationRule((IValidator)numbersOnly, ValidationTime.ON_UI_CONTROL_EDIT);
        this.bean.setProperty((Object)"abc");
        ridget.updateFromModel();
        TextRidgetTest2.assertTrue((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((Object)"abc", (Object)this.bean.getProperty());
        TextRidgetTest2.assertEquals((String)"abc", (String)ridget.getText());
        ridget.removeValidationRule((IValidator)numbersOnly);
        ridget.updateFromModel();
        TextRidgetTest2.assertFalse((boolean)ridget.isErrorMarked());
        TextRidgetTest2.assertEquals((Object)"abc", (Object)this.bean.getProperty());
        TextRidgetTest2.assertEquals((String)"abc", (String)ridget.getText());
    }

    public void testDisableMandatoryMarkersSetText() {
        ITextRidget ridget = this.getRidget();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        ridget.addMarker((IMarker)mandatoryMarker);
        ridget.setText("");
        TextRidgetTest2.assertFalse((boolean)mandatoryMarker.isDisabled());
        ridget.setText("foo");
        TextRidgetTest2.assertTrue((boolean)mandatoryMarker.isDisabled());
        ridget.setText("");
        TextRidgetTest2.assertFalse((boolean)mandatoryMarker.isDisabled());
    }

    public void testDisableMandatoryMarkersUpdateFromModel() {
        ITextRidget ridget = this.getRidget();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        ridget.addMarker((IMarker)mandatoryMarker);
        ridget.setText("foo");
        TextRidgetTest2.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        this.bean.setProperty((Object)"");
        ridget.bindToModel((Object)this.bean, "property");
        ridget.updateFromModel();
        TextRidgetTest2.assertFalse((boolean)mandatoryMarker.isDisabled());
        this.bean.setProperty((Object)"baz");
        ridget.updateFromModel();
        TextRidgetTest2.assertTrue((boolean)mandatoryMarker.isDisabled());
    }

    public void testDisableMandatoryMarkers() {
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        ridget.addMarker((IMarker)mandatoryMarker);
        TextRidgetTest2.assertFalse((boolean)ridget.isDirectWriting());
        ridget.setText("foo");
        TextRidgetTest2.assertTrue((boolean)mandatoryMarker.isDisabled());
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "\b");
        TextRidgetTest2.assertFalse((boolean)mandatoryMarker.isDisabled());
        UITestHelper.sendString(control.getDisplay(), "x");
        TextRidgetTest2.assertTrue((boolean)mandatoryMarker.isDisabled());
        UITestHelper.sendString(control.getDisplay(), "\t");
        TextRidgetTest2.assertTrue((boolean)mandatoryMarker.isDisabled());
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "\b");
        TextRidgetTest2.assertFalse((boolean)mandatoryMarker.isDisabled());
    }

    public void testDisableMandatoryMarkersDirectWriting() {
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        ridget.addMarker((IMarker)mandatoryMarker);
        ridget.setDirectWriting(true);
        TextRidgetTest2.assertTrue((boolean)ridget.isDirectWriting());
        ridget.setText("foo");
        TextRidgetTest2.assertTrue((boolean)mandatoryMarker.isDisabled());
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "\b");
        TextRidgetTest2.assertFalse((boolean)mandatoryMarker.isDisabled());
        UITestHelper.sendString(control.getDisplay(), "x");
        TextRidgetTest2.assertTrue((boolean)mandatoryMarker.isDisabled());
        UITestHelper.sendString(control.getDisplay(), "\b");
        TextRidgetTest2.assertFalse((boolean)mandatoryMarker.isDisabled());
    }

    public void testIsDisableMandatoryMarker() {
        ITextRidget ridget = this.getRidget();
        ridget.setText("foo");
        TextRidgetTest2.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        ridget.setText("");
        TextRidgetTest2.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ridget.setText("  ");
        TextRidgetTest2.assertTrue((boolean)ridget.isDisableMandatoryMarker());
    }

    public void testControlNotEditableWithOutputMarker() {
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        TextRidgetTest2.assertTrue((boolean)control.getEditable());
        ridget.setOutputOnly(true);
        TextRidgetTest2.assertFalse((boolean)control.getEditable());
        ridget.setOutputOnly(false);
        TextRidgetTest2.assertTrue((boolean)control.getEditable());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText("foo");
        TextRidgetTest2.assertEquals((String)"foo", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"foo", (String)ridget.getText());
        ridget.setOutputOnly(true);
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "bar\t");
        TextRidgetTest2.assertEquals((String)"foo", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"foo", (String)ridget.getText());
        ridget.setOutputOnly(false);
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "bar\t");
        TextRidgetTest2.assertEquals((String)"bar", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"bar", (String)ridget.getText());
    }

    public void testDisabledHasNoTextFromRidget() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping TextRidgetTest2.testDisabledHasNoTextFromRidget()");
            return;
        }
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.bindToModel((Object)this.bean, "property");
        ridget.setText("foo");
        TextRidgetTest2.assertEquals((String)"foo", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"foo", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"foo", (Object)this.bean.getProperty());
        ridget.setEnabled(false);
        TextRidgetTest2.assertEquals((String)"", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"foo", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"foo", (Object)this.bean.getProperty());
        ridget.setText("bar");
        TextRidgetTest2.assertEquals((String)"", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"bar", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"bar", (Object)this.bean.getProperty());
        ridget.setEnabled(true);
        TextRidgetTest2.assertEquals((String)"bar", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"bar", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"bar", (Object)this.bean.getProperty());
    }

    public void testDisabledHasNoTextFromModel() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping TextRidgetTest2.testDisabledHasNoTextFromModel()");
            return;
        }
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        this.bean.setProperty((Object)TEXT_TWO);
        ridget.bindToModel((Object)this.bean, "property");
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
        ridget.setEnabled(false);
        TextRidgetTest2.assertEquals((String)"", (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_TWO, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_TWO, (Object)this.bean.getProperty());
        this.bean.setProperty((Object)TEXT_ONE);
        ridget.updateFromModel();
        TextRidgetTest2.assertEquals((String)"", (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_ONE, (Object)this.bean.getProperty());
        ridget.setEnabled(true);
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)control.getText());
        TextRidgetTest2.assertEquals((String)TEXT_ONE, (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)TEXT_ONE, (Object)this.bean.getProperty());
    }

    public void testDisabledControlHasNoText() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping TextRidgetTest2.testDisabledHasNoText()");
            return;
        }
        ITextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setUIControl(null);
        ridget.setText("text");
        ridget.setEnabled(false);
        ridget.setUIControl((Object)control);
        TextRidgetTest2.assertEquals((String)"", (String)control.getText());
        ridget.setEnabled(true);
        TextRidgetTest2.assertEquals((String)"text", (String)control.getText());
    }

    public void testShowOneValidationRuleMessageInTooltip() {
        ITextRidget ridget = this.getRidget();
        TooltipMessageMarkerViewer viewer = new TooltipMessageMarkerViewer();
        viewer.addRidget((IBasicMarkableRidget)ridget);
        ridget.setToolTipText("original text");
        AlwaysWrongValidator rule = new AlwaysWrongValidator("ruleA_");
        ridget.addValidationRule((IValidator)rule, ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.revalidate();
        TextRidgetTest2.assertEquals((String)"ruleA_1", (String)ridget.getToolTipText());
        ridget.revalidate();
        TextRidgetTest2.assertEquals((String)"ruleA_2", (String)ridget.getToolTipText());
        ridget.removeValidationRule((IValidator)rule);
        ridget.revalidate();
        TextRidgetTest2.assertEquals((String)"original text", (String)ridget.getToolTipText());
    }

    public void testShowSeveralValidationRuleMessagesInTooltip() {
        ITextRidget ridget = this.getRidget();
        TooltipMessageMarkerViewer viewer = new TooltipMessageMarkerViewer();
        viewer.addRidget((IBasicMarkableRidget)ridget);
        ridget.setToolTipText("original text");
        AlwaysWrongValidator rule1 = new AlwaysWrongValidator("ruleA_");
        AlwaysWrongValidator rule2 = new AlwaysWrongValidator("ruleB_");
        ridget.addValidationRule((IValidator)rule1, ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.addValidationRule((IValidator)rule2, ValidationTime.ON_UI_CONTROL_EDIT);
        ridget.revalidate();
        TextRidgetTest2.assertEquals((String)"ruleA_1\nruleB_1", (String)ridget.getToolTipText());
        ridget.removeValidationRule((IValidator)rule1);
        ridget.revalidate();
        TextRidgetTest2.assertEquals((String)"ruleB_2", (String)ridget.getToolTipText());
        ridget.removeValidationRule((IValidator)rule2);
        ridget.revalidate();
        TextRidgetTest2.assertEquals((String)"original text", (String)ridget.getToolTipText());
    }

    public void testModelUpdatedBeforeListenerNotificationOnSetText() {
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        FTPropertyChangeListener listener1 = new FTPropertyChangeListener(this.bean, "newValue");
        ridget.addPropertyChangeListener((PropertyChangeListener)listener1);
        FTPropertyChangeListener listener2 = new FTPropertyChangeListener(this.bean, "newValue");
        ridget.addPropertyChangeListener("textAfter", (PropertyChangeListener)listener2);
        ridget.setText("newValue");
        TextRidgetTest2.assertEquals((String)"newValue", (String)this.getWidget().getText());
        TextRidgetTest2.assertEquals((String)"newValue", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"newValue", (Object)this.bean.getProperty());
        TextRidgetTest2.assertEquals((int)1, (int)this.bean.getSetCount());
        TextRidgetTest2.assertEquals((int)1, (int)listener1.count);
        TextRidgetTest2.assertEquals((int)1, (int)listener2.count);
    }

    public void testModelUpdatedBeforeListenerNotificationOnTyping() {
        ITextRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.bean, "property");
        FTPropertyChangeListener listener1 = new FTPropertyChangeListener(this.bean, "abc");
        ridget.addPropertyChangeListener((PropertyChangeListener)listener1);
        FTPropertyChangeListener listener2 = new FTPropertyChangeListener(this.bean, "abc");
        ridget.addPropertyChangeListener("textAfter", (PropertyChangeListener)listener2);
        ridget.setDirectWriting(false);
        Text control = this.getWidget();
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "abc\r");
        TextRidgetTest2.assertEquals((String)"abc", (String)control.getText());
        TextRidgetTest2.assertEquals((String)"abc", (String)ridget.getText());
        TextRidgetTest2.assertEquals((Object)"abc", (Object)this.bean.getProperty());
        TextRidgetTest2.assertEquals((int)1, (int)this.bean.getSetCount());
        TextRidgetTest2.assertEquals((int)1, (int)listener1.count);
        TextRidgetTest2.assertEquals((int)1, (int)listener2.count);
    }

    public void testMandatoryMarker() {
        ITextRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        ridget.setText("abc");
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, true);
        ridget.setText(null);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 1, false);
        ridget.setMandatory(false);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, 0, false);
    }

    private static final class AlwaysWrongValidator
    implements IValidator {
        private String message;
        private int invokeCount = 0;

        AlwaysWrongValidator(String message) {
            this.message = message;
        }

        public IStatus validate(Object value) {
            ++this.invokeCount;
            return ValidationRuleStatus.error((boolean)false, (String)(String.valueOf(this.message) + String.valueOf(this.invokeCount)));
        }
    }

    private static class EvenNumberOfCharacters
    implements IValidator {
        private EvenNumberOfCharacters() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationRuleStatus.ok();
            }
            if (value instanceof String) {
                String string = (String)value;
                if (string.length() % 2 == 0) {
                    return ValidationRuleStatus.ok();
                }
                return ValidationRuleStatus.error((boolean)false, (String)"Odd number of characters.");
            }
            throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type " + String.class.getName());
        }
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private final TestBean bean;
        private final String value;
        private int count;

        FTPropertyChangeListener(TestBean bean, String value) {
            this.bean = bean;
            this.value = value;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("textAfter".equals(evt.getPropertyName())) {
                ++this.count;
                TextRidgetTest2.assertEquals((int)1, (int)this.count);
                TextRidgetTest2.assertEquals((Object)this.value, (Object)evt.getNewValue());
                TextRidgetTest2.assertEquals((Object)this.value, (Object)this.bean.getProperty());
            }
        }
    }
}

