/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeController;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IRidget;

@NonUITestCase
public class NavigationProcessorTest
extends RienaTestCase {
    private NavigationProcessor navigationProcessor;
    private IApplicationNode applicationNode;
    private ISubApplicationNode subApplication;
    private IModuleGroupNode moduleGroup;
    private IModuleNode module;
    private ISubModuleNode subModule;

    protected void setUp() throws Exception {
        super.setUp();
        this.applicationNode = new ApplicationNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.application"));
        this.navigationProcessor = new NavigationProcessor();
        this.applicationNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        this.subApplication = new SubApplicationNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subApplication"));
        this.applicationNode.addChild((INavigationNode)this.subApplication);
        this.moduleGroup = new ModuleGroupNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.moduleGroup"));
        this.subApplication.addChild((INavigationNode)this.moduleGroup);
        this.module = new ModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.module"));
        this.moduleGroup.addChild((INavigationNode)this.module);
        this.subModule = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule"));
        this.module.addChild((INavigationNode)this.subModule);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.applicationNode = null;
    }

    public void testNavigateToRidget() throws Exception {
        final IRidget ridgetStubWithoutFocus = (IRidget)EasyMock.createStrictMock(IRidget.class);
        EasyMock.expect((Object)ridgetStubWithoutFocus.hasFocus()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{ridgetStubWithoutFocus});
        final IRidget ridgetStub = (IRidget)EasyMock.createStrictMock(IRidget.class);
        ridgetStub.requestFocus();
        EasyMock.expect((Object)ridgetStub.hasFocus()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{ridgetStub});
        NavigationNodeController<ISubModuleNode> nodeControllerStub = new NavigationNodeController<ISubModuleNode>(){

            public void configureRidgets() {
            }

            public IRidget getRidget(String id) {
                return "myRidget".equals(id) ? ridgetStub : ridgetStubWithoutFocus;
            }
        };
        this.subModule.setNavigationNodeController((INavigationNodeController)nodeControllerStub);
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        this.navigationProcessor.navigate((INavigationNode)this.subApplication, new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule"), new NavigationArgument(null, "myRidget"));
        NavigationProcessorTest.assertTrue((boolean)this.subModule.isActivated());
        NavigationProcessorTest.assertTrue((boolean)ridgetStub.hasFocus());
        NavigationProcessorTest.assertFalse((boolean)ridgetStubWithoutFocus.hasFocus());
        EasyMock.verify((Object[])new Object[]{ridgetStub});
        EasyMock.reset((Object[])new Object[]{ridgetStub});
    }

    public void testActivateChildren() throws Exception {
        NavigationProcessorTest.assertFalse((boolean)this.subApplication.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.moduleGroup.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.module.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.subModule.isActivated());
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        NavigationProcessorTest.assertTrue((boolean)this.subApplication.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.moduleGroup.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.module.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.subModule.isActivated());
        this.subApplication.deactivate(null);
        this.moduleGroup.deactivate(null);
        this.module.deactivate(null);
        this.subModule.deactivate(null);
        this.subApplication.setEnabled(false);
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        NavigationProcessorTest.assertFalse((boolean)this.subApplication.isActivated());
        this.subApplication.setEnabled(true);
        this.subApplication.setVisible(false);
        this.navigationProcessor.activate((INavigationNode)this.subApplication);
        NavigationProcessorTest.assertFalse((boolean)this.subApplication.isActivated());
    }

    public void testNavigate() throws Exception {
        this.subModule.activate();
        NavigationProcessorTest.assertEquals((int)1, (int)this.applicationNode.getChildren().size());
        NavigationProcessorTest.assertTrue((boolean)this.subApplication.isActivated());
        this.addPluginXml(NavigationProcessorTest.class, "NavigationProcessorTest.xml");
        this.subModule.navigate(new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"));
        NavigationProcessorTest.assertEquals((int)2, (int)this.applicationNode.getChildren().size());
        NavigationProcessorTest.assertFalse((boolean)this.subApplication.isActivated());
        ISubApplicationNode secondSubApplication = (ISubApplicationNode)this.applicationNode.getChild(1);
        NavigationProcessorTest.assertEquals((Object)new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondSubApplication"), (Object)secondSubApplication.getNodeId());
        NavigationProcessorTest.assertTrue((boolean)secondSubApplication.isActivated());
        NavigationProcessorTest.assertEquals((int)1, (int)secondSubApplication.getChildren().size());
        IModuleGroupNode secondModuleGroup = (IModuleGroupNode)secondSubApplication.getChild(0);
        NavigationProcessorTest.assertEquals((Object)new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"), (Object)secondModuleGroup.getNodeId());
        NavigationProcessorTest.assertTrue((boolean)secondModuleGroup.isActivated());
        IModuleNode secondModule = (IModuleNode)secondModuleGroup.getChild(0);
        ISubModuleNode secondSubModule = (ISubModuleNode)secondModule.getChild(0);
        NavigationProcessorTest.assertTrue((boolean)secondSubModule.isActivated());
        secondSubModule.navigateBack();
        NavigationProcessorTest.assertFalse((boolean)secondSubApplication.isActivated());
        NavigationProcessorTest.assertFalse((boolean)secondSubModule.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.subApplication.isActivated());
        NavigationProcessorTest.assertTrue((boolean)this.subModule.isActivated());
        this.subModule.navigate(new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"));
        NavigationProcessorTest.assertFalse((boolean)this.subApplication.isActivated());
        NavigationProcessorTest.assertFalse((boolean)this.subModule.isActivated());
        NavigationProcessorTest.assertEquals((int)2, (int)this.applicationNode.getChildren().size());
        NavigationProcessorTest.assertSame((Object)secondSubApplication, (Object)this.applicationNode.getChild(1));
        NavigationProcessorTest.assertTrue((boolean)secondSubApplication.isActivated());
        NavigationProcessorTest.assertEquals((int)1, (int)secondSubApplication.getChildren().size());
        NavigationProcessorTest.assertSame((Object)secondModuleGroup, (Object)secondSubApplication.getChild(0));
        NavigationProcessorTest.assertTrue((boolean)secondModuleGroup.isActivated());
        NavigationProcessorTest.assertTrue((boolean)secondSubModule.isActivated());
    }

    public void testGetActivateableNodes() {
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        node.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        id = new NavigationNodeId("0815");
        SubModuleNode node2 = new SubModuleNode(id);
        node2.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        id = new NavigationNodeId("node3");
        SubModuleNode node3 = new SubModuleNode(id);
        node3.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        id = new NavigationNodeId("node4");
        SubModuleNode node4 = new SubModuleNode(id);
        node4.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        ArrayList<SubModuleNode> nodes = new ArrayList<SubModuleNode>();
        nodes.add(node);
        nodes.add(node2);
        nodes.add(node3);
        nodes.add(node4);
        List activateableNodes = (List)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActivateableNodes", (Object[])new Object[]{nodes});
        NavigationProcessorTest.assertTrue((activateableNodes.size() == 4 ? 1 : 0) != 0);
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node));
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node2));
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node3));
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node4));
        node2.addMarker((IMarker)new DisabledMarker());
        node3.addMarker((IMarker)new HiddenMarker());
        node3.addMarker((IMarker)new OutputMarker());
        activateableNodes = (List)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActivateableNodes", (Object[])new Object[]{nodes});
        NavigationProcessorTest.assertTrue((activateableNodes.size() == 2 ? 1 : 0) != 0);
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node));
        NavigationProcessorTest.assertFalse((boolean)activateableNodes.contains(node2));
        NavigationProcessorTest.assertFalse((boolean)activateableNodes.contains(node3));
        NavigationProcessorTest.assertTrue((boolean)activateableNodes.contains(node4));
    }

    public void testGetChildToActivate() {
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        INavigationNode toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)toActivate);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertNull((Object)toActivate);
        moduleNode.addChild((INavigationNode)node);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)node, (Object)toActivate);
        id = new NavigationNodeId("sm2");
        SubModuleNode node2 = new SubModuleNode(id);
        moduleNode.addChild((INavigationNode)node2);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)node, (Object)toActivate);
        node2.setSelected(true);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)node2, (Object)toActivate);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)toActivate);
        DisabledMarker disabledMarker = new DisabledMarker();
        moduleNode.addMarker((IMarker)disabledMarker);
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertNull((Object)toActivate);
        moduleNode.removeAllMarkers();
        moduleNode.addMarker((IMarker)new OutputMarker());
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)toActivate);
        moduleNode.addMarker((IMarker)new HiddenMarker());
        toActivate = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getChildToActivate", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertNull((Object)toActivate);
    }

    public void testDispose() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        moduleNode.addChild((INavigationNode)node2);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        moduleGroupNode.addChild((INavigationNode)moduleNode2);
        this.navigationProcessor.activate((INavigationNode)node2);
        node2.setAllowsDeactivate(false);
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertFalse((boolean)node2.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.setAllowsDeactivate(true);
        node2.setAllowsDispose(false);
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertFalse((boolean)node2.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.setAllowsDispose(true);
        node.setAllowsActivate(false);
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertFalse((boolean)node2.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node.setAllowsActivate(true);
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertTrue((boolean)node2.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        this.navigationProcessor.dispose((INavigationNode)node2);
        NavigationProcessorTest.assertTrue((boolean)node2.isDisposed());
        this.navigationProcessor.dispose((INavigationNode)moduleNode2);
        NavigationProcessorTest.assertTrue((boolean)moduleNode2.isDisposed());
        NavigationProcessorTest.assertFalse((boolean)moduleGroupNode.isDisposed());
        this.navigationProcessor.dispose((INavigationNode)moduleNode);
        NavigationProcessorTest.assertTrue((boolean)moduleNode.isDisposed());
        NavigationProcessorTest.assertTrue((boolean)moduleGroupNode.isDisposed());
    }

    public void testGetNodeToDispose() {
        NavigationNodeId id = new NavigationNodeId("4711");
        SubModuleNode node = new SubModuleNode(id);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        moduleGroupNode.addChild((INavigationNode)moduleNode2);
        INavigationNode toDispose = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodeToDispose", (Object[])new Object[]{node});
        NavigationProcessorTest.assertSame((Object)node, (Object)toDispose);
        toDispose = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodeToDispose", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)toDispose);
        toDispose = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodeToDispose", (Object[])new Object[]{moduleNode2});
        NavigationProcessorTest.assertSame((Object)moduleNode2, (Object)toDispose);
        toDispose = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNodeToDispose", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)toDispose);
    }

    public void testAddMarker() {
        DisabledMarker disabledMarker = new DisabledMarker();
        HiddenMarker hiddenMarker = new HiddenMarker();
        ErrorMarker errorMarker = new ErrorMarker();
        this.navigationProcessor.addMarker(null, (IMarker)disabledMarker);
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        moduleNode.addChild((INavigationNode)node2);
        moduleNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        this.navigationProcessor.addMarker((INavigationNode)node, (IMarker)disabledMarker);
        NavigationProcessorTest.assertFalse((boolean)node.isEnabled());
        NavigationProcessorTest.assertTrue((boolean)node.isVisible());
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertTrue((boolean)node2.isEnabled());
        NavigationProcessorTest.assertFalse((boolean)node2.isVisible());
        node.removeAllMarkers();
        node2.removeAllMarkers();
        node.setSelected(true);
        this.navigationProcessor.addMarker((INavigationNode)node, (IMarker)disabledMarker);
        NavigationProcessorTest.assertFalse((boolean)node.isEnabled());
        NavigationProcessorTest.assertFalse((boolean)node.isSelected());
        node.setSelected(true);
        this.navigationProcessor.addMarker((INavigationNode)node, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertFalse((boolean)node.isVisible());
        NavigationProcessorTest.assertFalse((boolean)node.isSelected());
        node.setSelected(true);
        this.navigationProcessor.addMarker((INavigationNode)node, (IMarker)errorMarker);
        NavigationProcessorTest.assertTrue((boolean)node.isSelected());
        node.removeAllMarkers();
        node2.removeAllMarkers();
        node2.activate();
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)errorMarker);
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)disabledMarker);
        NavigationProcessorTest.assertFalse((boolean)node2.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node2.isEnabled());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertFalse((boolean)node2.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node2.isVisible());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        node2.setAllowsDeactivate(false);
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertTrue((boolean)node2.isVisible());
        NavigationProcessorTest.assertFalse((boolean)node.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        node2.setAllowsDeactivate(true);
        node.setAllowsActivate(false);
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertTrue((boolean)node2.isVisible());
        NavigationProcessorTest.assertFalse((boolean)node.isActivated());
        NavigationProcessorTest.assertTrue((boolean)node2.isActivated());
        node2.removeAllMarkers();
        node2.activate();
        node.setAllowsActivate(true);
        this.navigationProcessor.addMarker((INavigationNode)node2, (IMarker)hiddenMarker);
        NavigationProcessorTest.assertFalse((boolean)node2.isVisible());
        NavigationProcessorTest.assertTrue((boolean)node.isActivated());
        NavigationProcessorTest.assertFalse((boolean)node2.isActivated());
    }

    public void testGetTopParent() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        moduleNode.addChild((INavigationNode)node2);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        INavigationNode top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{node});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)top);
        top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)top);
        top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)top);
        top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)top);
        top = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getTopParent", (Object[])new Object[]{moduleNode2});
        NavigationProcessorTest.assertSame((Object)moduleNode2, (Object)top);
    }

    public void testGetNextActiveParent() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        node.addChild((INavigationNode)node2);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        moduleGroupNode.addChild((INavigationNode)moduleNode2);
        moduleGroupNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        INavigationNode parent = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNextActiveParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertNull((Object)parent);
        node.activate();
        parent = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNextActiveParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)parent);
        node.deactivate(null);
        parent = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNextActiveParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)parent);
        moduleNode.deactivate(null);
        parent = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getNextActiveParent", (Object[])new Object[]{node2});
        NavigationProcessorTest.assertSame((Object)moduleGroupNode, (Object)parent);
    }

    public void testGetActiveChild() {
        NavigationNodeId id = new NavigationNodeId("4711");
        TestSubModuleNode node = new TestSubModuleNode(id);
        id = new NavigationNodeId("0815");
        TestSubModuleNode node2 = new TestSubModuleNode(id);
        node.addChild((INavigationNode)node2);
        id = new NavigationNodeId("m1");
        ModuleNode moduleNode = new ModuleNode(id);
        moduleNode.addChild((INavigationNode)node);
        id = new NavigationNodeId("m2");
        ModuleNode moduleNode2 = new ModuleNode(id);
        id = new NavigationNodeId("mg1");
        ModuleGroupNode moduleGroupNode = new ModuleGroupNode(id);
        moduleGroupNode.addChild((INavigationNode)moduleNode);
        moduleGroupNode.addChild((INavigationNode)moduleNode2);
        moduleGroupNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        INavigationNode child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertNull((Object)child);
        node.setSelected(true);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertNull((Object)child);
        node.activate();
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)((Object)node), (Object)child);
        node2.setSelected(true);
        node2.activate();
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{node});
        NavigationProcessorTest.assertNull((Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleNode});
        NavigationProcessorTest.assertSame((Object)((Object)node2), (Object)child);
        child = (INavigationNode)ReflectionUtils.invokeHidden((Object)this.navigationProcessor, (String)"getActiveChild", (Object[])new Object[]{moduleGroupNode});
        NavigationProcessorTest.assertSame((Object)moduleNode, (Object)child);
    }

    private static class TestSubModuleNode
    extends SubModuleNode {
        private boolean allowsActivate = true;
        private boolean allowsDeactivate = true;
        private boolean allowsDispose = true;

        public TestSubModuleNode(NavigationNodeId nodeId) {
            super(nodeId);
        }

        public boolean allowsActivate(INavigationContext context) {
            return this.allowsActivate;
        }

        public boolean allowsDeactivate(INavigationContext context) {
            return this.allowsDeactivate;
        }

        public boolean allowsDispose(INavigationContext context) {
            return this.allowsDispose;
        }

        public void setAllowsActivate(boolean allowsActivate) {
            this.allowsActivate = allowsActivate;
        }

        public void setAllowsDeactivate(boolean allowsDeactivate) {
            this.allowsDeactivate = allowsDeactivate;
        }

        public void setAllowsDispose(boolean allowsDispose) {
            this.allowsDispose = allowsDispose;
        }
    }
}

