/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class SubmoduleNodeTest
extends RienaTestCase {
    private static final String ID_SUBMODULE_FIRST = "org.eclipse.riena.navigation.model.test.submodule.first";
    private static final String ID_SUBMODULE_SECOND = "org.eclipse.riena.navigation.model.test.submodule.second";
    private static final String ID_SUBMODULE_THIRD = "org.eclipse.riena.navigation.model.test.submodule.third";
    private static final String ID_SUBMODULE_CHILD = "org.eclipse.riena.navigation.model.test.subChild";
    private static final String ID_SUBMODULE_SUBCHILD = "org.eclipse.riena.navigation.model.test.subSubChild";
    private static final String ID_MODULEGROUP = "org.eclipse.riena.navigation.model.test.moduleGroup";
    private static final String ID_MODULE = "org.eclipse.riena.navigation.model.test.module";
    private static final String ID_APP = "org.eclipse.riena.navigation.model.test.application";
    private static final String ID_SUB_APP = "org.eclipse.riena.navigation.model.test.subApplication";
    private ApplicationNode applicationNode;
    private NavigationProcessor navigationProcessor;
    private SubApplicationNode subApplication;
    private SubModuleNode submoduleFirst;
    private SubModuleNode submoduleChild;
    private SubModuleNode submoduleSubChild;
    private ModuleGroupNode moduleGroup;
    private ModuleNode module;
    private SubModuleNode submoduleSecond;
    private SubModuleNode submoduleThird;

    protected void setUp() throws Exception {
        this.applicationNode = new ApplicationNode(new NavigationNodeId(ID_APP));
        this.navigationProcessor = new NavigationProcessor();
        this.applicationNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        this.subApplication = new SubApplicationNode(new NavigationNodeId(ID_SUB_APP));
        this.applicationNode.addChild((INavigationNode)this.subApplication);
        this.moduleGroup = new ModuleGroupNode(new NavigationNodeId(ID_MODULEGROUP));
        this.subApplication.addChild((INavigationNode)this.moduleGroup);
        this.module = new ModuleNode(new NavigationNodeId(ID_MODULE));
        this.moduleGroup.addChild((INavigationNode)this.module);
        this.submoduleFirst = new SubModuleNode(new NavigationNodeId(ID_SUBMODULE_FIRST));
        this.submoduleChild = new SubModuleNode(new NavigationNodeId(ID_SUBMODULE_CHILD));
        this.submoduleSubChild = new SubModuleNode(new NavigationNodeId(ID_SUBMODULE_SUBCHILD));
        this.submoduleChild.addChild((INavigationNode)this.submoduleSubChild);
        this.submoduleFirst.addChild((INavigationNode)this.submoduleChild);
        this.module.addChild((INavigationNode)this.submoduleFirst);
        this.submoduleSecond = new SubModuleNode(new NavigationNodeId(ID_SUBMODULE_SECOND));
        this.submoduleThird = new SubModuleNode(new NavigationNodeId(ID_SUBMODULE_THIRD));
        this.module.addChild((INavigationNode)this.submoduleSecond);
        this.module.addChild((INavigationNode)this.submoduleThird);
    }

    public void testNavigateOverNotSelectableSubmodule() throws Exception {
        this.submoduleChild.setSelectable(false);
        this.navigationProcessor.activate((INavigationNode)this.submoduleFirst);
        SubmoduleNodeTest.assertFalse((boolean)this.submoduleSubChild.isActivated());
        this.submoduleFirst.navigate(new NavigationNodeId(ID_SUBMODULE_CHILD));
        SubmoduleNodeTest.assertTrue((boolean)this.submoduleSubChild.isActivated());
    }

    public void testNavigateOverAllNotSelectableSubmodules() throws Exception {
        this.submoduleChild.setSelectable(false);
        this.submoduleSubChild.setSelectable(false);
        this.navigationProcessor.activate((INavigationNode)this.submoduleFirst);
    }

    public void testDefaultSelectableValue() throws Exception {
        SubmoduleNodeTest.assertTrue((boolean)this.submoduleFirst.isSelectable());
        SubmoduleNodeTest.assertTrue((boolean)this.submoduleChild.isSelectable());
        SubmoduleNodeTest.assertTrue((boolean)this.submoduleSubChild.isSelectable());
    }
}

