/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationItem;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationSwitcherWidget;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class SubApplicationSwitcherWidgetTest
extends TestCase {
    private SubApplicationSwitcherWidget switcher;
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        ApplicationNode node = new ApplicationNode();
        this.switcher = new SubApplicationSwitcherWidget((Composite)this.shell, 0, (IApplicationNode)node);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.switcher);
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testCreate() {
        ApplicationNode node = new ApplicationNode();
        SubApplicationNode subNode1 = new SubApplicationNode("sub1");
        subNode1.setIcon("icon1");
        List listeners = (List)ReflectionUtils.invokeHidden((Object)subNode1, (String)"getListeners", null);
        SubApplicationSwitcherWidgetTest.assertNotNull((Object)listeners);
        SubApplicationSwitcherWidgetTest.assertTrue((boolean)listeners.isEmpty());
        node.addChild((INavigationNode)subNode1);
        SubApplicationNode subNode2 = new SubApplicationNode("sub2");
        subNode2.setIcon("icon2");
        node.addChild((INavigationNode)subNode2);
        this.switcher = new SubApplicationSwitcherWidget((Composite)this.shell, 0, (IApplicationNode)node);
        List items = (List)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItems", null);
        SubApplicationSwitcherWidgetTest.assertNotNull((Object)items);
        SubApplicationSwitcherWidgetTest.assertEquals((int)2, (int)items.size());
        SubApplicationSwitcherWidgetTest.assertEquals((String)"sub1", (String)((SubApplicationItem)items.get(0)).getLabel());
        SubApplicationSwitcherWidgetTest.assertEquals((String)"sub2", (String)((SubApplicationItem)items.get(1)).getLabel());
        SubApplicationSwitcherWidgetTest.assertEquals((String)"icon1", (String)((SubApplicationItem)items.get(0)).getIcon());
        SubApplicationSwitcherWidgetTest.assertEquals((String)"icon2", (String)((SubApplicationItem)items.get(1)).getIcon());
        listeners = (List)ReflectionUtils.invokeHidden((Object)subNode1, (String)"getListeners", null);
        SubApplicationSwitcherWidgetTest.assertNotNull((Object)listeners);
        SubApplicationSwitcherWidgetTest.assertFalse((boolean)listeners.isEmpty());
        SubApplicationSwitcherWidgetTest.assertEquals((int)1, (int)listeners.size());
        Listener[] swtListeners = this.switcher.getListeners(9);
        SubApplicationSwitcherWidgetTest.assertEquals((int)1, (int)swtListeners.length);
        swtListeners = this.switcher.getListeners(3);
        SubApplicationSwitcherWidgetTest.assertEquals((int)1, (int)swtListeners.length);
    }

    public void testIsTabEnabled() {
        SubApplicationNode node = new SubApplicationNode();
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubApplicationItem item = new SubApplicationItem((Composite)this.switcher, (ISubApplicationNode)node);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"isTabEnabled", (Object[])new Object[]{item});
        SubApplicationSwitcherWidgetTest.assertTrue((boolean)ret);
        DisabledMarker disabledMarker = new DisabledMarker();
        node.addMarker((IMarker)disabledMarker);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"isTabEnabled", (Object[])new Object[]{item});
        SubApplicationSwitcherWidgetTest.assertFalse((boolean)ret);
        HiddenMarker hiddenMarker = new HiddenMarker();
        node.removeMarker((IMarker)disabledMarker);
        node.addMarker((IMarker)hiddenMarker);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"isTabEnabled", (Object[])new Object[]{item});
        SubApplicationSwitcherWidgetTest.assertFalse((boolean)ret);
        node.removeMarker((IMarker)hiddenMarker);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"isTabEnabled", (Object[])new Object[]{item});
        SubApplicationSwitcherWidgetTest.assertTrue((boolean)ret);
    }

    public void testGetItemPoint() {
        SubApplicationNode node = new SubApplicationNode();
        SubApplicationItem item = new SubApplicationItem((Composite)this.switcher, (ISubApplicationNode)node);
        List items = (List)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItems", null);
        Point point = new Point(0, 0);
        SubApplicationItem retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{point});
        SubApplicationSwitcherWidgetTest.assertNull((Object)retItem);
        items.add(item);
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{point});
        SubApplicationSwitcherWidgetTest.assertNull((Object)retItem);
        point = new Point(5, 5);
        item.setBounds(new Rectangle(0, 0, 10, 10));
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{point});
        SubApplicationSwitcherWidgetTest.assertNotNull((Object)retItem);
        SubApplicationSwitcherWidgetTest.assertSame((Object)item, (Object)retItem);
        SubApplicationNode node2 = new SubApplicationNode();
        SubApplicationItem item2 = new SubApplicationItem((Composite)this.switcher, (ISubApplicationNode)node2);
        items.add(item2);
        item2.setBounds(new Rectangle(20, 20, 10, 10));
        point = new Point(20, 20);
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{point});
        SubApplicationSwitcherWidgetTest.assertNotNull((Object)retItem);
        SubApplicationSwitcherWidgetTest.assertSame((Object)item2, (Object)retItem);
        point = new Point(31, 31);
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{point});
        SubApplicationSwitcherWidgetTest.assertNull((Object)retItem);
    }

    public void testGetItemChar() {
        SubApplicationNode node1 = new SubApplicationNode("abcd");
        ReflectionUtils.invokeHidden((Object)this.switcher, (String)"registerSubApplication", (Object[])new Object[]{node1});
        SubApplicationNode node2 = new SubApplicationNode("e&fgh");
        ReflectionUtils.invokeHidden((Object)this.switcher, (String)"registerSubApplication", (Object[])new Object[]{node2});
        SubApplicationNode node3 = new SubApplicationNode("IJ&K&L");
        ReflectionUtils.invokeHidden((Object)this.switcher, (String)"registerSubApplication", (Object[])new Object[]{node3});
        SubApplicationItem retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{Character.valueOf('a')});
        SubApplicationSwitcherWidgetTest.assertNull((Object)retItem);
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{Character.valueOf('f')});
        SubApplicationSwitcherWidgetTest.assertSame((Object)node2, (Object)retItem.getSubApplicationNode());
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{Character.valueOf('F')});
        SubApplicationSwitcherWidgetTest.assertSame((Object)node2, (Object)retItem.getSubApplicationNode());
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{Character.valueOf('k')});
        SubApplicationSwitcherWidgetTest.assertSame((Object)node3, (Object)retItem.getSubApplicationNode());
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{Character.valueOf('K')});
        SubApplicationSwitcherWidgetTest.assertSame((Object)node3, (Object)retItem.getSubApplicationNode());
        retItem = (SubApplicationItem)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItem", (Object[])new Object[]{Character.valueOf('L')});
        SubApplicationSwitcherWidgetTest.assertNull((Object)retItem);
    }

    public void testDisposeSubApplication() throws Exception {
        ApplicationNode node = new ApplicationNode();
        SubApplicationNode subNode1 = new SubApplicationNode("sub1");
        subNode1.setIcon("icon1");
        node.addChild((INavigationNode)subNode1);
        SubApplicationNode subNode2 = new SubApplicationNode("sub2");
        subNode2.setIcon("icon2");
        node.addChild((INavigationNode)subNode2);
        this.switcher = new SubApplicationSwitcherWidget((Composite)this.shell, 0, (IApplicationNode)node);
        List items = (List)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItems", null);
        subNode1.dispose();
        SubApplicationSwitcherWidgetTest.assertEquals((int)1, (int)items.size());
        subNode2.dispose();
        SubApplicationSwitcherWidgetTest.assertTrue((boolean)items.isEmpty());
    }

    public void testRemoveSubApplication() throws Exception {
        ApplicationNode node = new ApplicationNode();
        SubApplicationNode subNode1 = new SubApplicationNode("sub1");
        subNode1.setIcon("icon1");
        node.addChild((INavigationNode)subNode1);
        SubApplicationNode subNode2 = new SubApplicationNode("sub2");
        subNode2.setIcon("icon2");
        node.addChild((INavigationNode)subNode2);
        this.switcher = new SubApplicationSwitcherWidget((Composite)this.shell, 0, (IApplicationNode)node);
        List items = (List)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItems", null);
        node.removeChild((INavigationNode)subNode1);
        SubApplicationSwitcherWidgetTest.assertEquals((int)1, (int)items.size());
        node.removeChild((INavigationNode)subNode2);
        SubApplicationSwitcherWidgetTest.assertTrue((boolean)items.isEmpty());
    }

    public void testAddSubApplication() throws Exception {
        ApplicationNode node = new ApplicationNode();
        SubApplicationNode subNode1 = new SubApplicationNode("sub1");
        subNode1.setIcon("icon1");
        node.addChild((INavigationNode)subNode1);
        SubApplicationNode subNode2 = new SubApplicationNode("sub2");
        subNode2.setIcon("icon2");
        node.addChild((INavigationNode)subNode2);
        this.switcher = new SubApplicationSwitcherWidget((Composite)this.shell, 0, (IApplicationNode)node);
        List items = (List)ReflectionUtils.invokeHidden((Object)this.switcher, (String)"getItems", null);
        SubApplicationNode subNode3 = new SubApplicationNode("sub3");
        subNode2.setIcon("icon3");
        node.addChild((INavigationNode)subNode3);
        SubApplicationSwitcherWidgetTest.assertEquals((int)3, (int)items.size());
    }
}

