/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import junit.framework.TestCase;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;

@NonUITestCase
public class ShellBorderRendererTest
extends TestCase {
    public void testGetCompelteBorderWidth() {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            MyLnf lnf = new MyLnf();
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            lnf.initialize();
            ShellBorderRenderer renderer = new ShellBorderRenderer();
            lnf.setPadding(20);
            int expected = 20 + renderer.getBorderWidth();
            ShellBorderRendererTest.assertEquals((int)expected, (int)renderer.getCompleteBorderWidth());
            lnf.removePadding();
            expected = renderer.getBorderWidth();
            ShellBorderRendererTest.assertEquals((int)expected, (int)renderer.getCompleteBorderWidth());
            lnf.setPadding(1.2);
            expected = renderer.getBorderWidth();
            ShellBorderRendererTest.assertEquals((int)expected, (int)renderer.getCompleteBorderWidth());
            renderer.dispose();
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public void removePadding() {
            this.getSettingTable().remove("TitlelessShell.padding");
        }

        public void setPadding(Object padding) {
            this.getSettingTable().put("TitlelessShell.padding", padding);
        }
    }
}

