/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.presentation;

import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class SwtViewProviderTest
extends RienaTestCase {
    private SwtViewProvider swtPresentationManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.swtPresentationManager = (SwtViewProvider)ReflectionUtils.newInstanceHidden(SwtViewProvider.class, (Object[])new Object[0]);
        this.addPluginXml(SwtViewProviderTest.class, "SwtViewProviderTest.xml");
    }

    public void testGetSwtViewIdSharedView() throws Exception {
        SubModuleNode node1 = new SubModuleNode(new NavigationNodeId("testSharedViewId", "testInstanceId1"));
        SubModuleNode node2 = new SubModuleNode(new NavigationNodeId("testSharedViewId", "testInstanceId2"));
        SwtViewId swtViewId1 = this.swtPresentationManager.getSwtViewId((INavigationNode)node1);
        SwtViewProviderTest.assertEquals((String)"org.eclipse.riena.navigation.ui.swt.views.TestView", (String)swtViewId1.getId());
        SwtViewProviderTest.assertEquals((String)"shared", (String)swtViewId1.getSecondary());
        SwtViewId swtViewId2 = this.swtPresentationManager.getSwtViewId((INavigationNode)node2);
        SwtViewProviderTest.assertEquals((String)"org.eclipse.riena.navigation.ui.swt.views.TestView", (String)swtViewId2.getId());
        SwtViewProviderTest.assertEquals((String)"shared", (String)swtViewId2.getSecondary());
    }

    public void testGetSwtViewIdNotSharedView() throws Exception {
        SubModuleNode node1 = new SubModuleNode(new NavigationNodeId("testNotSharedViewId", "testInstanceId1"));
        SubModuleNode node2 = new SubModuleNode(new NavigationNodeId("testNotSharedViewId", "testInstanceId2"));
        SwtViewId swtViewId1 = this.swtPresentationManager.getSwtViewId((INavigationNode)node1);
        SwtViewProviderTest.assertEquals((String)"org.eclipse.riena.navigation.ui.swt.views.TestView", (String)swtViewId1.getId());
        SwtViewProviderTest.assertEquals((String)"1", (String)swtViewId1.getSecondary());
        SwtViewId swtViewId2 = this.swtPresentationManager.getSwtViewId((INavigationNode)node2);
        SwtViewProviderTest.assertEquals((String)"org.eclipse.riena.navigation.ui.swt.views.TestView", (String)swtViewId2.getId());
        SwtViewProviderTest.assertEquals((String)"2", (String)swtViewId2.getSecondary());
        SwtViewId swtViewId1Again = this.swtPresentationManager.getSwtViewId((INavigationNode)node1);
        SwtViewProviderTest.assertEquals((String)"org.eclipse.riena.navigation.ui.swt.views.TestView", (String)swtViewId1Again.getId());
        SwtViewProviderTest.assertEquals((String)"1", (String)swtViewId1Again.getSecondary());
    }

    public void testUnconsistentDefinitionWithAViewBothSharedAndNotShared() throws Exception {
        SubModuleNode node1 = new SubModuleNode(new NavigationNodeId("testSharedViewId", "testInstanceId1"));
        SubModuleNode node2 = new SubModuleNode(new NavigationNodeId("testNotSharedViewId", "testInstanceId2"));
        this.swtPresentationManager.getSwtViewId((INavigationNode)node1);
        try {
            this.swtPresentationManager.getSwtViewId((INavigationNode)node2);
            SwtViewProviderTest.fail((String)"ApplicationModelFailure expected");
        }
        catch (ApplicationModelFailure applicationModelFailure) {
            this.ok("ApplicationModelFailure expected");
        }
    }
}

