/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.views.ApplicationViewAdvisor;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.lnf.ImageLnfResource;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;

@UITestCase
public class ApplicationViewAdvisorTest
extends TestCase {
    private static final String ICON_ECLIPSE = "eclipse.gif";
    private ApplicationViewAdvisor advisor;
    private IWorkbenchWindowConfigurer winConfig;
    private ApplicationNode applicationNode;
    private ApplicationController controller;

    protected void setUp() throws Exception {
        this.winConfig = (IWorkbenchWindowConfigurer)EasyMock.createNiceMock(IWorkbenchWindowConfigurer.class);
        this.applicationNode = new ApplicationNode();
        this.controller = new ApplicationController((IApplicationNode)this.applicationNode);
        this.advisor = new ApplicationViewAdvisor(this.winConfig, this.controller);
    }

    protected void tearDown() throws Exception {
        this.applicationNode = null;
        this.controller = null;
        this.winConfig = null;
        this.advisor.dispose();
        this.advisor = null;
    }

    public void testInitShell() {
        Shell shell = new Shell();
        ApplicationViewAdvisorTest.assertNotSame((Object)2, (Object)shell.getBackgroundMode());
        Point defMinSize = shell.getMinimumSize();
        ReflectionUtils.invokeHidden((Object)this.advisor, (String)"initShell", (Object[])new Object[]{shell});
        ApplicationViewAdvisorTest.assertFalse((boolean)defMinSize.equals((Object)shell.getMinimumSize()));
        ApplicationViewAdvisorTest.assertNotNull((Object)shell.getData("binding_property"));
        SwtUtilities.disposeWidget((Widget)shell);
    }

    public void testInitApplicationSize() {
        System.setProperty("riena.application.width", "9000");
        System.setProperty("riena.application.height", "8000");
        EasyMock.reset((Object[])new Object[]{this.winConfig});
        this.winConfig.setInitialSize(new Point(9000, 8000));
        EasyMock.replay((Object[])new Object[]{this.winConfig});
        ReflectionUtils.invokeHidden((Object)this.advisor, (String)"initApplicationSize", (Object[])new Object[]{this.winConfig});
        EasyMock.verify((Object[])new Object[]{this.winConfig});
        System.setProperty("riena.application.width", "90");
        System.setProperty("riena.application.height", "80");
        EasyMock.reset((Object[])new Object[]{this.winConfig});
        this.winConfig.setInitialSize(new Point(800, 600));
        EasyMock.replay((Object[])new Object[]{this.winConfig});
        ReflectionUtils.invokeHidden((Object)this.advisor, (String)"initApplicationSize", (Object[])new Object[]{this.winConfig});
        EasyMock.verify((Object[])new Object[]{this.winConfig});
    }

    public void testGetLogoImage() {
        RienaDefaultLnf originaLnf = LnfManager.getLnf();
        try {
            MyLnf lnf = new MyLnf();
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            lnf.initialize();
            Image eclipseImage = ImageStore.getInstance().getImage(ICON_ECLIPSE);
            lnf.setLogo(ICON_ECLIPSE);
            Image logoImage = (Image)ReflectionUtils.invokeHidden((Object)this.advisor, (String)"getLogoImage", (Object[])new Object[0]);
            ApplicationViewAdvisorTest.assertNotNull((Object)logoImage);
            ApplicationViewAdvisorTest.assertEquals((int)eclipseImage.getBounds().width, (int)logoImage.getBounds().width);
            ApplicationViewAdvisorTest.assertEquals((int)eclipseImage.getBounds().height, (int)logoImage.getBounds().height);
            Image missingImage = ImageStore.getInstance().getMissingImage();
            lnf.setLogo("eclipse.gif4711");
            logoImage = (Image)ReflectionUtils.invokeHidden((Object)this.advisor, (String)"getLogoImage", (Object[])new Object[0]);
            ApplicationViewAdvisorTest.assertNotNull((Object)logoImage);
            ApplicationViewAdvisorTest.assertEquals((int)missingImage.getBounds().width, (int)logoImage.getBounds().width);
            ApplicationViewAdvisorTest.assertEquals((int)missingImage.getBounds().height, (int)logoImage.getBounds().height);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originaLnf);
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public void setLogo(String logo) {
            this.getResourceTable().put("TitlelessShell.logo", new ImageLnfResource(logo));
        }
    }
}

