/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ModuleGroupViewTest
extends TestCase {
    private ModuleGroupView view;
    private ModuleGroupNode node;
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.view = new ModuleGroupView((Composite)this.shell, 0);
        this.node = new ModuleGroupNode();
        this.node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        this.view.bind(this.node);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.view);
        SwtUtilities.disposeWidget((Widget)this.shell);
        this.node = null;
    }

    public void testCalculateBounds() {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            LnfManager.setLnf((RienaDefaultLnf)new MyLnF());
            int y = this.view.calculateBounds(10);
            ModuleGroupViewTest.assertEquals((int)10, (int)y);
            ModuleView moduleView = new ModuleView((Composite)this.shell);
            ModuleNode moduleNode = new ModuleNode();
            this.node.addChild((INavigationNode)moduleNode);
            moduleView.bind(moduleNode);
            this.view.registerModuleView(moduleView);
            y = this.view.calculateBounds(10);
            ModuleGroupViewTest.assertTrue((y > 10 ? 1 : 0) != 0);
            FormData data = (FormData)this.view.getLayoutData();
            ModuleGroupViewTest.assertEquals((int)10, (int)data.top.offset);
            ModuleGroupViewTest.assertTrue((data.bottom.offset > 10 && data.bottom.offset < y ? 1 : 0) != 0);
            this.node.setVisible(false);
            y = this.view.calculateBounds(10);
            ModuleGroupViewTest.assertEquals((int)10, (int)y);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
        }
    }

    public void testUnbind() throws Exception {
        List listeners = (List)ReflectionUtils.getHidden((Object)this.node, (String)"listeners");
        ModuleGroupViewTest.assertEquals((int)1, (int)listeners.size());
        this.node.dispose();
        ModuleGroupViewTest.assertTrue((boolean)listeners.isEmpty());
    }

    private static class MyLnF
    extends RienaDefaultLnf {
        private MyLnF() {
        }

        protected void initWidgetRendererDefaults() {
            this.getRendererTable().put("ModuleGroup.renderer", new ModuleGroupRenderer());
        }
    }
}

