/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class SubModuleViewTest
extends RienaTestCase {
    private SubModuleView<SubModuleController> subModuleNodeView;
    private SubModuleNode node;
    private SubModuleNode anotherNode;
    private SubModuleNode anotherNodeSameView;
    private List<SubModuleNode> nodesBoundToView;

    protected void setUp() throws Exception {
        super.setUp();
        this.addPluginXml(SubModuleViewTest.class, "SubModuleViewTest.xml");
        ApplicationNode appNode = new ApplicationNode();
        SubApplicationNode subAppNode = new SubApplicationNode();
        appNode.addChild((INavigationNode)subAppNode);
        ModuleGroupNode mgNode = new ModuleGroupNode(null);
        subAppNode.addChild((INavigationNode)mgNode);
        ModuleNode parent = new ModuleNode(null, "TestModuleLabel");
        mgNode.addChild((INavigationNode)parent);
        this.anotherNode = new SubModuleNode(new NavigationNodeId("testId2"), "TestSubModuleLabel2");
        parent.addChild((INavigationNode)this.anotherNode);
        this.anotherNodeSameView = new SubModuleNode(new NavigationNodeId("testId"), "TestSubModuleLabel3");
        parent.addChild((INavigationNode)this.anotherNodeSameView);
        this.nodesBoundToView = new ArrayList<SubModuleNode>();
        this.subModuleNodeView = new TestView();
        this.node = new SubModuleNode(new NavigationNodeId("testId"), "TestSubModuleLabel");
        parent.setNavigationNodeController((INavigationNodeController)new ModuleController((IModuleNode)parent));
        parent.addChild((INavigationNode)this.node);
        this.subModuleNodeView.createPartControl((Composite)new Shell());
        this.node.activate();
    }

    public void testCreateController() throws Exception {
        SubModuleViewTest.assertNotNull((Object)this.subModuleNodeView.getController());
        SubModuleViewTest.assertEquals((Object)this.node, (Object)this.subModuleNodeView.getController().getNavigationNode());
    }

    public void testBlocking() {
        this.node.setBlocked(true);
        Composite parentComposite = (Composite)ReflectionUtils.invokeHidden(this.subModuleNodeView, (String)"getParentComposite", (Object[])new Object[0]);
        Composite contentComposite = (Composite)ReflectionUtils.invokeHidden(this.subModuleNodeView, (String)"getContentComposite", (Object[])new Object[0]);
        SubModuleViewTest.assertFalse((boolean)contentComposite.isEnabled());
        Cursor waitCursor = parentComposite.getDisplay().getSystemCursor(1);
        SubModuleViewTest.assertSame((Object)waitCursor, (Object)parentComposite.getCursor());
        this.node.setBlocked(false);
        SubModuleViewTest.assertTrue((boolean)contentComposite.isEnabled());
        Cursor arrowCursor = parentComposite.getDisplay().getSystemCursor(0);
        SubModuleViewTest.assertSame((Object)arrowCursor, (Object)parentComposite.getCursor());
    }

    public void testIsChildOfComplexComponent() {
        this.subModuleNodeView = new TestView();
        Shell shell = new Shell();
        Label label = new Label((Composite)shell, 0);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden(this.subModuleNodeView, (String)"isChildOfComplexComponent", (Object[])new Object[]{label});
        SubModuleViewTest.assertFalse((boolean)ret);
        TestComplexComponent complexComponent = new TestComplexComponent((Composite)shell, 0);
        Text text = new Text((Composite)complexComponent, 0);
        ret = (Boolean)ReflectionUtils.invokeHidden(this.subModuleNodeView, (String)"isChildOfComplexComponent", (Object[])new Object[]{text});
        SubModuleViewTest.assertTrue((boolean)ret);
        Composite composite = new Composite((Composite)shell, 0);
        Combo combo = new Combo(composite, 0);
        ret = (Boolean)ReflectionUtils.invokeHidden(this.subModuleNodeView, (String)"isChildOfComplexComponent", (Object[])new Object[]{combo});
        SubModuleViewTest.assertFalse((boolean)ret);
        Composite composite2 = new Composite((Composite)complexComponent, 0);
        Button button = new Button(composite2, 0);
        ret = (Boolean)ReflectionUtils.invokeHidden(this.subModuleNodeView, (String)"isChildOfComplexComponent", (Object[])new Object[]{button});
        SubModuleViewTest.assertTrue((boolean)ret);
        SwtUtilities.disposeWidget((Widget)shell);
    }

    public void testBindOnActivate() throws Exception {
        this.nodesBoundToView.clear();
        this.anotherNode.activate();
        SubModuleViewTest.assertTrue((boolean)this.nodesBoundToView.isEmpty());
        this.anotherNodeSameView.activate();
        SubModuleViewTest.assertTrue((boolean)this.nodesBoundToView.isEmpty());
        this.node.activate();
        SubModuleViewTest.assertEquals((int)1, (int)this.nodesBoundToView.size());
        SubModuleViewTest.assertSame((Object)this.node, (Object)this.nodesBoundToView.get(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestComplexComponent
    extends Composite
    implements IComplexComponent {
        public TestComplexComponent(Composite parent, int style) {
            super(parent, style);
        }

        public List<Object> getUIControls() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestView
    extends SubModuleView<SubModuleController> {
        private TestView() {
        }

        public void bind(SubModuleNode node) {
            SubModuleViewTest.this.nodesBoundToView.add(node);
        }

        public SubModuleNode getNavigationNode() {
            return SubModuleViewTest.this.node;
        }

        protected void basicCreatePartControl(Composite parent) {
        }
    }
}

