/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.authorizationservice;

import java.io.InputStream;
import java.security.Permission;
import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.security.authorizationservice.AuthorizationService;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.security.authorizationservice.IPermissionStore;
import org.eclipse.riena.security.authorizationservice.TestcasePermission;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.authentication.SimplePrincipal;
import org.eclipse.riena.security.common.authorization.IAuthorizationService;
import org.eclipse.riena.security.common.authorization.Sentinel;
import org.eclipse.riena.security.simpleservices.authorizationservice.store.FilePermissionStore;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@NonUITestCase
public class SentinelTest
extends RienaTestCase {
    private ServiceRegistration authorizationServiceReg;

    protected void setUp() throws Exception {
        super.setUp();
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("policy-def-test.xml");
        FilePermissionStore store = new FilePermissionStore(inputStream);
        ServiceReference ref = this.getContext().getServiceReference(IAuthorizationService.class.getName());
        if (ref != null && ref.getBundle().getState() == 32 && ref.getBundle() != Activator.getDefault().getBundle()) {
            ref.getBundle().stop();
        }
        AuthorizationService authorizationService = new AuthorizationService();
        this.authorizationServiceReg = this.getContext().registerService(IAuthorizationService.class.getName(), (Object)authorizationService, null);
        authorizationService.bind((IPermissionStore)store);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authorizationServiceReg.unregister();
    }

    public void testWithoutUser() {
        boolean result = Sentinel.checkAccess((Permission)new TestcasePermission("testPerm"));
        SentinelTest.assertFalse((String)"no permission if there is no subject", (boolean)result);
    }

    public void testValidUser() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal("testuser"));
        ((ISubjectHolder)Service.get(ISubjectHolder.class)).setSubject(subject);
        boolean result = Sentinel.checkAccess((Permission)new TestcasePermission("testPerm"));
        SentinelTest.assertTrue((String)"has permission since valid subject", (boolean)result);
    }

    public void testValidUserMissingPermissions() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal("anotheruser"));
        ((ISubjectHolder)Service.get(ISubjectHolder.class)).setSubject(subject);
        boolean result = Sentinel.checkAccess((Permission)new TestcasePermission("testPerm"));
        SentinelTest.assertFalse((String)"has no permission since subject has no permission", (boolean)result);
    }
}

