/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.services.itest.authentication;

import java.security.Principal;
import java.util.Arrays;
import javax.security.auth.Subject;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.authentication.AuthenticationFailure;
import org.eclipse.riena.security.common.authentication.AuthenticationTicket;
import org.eclipse.riena.security.common.authentication.IAuthenticationService;
import org.eclipse.riena.security.common.authentication.credentials.AbstractCredential;
import org.eclipse.riena.security.common.authentication.credentials.NameCredential;
import org.eclipse.riena.security.common.authentication.credentials.PasswordCredential;
import org.eclipse.riena.security.server.session.ISessionService;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.IntegrationTestCase;
import org.osgi.framework.ServiceReference;

@IntegrationTestCase
public class AuthenticationClientITest
extends RienaTestCase {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), AuthenticationClientITest.class);
    private IRemoteServiceRegistration sessionServiceRegistration;
    private IRemoteServiceRegistration authenticationServiceRegistration;

    protected void setUp() throws Exception {
        super.setUp();
        this.startBundles("org\\.eclipse\\.equinox\\.cm.*", null);
        this.startBundles("org\\.eclipse\\.equinox\\.log.*", null);
        this.startBundles("org\\.eclipse\\.riena.communication.core", null);
        this.startBundles("org\\.eclipse\\.riena.communication.factory.hessian", null);
        this.stopBundles("org\\.eclipse\\.riena.example.client", null);
        this.sessionServiceRegistration = Register.remoteProxy(ISessionService.class).usingUrl("http://localhost:8080/hessian/SessionService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
        this.authenticationServiceRegistration = Register.remoteProxy(IAuthenticationService.class).usingUrl("http://localhost:8080/hessian/AuthenticationService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.sessionServiceRegistration.unregister();
        this.authenticationServiceRegistration.unregister();
    }

    public void testLogin() throws Exception {
        this.trace("Looking up Authentication Service...: ");
        ServiceReference ref = this.getContext().getServiceReference(IAuthenticationService.class.getName());
        IAuthenticationService authenticationService = (IAuthenticationService)this.getContext().getService(ref);
        this.trace("Service looked up: " + authenticationService.getClass().getName());
        Object[] creds = new AbstractCredential[2];
        NameCredential nc = new NameCredential("username: ", "xx");
        nc.setName("testuser1");
        creds[0] = nc;
        PasswordCredential pc = new PasswordCredential("password: ", false);
        pc.setPassword("testpass2".toCharArray());
        creds[1] = pc;
        this.trace("Add credential: " + Arrays.toString(creds));
        AuthenticationTicket ticket = authenticationService.login("CentralSecurity", (AbstractCredential[])creds);
        this.trace("Return from login() - ticket: " + ticket);
        AuthenticationClientITest.assertNotNull((Object)ticket);
        AuthenticationClientITest.assertNotNull((Object)ticket.getSession());
        AuthenticationClientITest.assertNotNull((Object)ticket.getPrincipals());
        this.trace("Login successful - ticket: " + ticket);
        authenticationService.logout();
        this.trace("Logoff successful.");
    }

    public void testInvalidLogin() throws Exception {
        try {
            ServiceReference ref = this.getContext().getServiceReference(IAuthenticationService.class.getName());
            IAuthenticationService authenticationService = (IAuthenticationService)this.getContext().getService(ref);
            AbstractCredential[] creds = new AbstractCredential[2];
            NameCredential nc = new NameCredential("username: ", "xx");
            nc.setName("john");
            creds[0] = nc;
            PasswordCredential pc = new PasswordCredential("password: ", false);
            pc.setPassword("jane".toCharArray());
            creds[1] = pc;
            authenticationService.login("Test", creds);
            AuthenticationClientITest.fail((String)"exception expected");
        }
        catch (AuthenticationFailure authenticationFailure) {
            this.ok("exception expected");
        }
    }

    public void testSubjectLogin() throws Exception {
        ServiceReference ref = this.getContext().getServiceReference(IAuthenticationService.class.getName());
        IAuthenticationService authenticationService = (IAuthenticationService)this.getContext().getService(ref);
        this.trace("Service looked up: " + authenticationService.getClass().getName());
        AbstractCredential[] creds = new AbstractCredential[2];
        NameCredential nc = new NameCredential("username: ", "xx");
        nc.setName("testuser1");
        creds[0] = nc;
        PasswordCredential pc = new PasswordCredential("password: ", false);
        pc.setPassword("testpass2".toCharArray());
        creds[1] = pc;
        AuthenticationTicket ticket = authenticationService.login("CentralSecurity", creds);
        this.trace("Return from login() - ticket: " + ticket);
        Subject subject = new Subject();
        for (Principal p : ticket.getPrincipals()) {
            subject.getPrincipals().add(p);
        }
        ((ISubjectHolder)Service.get(ISubjectHolder.class)).setSubject(subject);
        AuthenticationClientITest.assertTrue((((ISubjectHolder)Service.get(ISubjectHolder.class)).getSubject() == subject ? 1 : 0) != 0);
    }

    private void trace(String msg) {
        LOGGER.log(3, "|--->" + msg);
    }
}

