/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.tests;

import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import junit.framework.Assert;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public final class TestUtils {
    private TestUtils() {
    }

    public static void assertMandatoryMarker(IMarkableRidget ridget, int expectedCount, boolean disabledState) {
        Collection markers = ridget.getMarkersOfType(MandatoryMarker.class);
        Assert.assertEquals((int)expectedCount, (int)markers.size());
        Iterator iter = markers.iterator();
        while (iter.hasNext()) {
            boolean isDisabled = ((MandatoryMarker)iter.next()).isDisabled();
            Assert.assertEquals((boolean)disabledState, (boolean)isDisabled);
        }
    }

    public static void assertMessageCount(IMarkable ridget, Class markerType, int count) {
        Collection collection = ridget.getMarkersOfType(markerType);
        if (count != collection.size()) {
            System.out.println(String.format("assertion failed on message count -- expected %d, got %d:", count, collection.size()));
            for (IMessageMarker messageMarker : collection) {
                System.out.println("\t" + messageMarker.getMessage());
            }
        }
        Assert.assertEquals((int)count, (int)collection.size());
    }

    public static void assertMessage(IMarkable ridget, Class markerType, String message) {
        Collection collection = ridget.getMarkersOfType(markerType);
        boolean wasFound = false;
        Iterator iter = collection.iterator();
        while (!wasFound && iter.hasNext()) {
            IMessageMarker marker = (IMessageMarker)iter.next();
            wasFound = message.equals(marker.getMessage());
        }
        Assert.assertEquals((String)String.format("Message '%s'", message), (boolean)true, (boolean)wasFound);
    }

    public static void assertText(Text control, String before, String keySeq, String after) {
        TestUtils.forceText(control, before);
        TestUtils.checkText(control, before);
        TestUtils.checkSelection(control, before);
        TestUtils.checkCaret(control, before);
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), keySeq);
        TestUtils.checkText(control, after);
        TestUtils.checkCaret(control, after);
    }

    public static void assertText(Text control, String before, int keyCode, String after) {
        TestUtils.forceText(control, before);
        TestUtils.checkText(control, before);
        TestUtils.checkSelection(control, before);
        TestUtils.checkCaret(control, before);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), keyCode);
        TestUtils.checkText(control, after);
        TestUtils.checkCaret(control, after);
    }

    public static boolean isArabLocaleAvailable() {
        Locale arabLocale = new Locale("ar", "AE");
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale availableLocale = localeArray[n2];
            if (availableLocale.equals(arabLocale)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getLocalizedNumber(String number) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        char decimalSep = dfs.getDecimalSeparator();
        char groupingSep = dfs.getGroupingSeparator();
        String result = number.replace('.', '_').replace(',', decimalSep).replace('_', groupingSep);
        return result;
    }

    public static void printMarkers(IMarkable markable) {
        Collection markers = markable.getMarkers();
        System.out.println(String.format("Have %d markers::", markers.size()));
        for (IMarker m : markers) {
            System.out.println(m.toString());
        }
    }

    private static void checkText(Text control, String input) {
        String expected = TestUtils.removePositionMarkers(input);
        Assert.assertEquals((String)expected, (String)control.getText());
    }

    private static void checkSelection(Text control, String input) {
        int start = input.indexOf(94);
        int end = input.lastIndexOf(94);
        String expected = "";
        if (start < end) {
            expected = input.substring(start + 1, end);
        }
        Assert.assertEquals((String)expected, (String)control.getSelectionText());
    }

    private static void checkCaret(Text control, String input) {
        int start = input.indexOf(94);
        if (start != -1) {
            int end = input.lastIndexOf(94);
            int expected = start < end ? end - 1 : end;
            Assert.assertEquals((int)expected, (int)control.getCaretPosition());
        }
    }

    private static String removePositionMarkers(String input) {
        StringBuilder result = new StringBuilder(input.length());
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (ch != '^') {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    private static void forceText(Text control, String text) {
        Listener listener;
        Listener[] listeners;
        int start = text.indexOf(94);
        int end = text.lastIndexOf(94);
        Listener[] listenerArray = listeners = control.getListeners(25);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            listener = listenerArray[n2];
            control.removeListener(25, listener);
            ++n2;
        }
        control.setText(TestUtils.removePositionMarkers(text));
        listenerArray = listeners;
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            listener = listenerArray[n2];
            control.addListener(25, listener);
            ++n2;
        }
        control.setFocus();
        if (start == end) {
            control.setSelection(start, start);
        } else {
            control.setSelection(start, end - 1);
        }
    }
}

