/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.ValidDate;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;

@NonUITestCase
public class ValidDateTest
extends RienaTestCase {
    public final void testDateDDMMYYYYFormat() throws Exception {
        ValidDate rule = new ValidDate("dd.MM.yyyy");
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"12.12.2004").isOK());
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"30.09.1999").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"9.12.2004").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"44.12.2004").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"12.13.2004").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"12.2004").isOK());
    }

    public final void testDateMMYYYYFormat() throws Exception {
        ValidDate rule = new ValidDate("MM.yyyy");
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"12.2004").isOK());
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"09.1999").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"13.2004").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"2004").isOK());
    }

    public final void testDateYYYYFormat() throws Exception {
        ValidDate rule = new ValidDate("yyyy");
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"2004").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"12.2004").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"004").isOK());
    }

    public void testFebruary29th() throws Exception {
        ValidDate rule = new ValidDate("dd.MM");
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"28.02").isOK());
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"29.02").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"30.02").isOK());
        rule = new ValidDate("MM/dd");
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"02/28").isOK());
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"02/29").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"02/30").isOK());
        rule = new ValidDate("dd.MM.yyyy");
        ValidDateTest.assertTrue((boolean)rule.validate((Object)"28.02.2007").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"29.02.2007").isOK());
        ValidDateTest.assertFalse((boolean)rule.validate((Object)"30.02.2007").isOK());
    }

    public void testException() throws Exception {
        try {
            ValidDate rule = new ValidDate("dd.MM");
            rule.validate(new Object());
            ValidDateTest.fail((String)"expected thrown ValidationFailure.");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected thrown ValidationFailure.");
        }
        catch (RuntimeException e) {
            ValidDateTest.fail((String)("expected ValidationFailure instead of " + e.getClass().getName()));
        }
    }

    public void testSetInitializationData() throws Exception {
        ValidDate validator = new ValidDate();
        validator.setInitializationData(null, null, (Object)"dd.MM");
        ValidDateTest.assertTrue((boolean)validator.validate((Object)"28.03").isOK());
        ValidDateTest.assertFalse((boolean)validator.validate((Object)"28.03.2000").isOK());
        ValidDateTest.assertFalse((boolean)validator.validate((Object)"32.03").isOK());
        validator = new ValidDate();
        validator.setInitializationData(null, null, (Object)"dd.MM.yy");
        ValidDateTest.assertFalse((boolean)validator.validate((Object)"28.03").isOK());
        ValidDateTest.assertFalse((boolean)validator.validate((Object)"28.03.2000").isOK());
        ValidDateTest.assertTrue((boolean)validator.validate((Object)"28.03.00").isOK());
        ValidDateTest.assertFalse((boolean)validator.validate((Object)"32.03.00").isOK());
        validator = new ValidDate();
        validator.setInitializationData(null, null, (Object)"dd.MM.yyyy");
        ValidDateTest.assertFalse((boolean)validator.validate((Object)"28.03").isOK());
        ValidDateTest.assertTrue((boolean)validator.validate((Object)"28.03.2000").isOK());
        ValidDateTest.assertFalse((boolean)validator.validate((Object)"28.03.00").isOK());
        ValidDateTest.assertFalse((boolean)validator.validate((Object)"32.03.2000").isOK());
    }
}

