/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.ValidExpression;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;

@NonUITestCase
public class ValidExpressionTest
extends RienaTestCase {
    public void testInvalidArgs() throws Exception {
        try {
            ValidExpression rule = new ValidExpression("^[0-9]{5}$", new ValidExpression.Option[0]);
            rule.validate(new Object());
            ValidExpressionTest.fail((String)("expected a thrown " + ValidationFailure.class.getName()));
        }
        catch (ValidationFailure validationFailure) {
            this.ok("passed test");
        }
        catch (RuntimeException runtimeException) {
            ValidExpressionTest.fail((String)("expected a thrown " + ValidationFailure.class.getName()));
        }
        try {
            new ValidExpression(null, new ValidExpression.Option[0]);
            ValidExpressionTest.fail((String)("Null expression: expected some kind of " + RuntimeException.class.getName()));
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
        try {
            new ValidExpression("", new ValidExpression.Option[0]);
            ValidExpressionTest.fail((String)("Empty expression: expected some kind of " + RuntimeException.class.getName()));
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
    }

    public void testSimpleExpression() throws Exception {
        ValidExpression rule = new ValidExpression("^[0-9]{5}$", new ValidExpression.Option[0]);
        ValidExpressionTest.assertFalse((boolean)rule.validate(null).isOK());
        ValidExpressionTest.assertFalse((boolean)rule.validate((Object)"").isOK());
        ValidExpressionTest.assertTrue((boolean)rule.validate((Object)"64372").isOK());
        ValidExpressionTest.assertTrue((boolean)rule.validate((Object)"04372").isOK());
        ValidExpressionTest.assertFalse((boolean)rule.validate((Object)"4372").isOK());
        ValidExpressionTest.assertFalse((boolean)rule.validate((Object)"123456").isOK());
        ValidExpressionTest.assertFalse((boolean)rule.validate((Object)"A6038").isOK());
    }

    public void testAdvancedExpression() throws Exception {
        ValidExpression rule = new ValidExpression("^([a-zA-Z]{6}[a-zA-Z\\d]{2})([a-zA-Z\\d]{3})?$", new ValidExpression.Option[0]);
        ValidExpressionTest.assertFalse((boolean)rule.validate(null).isOK());
        ValidExpressionTest.assertFalse((boolean)rule.validate((Object)"").isOK());
        ValidExpressionTest.assertTrue((String)"Natwest Offshore Bank Guernsey BIC", (boolean)rule.validate((Object)"RBOSGGSX").isOK());
        ValidExpressionTest.assertTrue((String)"Raiffeisenbank Kitzbuehel BIC", (boolean)rule.validate((Object)"RZTIAT22263").isOK());
        ValidExpressionTest.assertTrue((String)"Banque et Caisse d'Epargne de l'Etat BIC", (boolean)rule.validate((Object)"BCEELULL").isOK());
        ValidExpressionTest.assertTrue((String)"Deutsche Bundesbank Frankfurt am Main BIC", (boolean)rule.validate((Object)"MARKDEFF").isOK());
        ValidExpressionTest.assertTrue((String)"Deutsche Bundesbank Frankfurt am Main BIC (optional postfix)", (boolean)rule.validate((Object)"MARKDEFFXXX").isOK());
        ValidExpressionTest.assertTrue((String)"Schweizer Bank UBS AG BIC", (boolean)rule.validate((Object)"UBSWCHZH80A").isOK());
        ValidExpressionTest.assertTrue((String)"Rh\u00f6n-Rennsteig-Sparkasse BIC", (boolean)rule.validate((Object)"HELADEF1RRS").isOK());
        ValidExpressionTest.assertTrue((String)"Rh\u00f6n-Rennsteig-Sparkasse BIC, transactions from USA", (boolean)rule.validate((Object)"HELADEFF").isOK());
        ValidExpressionTest.assertFalse((String)"Alnum in first 6 characters", (boolean)rule.validate((Object)"R2OSGGSX").isOK());
        ValidExpressionTest.assertFalse((String)"postfix too long", (boolean)rule.validate((Object)"MARKDEFFXXXX").isOK());
    }

    public void testCaseInsensititvityOption() throws Exception {
        ValidExpression sensitiveRule = new ValidExpression("^test$", new ValidExpression.Option[0]);
        ValidExpressionTest.assertFalse((boolean)sensitiveRule.validate(null).isOK());
        ValidExpressionTest.assertFalse((boolean)sensitiveRule.validate((Object)"").isOK());
        ValidExpressionTest.assertTrue((boolean)sensitiveRule.validate((Object)"test").isOK());
        ValidExpressionTest.assertFalse((boolean)sensitiveRule.validate((Object)"TEST").isOK());
        ValidExpressionTest.assertFalse((boolean)sensitiveRule.validate((Object)"Test").isOK());
        ValidExpressionTest.assertFalse((boolean)sensitiveRule.validate((Object)"1Test").isOK());
        ValidExpressionTest.assertFalse((boolean)sensitiveRule.validate((Object)"Test1").isOK());
        ValidExpressionTest.assertFalse((boolean)sensitiveRule.validate((Object)"Te1st").isOK());
        ValidExpression insensitiveRule = new ValidExpression("^test$", new ValidExpression.Option[]{ValidExpression.Option.CASE_INSENSITIVE});
        ValidExpressionTest.assertFalse((boolean)insensitiveRule.validate(null).isOK());
        ValidExpressionTest.assertFalse((boolean)insensitiveRule.validate((Object)"").isOK());
        ValidExpressionTest.assertTrue((boolean)insensitiveRule.validate((Object)"test").isOK());
        ValidExpressionTest.assertTrue((boolean)insensitiveRule.validate((Object)"TEST").isOK());
        ValidExpressionTest.assertTrue((boolean)insensitiveRule.validate((Object)"Test").isOK());
        ValidExpressionTest.assertFalse((boolean)insensitiveRule.validate((Object)"1Test").isOK());
        ValidExpressionTest.assertFalse((boolean)insensitiveRule.validate((Object)"Test1").isOK());
        ValidExpressionTest.assertFalse((boolean)insensitiveRule.validate((Object)"Te1st").isOK());
    }

    public void testDoesNotBlockInputWhenFailing() {
        ValidExpression rule = new ValidExpression("^[0-9]{5}$", new ValidExpression.Option[0]);
        IStatus result = rule.validate((Object)"XX123");
        ValidExpressionTest.assertFalse((boolean)result.isOK());
        ValidExpressionTest.assertEquals((int)1025, (int)result.getCode());
    }

    public void testSetInitializationData() throws Exception {
        ValidExpression validator = new ValidExpression();
        validator.setInitializationData(null, null, (Object)"^test$");
        ValidExpressionTest.assertTrue((boolean)validator.validate((Object)"test").isOK());
        ValidExpressionTest.assertFalse((boolean)validator.validate((Object)"TEST").isOK());
        validator = new ValidExpression();
        validator.setInitializationData(null, null, (Object)"^test$,DUMM*");
        ValidExpressionTest.assertTrue((boolean)validator.validate((Object)"test").isOK());
        ValidExpressionTest.assertFalse((boolean)validator.validate((Object)"TEST").isOK());
    }
}

