/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import junit.framework.TestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.swt.lnf.FontDescriptor;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.graphics.Font;

@NonUITestCase
public class FontDescriptorTest
extends TestCase {
    private RienaDefaultLnf lnf;

    protected void setUp() throws Exception {
        this.lnf = LnfManager.getLnf();
    }

    protected void tearDown() throws Exception {
        this.lnf.setTheme(null);
        LnfManager.dispose();
        this.lnf = null;
    }

    public void testGetFontWithProps() throws Exception {
        this.lnf.initialize();
        FontDescriptor descriptor = new FontDescriptor(this.lnf);
        Font font = descriptor.getFont();
        FontDescriptorTest.assertNull((Object)font);
        descriptor.setKey("EmbeddedTitlebar.font");
        descriptor.setHeight(10);
        Font font1 = descriptor.getFont();
        Font font2 = descriptor.getFont();
        FontDescriptorTest.assertSame((Object)font1, (Object)font2);
        descriptor.setStyle(1);
        Font font3 = descriptor.getFont();
        FontDescriptorTest.assertNotSame((Object)font1, (Object)font3);
        descriptor.setHeight(-1);
        FontDescriptorTest.assertEquals((int)this.lnf.getIntegerSetting("FontDescriptor.defaultHeight"), (int)descriptor.getHeight());
        descriptor = new FontDescriptor("EmbeddedTitlebar.font", -1, -1, this.lnf);
        FontDescriptorTest.assertEquals((int)this.lnf.getIntegerSetting("FontDescriptor.defaultHeight"), (int)descriptor.getHeight());
    }
}

