/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.renderer;

import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.lnf.ImageLnfResource;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.AbstractTitleBarRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class AbstractTitleBarRendererTest
extends RienaTestCase {
    private static final String ICON_ECLIPSE = "eclipse.gif";
    private TitleBarRenderer renderer;
    private GC gc;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.gc = new GC((Drawable)this.shell);
        this.renderer = new TitleBarRenderer();
        this.renderer.setShell(this.shell);
        this.renderer.setBounds(0, 0, 100, 100);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
        this.gc = null;
        this.renderer.dispose();
        this.renderer = null;
        super.tearDown();
    }

    public void testResetBounds() {
        Rectangle rectangle;
        Rectangle[] btnBounds;
        this.renderer.setCloseable(true);
        this.renderer.setMaximizable(true);
        this.renderer.setMinimizable(true);
        this.renderer.paint(this.gc, null);
        AbstractTitleBarRendererTest.assertEquals((Object)new Rectangle(1, 1, 1, 1), (Object)this.renderer.getImageBounds());
        Rectangle[] rectangleArray = btnBounds = this.renderer.getButtonsBounds();
        int n = btnBounds.length;
        int n2 = 0;
        while (n2 < n) {
            rectangle = rectangleArray[n2];
            AbstractTitleBarRendererTest.assertFalse((boolean)new Rectangle(0, 0, 0, 0).equals((Object)rectangle));
            ++n2;
        }
        ReflectionUtils.invokeHidden((Object)((Object)this.renderer), (String)"resetBounds", (Object[])new Object[0]);
        AbstractTitleBarRendererTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)this.renderer.getImageBounds());
        rectangleArray = btnBounds = this.renderer.getButtonsBounds();
        n = btnBounds.length;
        n2 = 0;
        while (n2 < n) {
            rectangle = rectangleArray[n2];
            AbstractTitleBarRendererTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)rectangle);
            ++n2;
        }
    }

    public void testPaintButton() {
        RienaDefaultLnf originaLnf = LnfManager.getLnf();
        try {
            Image image = ImageStore.getInstance().getImage(ICON_ECLIPSE);
            Rectangle imageBounds = image.getBounds();
            LnfManager.setLnf((RienaDefaultLnf)new TitleBarLnf());
            this.renderer.setCloseable(true);
            this.renderer.setMaximizable(true);
            this.renderer.setMinimizable(true);
            ReflectionUtils.invokeHidden((Object)((Object)this.renderer), (String)"resetBounds", (Object[])new Object[0]);
            this.renderer.paintButton(this.gc, 0);
            Rectangle[] btnBounds = this.renderer.getButtonsBounds();
            AbstractTitleBarRendererTest.assertTrue((btnBounds[0].x < 100 ? 1 : 0) != 0);
            AbstractTitleBarRendererTest.assertTrue((btnBounds[0].x > 0 ? 1 : 0) != 0);
            AbstractTitleBarRendererTest.assertTrue((btnBounds[0].y > 0 ? 1 : 0) != 0);
            AbstractTitleBarRendererTest.assertEquals((int)imageBounds.width, (int)btnBounds[0].width);
            AbstractTitleBarRendererTest.assertEquals((int)imageBounds.height, (int)btnBounds[0].height);
            int i = 1;
            while (i < btnBounds.length) {
                AbstractTitleBarRendererTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)btnBounds[i]);
                ++i;
            }
            this.renderer.paintButton(this.gc, 1);
            btnBounds = this.renderer.getButtonsBounds();
            AbstractTitleBarRendererTest.assertTrue((btnBounds[1].x < 100 ? 1 : 0) != 0);
            AbstractTitleBarRendererTest.assertTrue((btnBounds[1].x > 0 ? 1 : 0) != 0);
            AbstractTitleBarRendererTest.assertTrue((btnBounds[1].x < btnBounds[0].x ? 1 : 0) != 0);
            AbstractTitleBarRendererTest.assertEquals((int)btnBounds[0].y, (int)btnBounds[1].y);
            AbstractTitleBarRendererTest.assertEquals((int)imageBounds.width, (int)btnBounds[1].width);
            AbstractTitleBarRendererTest.assertEquals((int)imageBounds.height, (int)btnBounds[1].height);
            i = 2;
            while (i < btnBounds.length) {
                AbstractTitleBarRendererTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)btnBounds[i]);
                ++i;
            }
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originaLnf);
        }
    }

    private static class TitleBarLnf
    extends RienaDefaultLnf {
        private TitleBarLnf() {
        }

        protected void initImageDefaults() {
            super.initImageDefaults();
            this.getResourceTable().put("Image1", new ImageLnfResource(AbstractTitleBarRendererTest.ICON_ECLIPSE));
            this.getResourceTable().put("Image2", new ImageLnfResource(AbstractTitleBarRendererTest.ICON_ECLIPSE));
            this.getResourceTable().put("Image3", new ImageLnfResource(AbstractTitleBarRendererTest.ICON_ECLIPSE));
            this.getResourceTable().put("InactiveImage1", new ImageLnfResource(AbstractTitleBarRendererTest.ICON_ECLIPSE));
            this.getResourceTable().put("InactiveImage2", new ImageLnfResource(AbstractTitleBarRendererTest.ICON_ECLIPSE));
            this.getResourceTable().put("InactiveImage3", new ImageLnfResource(AbstractTitleBarRendererTest.ICON_ECLIPSE));
        }
    }

    private static class TitleBarRenderer
    extends AbstractTitleBarRenderer {
        private TitleBarRenderer() {
        }

        protected String[] getBtnHoverImageKeys() {
            return null;
        }

        protected String[] getBtnHoverSelectedImageKeys() {
            return null;
        }

        protected String[] getBtnImageKeys() {
            return new String[]{"Image1", "Image2", "Image3"};
        }

        protected String[] getBtnInactiveImageKeys() {
            return new String[]{"InactiveImage1", "InactiveImage2", "InactiveImage3"};
        }

        protected void paintBackground(GC gc) {
        }

        protected Rectangle paintImage(GC gc) {
            return new Rectangle(1, 1, 1, 1);
        }

        protected Rectangle paintTitle(GC gc) {
            return new Rectangle(1, 1, 1, 1);
        }

        public Rectangle getImageBounds() {
            return super.getImageBounds();
        }

        public Rectangle[] getButtonsBounds() {
            return super.getButtonsBounds();
        }

        public void paintButton(GC gc, int btnIndex) {
            super.paintButton(gc, btnIndex);
        }
    }
}

