/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.tools.mirror;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.tools.mirror.RangeQuery;
import org.eclipse.equinox.internal.p2.tools.mirror.VersionRangedName;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.osgi.framework.BundleContext;

public class RepositoryMirroring {
    private IMetadataRepository metadataSourceRepository;
    private IMetadataRepository metadataDestinationRepository;
    private IArtifactRepository artifactSourceRepository;
    private IArtifactRepository artifactDestinationRepository;
    private boolean referencedIUs = false;
    private boolean validArtifactRepos = false;
    private boolean validMetadataRepos = false;
    private boolean mirrorArtifactsWithMetadata = false;
    private boolean raw = false;
    private boolean overwrite = false;
    private boolean verbose = false;
    private boolean compressed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RepositoryMirroring(URI metadataSourceLocation, URI metadataDestinationLocation, URI artifactSourceLocation, URI artifactDestinationLocation, boolean overwrite, boolean compressed) throws ProvisionException {
        this.overwrite = overwrite;
        this.compressed = compressed;
        if (metadataSourceLocation != null && metadataDestinationLocation != null) {
            MetadataRepositoryManager metadataRepoManager = new MetadataRepositoryManager();
            this.metadataSourceRepository = metadataRepoManager.loadRepository(metadataSourceLocation, null);
            metadataRepoManager.removeRepository(metadataSourceLocation);
            this.metadataDestinationRepository = this.initializeMetadataDestination(metadataRepoManager, metadataDestinationLocation);
            this.validMetadataRepos = this.validateMetadataRepositories();
        }
        if (artifactSourceLocation != null && artifactDestinationLocation != null) {
            ArtifactRepositoryManager artifactRepoManager = new ArtifactRepositoryManager();
            this.artifactSourceRepository = artifactRepoManager.loadRepository(artifactSourceLocation, null);
            artifactRepoManager.removeRepository(artifactSourceLocation);
            this.artifactDestinationRepository = this.initializeArtifactDestination(artifactRepoManager, artifactDestinationLocation);
            this.validArtifactRepos = this.validateArtifactRepositories();
        }
    }

    public void mirror(String[] iuSpecs, String[] artifactSpecs) throws ProvisionException {
        boolean bl = this.mirrorArtifactsWithMetadata = this.validArtifactRepos && artifactSpecs != null && artifactSpecs.length == 0 && iuSpecs != null;
        if (this.validMetadataRepos && iuSpecs != null) {
            this.mirrorMetadata(iuSpecs);
        }
        if (this.validArtifactRepos && !this.mirrorArtifactsWithMetadata && artifactSpecs != null) {
            this.mirrorArtifacts(artifactSpecs, this.raw);
        }
    }

    public void mirrorMetadata(String[] iuSpecs) throws ProvisionException {
        if (iuSpecs.length == 0) {
            this.mirrorMetadata((Query)InstallableUnitQuery.ANY);
        } else {
            VersionRangedName[] iuRanges = new VersionRangedName[iuSpecs.length];
            int i = 0;
            while (i < iuSpecs.length) {
                iuRanges[i] = VersionRangedName.parse(iuSpecs[i]);
                ++i;
            }
            this.mirrorMetadata((Query)new RangeQuery(iuRanges));
        }
    }

    public void mirrorMetadata(Query query) throws ProvisionException {
        Collector result = this.metadataSourceRepository.query(query, new Collector(), null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.mirrorMetadata((IInstallableUnit[])result.toArray((Class)clazz));
    }

    private void mirrorMetadata(IInstallableUnit[] ius) throws ProvisionException {
        if (this.referencedIUs) {
            ius = this.addTransitiveIUs(this.metadataSourceRepository, ius);
        }
        int i = 0;
        while (i < ius.length) {
            IInstallableUnit iu = ius[i];
            if (this.verbose) {
                System.out.println("Mirroring IU: " + iu);
            }
            if (this.mirrorArtifactsWithMetadata) {
                this.mirrorArtifacts(iu.getArtifacts(), this.raw);
            }
            ++i;
        }
        this.metadataDestinationRepository.addInstallableUnits(ius);
    }

    private void mirrorArtifact(IArtifactDescriptor descriptor) throws ProvisionException {
        IArtifactDescriptor newDescriptor;
        Object object = newDescriptor = this.raw ? descriptor : new ArtifactDescriptor(descriptor);
        if (this.artifactDestinationRepository.contains(descriptor)) {
            return;
        }
        OutputStream repositoryStream = null;
        try {
            repositoryStream = this.artifactDestinationRepository.getOutputStream(newDescriptor);
            if (repositoryStream == null) {
                return;
            }
            if (this.verbose) {
                System.out.println("Mirroring artifact: " + descriptor);
            }
            this.artifactSourceRepository.getRawArtifact(descriptor, repositoryStream, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (repositoryStream != null) {
                try {
                    repositoryStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void mirrorArtifacts(IArtifactKey[] keys, boolean raw) throws ProvisionException {
        int i = 0;
        while (i < keys.length) {
            IArtifactKey key = keys[i];
            IArtifactDescriptor[] descriptors = this.artifactSourceRepository.getArtifactDescriptors(key);
            int j = 0;
            while (j < descriptors.length) {
                this.mirrorArtifact(descriptors[j]);
                ++j;
            }
            ++i;
        }
    }

    private void mirrorArtifacts(String[] artifactSpecs, boolean raw) throws ProvisionException {
        IArtifactKey[] keys;
        if (artifactSpecs == null) {
            return;
        }
        if (artifactSpecs.length == 0) {
            keys = this.artifactSourceRepository.getArtifactKeys();
        } else {
            keys = new ArtifactKey[artifactSpecs.length];
            int i = 0;
            while (i < artifactSpecs.length) {
                keys[i] = ArtifactKey.parse((String)artifactSpecs[i]);
                ++i;
            }
        }
        this.mirrorArtifacts(keys, raw);
    }

    protected IInstallableUnit[] addTransitiveIUs(IMetadataRepository source, IInstallableUnit[] ius) {
        return ius;
    }

    private boolean validateMetadataRepositories() {
        if (this.metadataSourceRepository == null) {
            throw new IllegalStateException("Source metadata repository is null.");
        }
        if (this.metadataDestinationRepository == null) {
            throw new IllegalStateException("Destination metadata repository is null.");
        }
        if (!this.metadataDestinationRepository.isModifiable()) {
            throw new IllegalStateException("Destination metadata repository must be modifiable: " + this.metadataDestinationRepository.getLocation());
        }
        return true;
    }

    private boolean validateArtifactRepositories() {
        if (this.artifactSourceRepository == null) {
            throw new IllegalStateException("Source artifact repository is null.");
        }
        if (this.artifactDestinationRepository == null) {
            throw new IllegalStateException("Destination artifact repository is null.");
        }
        if (!this.artifactDestinationRepository.isModifiable()) {
            throw new IllegalStateException("Destination artifact repository must be modifiable: " + this.artifactDestinationRepository.getLocation());
        }
        return true;
    }

    private IMetadataRepository initializeMetadataDestination(MetadataRepositoryManager manager, URI destinationLocation) throws ProvisionException {
        try {
            String repositoryName = destinationLocation + " - metadata";
            HashMap<String, String> properties = null;
            if (this.compressed) {
                properties = new HashMap<String, String>(1);
                properties.put("p2.compressed", String.valueOf(this.compressed));
            }
            IMetadataRepository repository = manager.createRepository(destinationLocation, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            manager.removeRepository(destinationLocation);
            if (!repository.isModifiable()) {
                throw new IllegalArgumentException("Metadata repository not modifiable: " + destinationLocation);
            }
            return repository;
        }
        catch (ProvisionException provisionException) {
            IMetadataRepository repository = manager.loadRepository(destinationLocation, null);
            if (repository != null) {
                manager.removeRepository(destinationLocation);
            }
            if (!repository.isModifiable()) {
                throw new IllegalArgumentException("Metadata repository not modifiable: " + destinationLocation);
            }
            return repository;
        }
    }

    private IArtifactRepository initializeArtifactDestination(ArtifactRepositoryManager repoManager, URI destinationLocation) throws ProvisionException {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        try {
            IArtifactRepository repository;
            String repositoryName = destinationLocation + " - artifacts";
            HashMap<String, String> properties = null;
            if (this.compressed) {
                properties = new HashMap<String, String>(1);
                properties.put("p2.compressed", String.valueOf(this.compressed));
            }
            if ((repository = manager.createRepository(destinationLocation, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties)) != null) {
                manager.removeRepository(destinationLocation);
            }
            if (!repository.isModifiable()) {
                throw new IllegalArgumentException("Artifact repository not modifiable: " + destinationLocation);
            }
            if (this.overwrite) {
                repository.removeAll();
            }
            return repository;
        }
        catch (ProvisionException provisionException) {
            IArtifactRepository repository = manager.loadRepository(destinationLocation, null);
            manager.removeRepository(destinationLocation);
            return repository;
        }
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setReferencedIUs(boolean value) {
        this.referencedIUs = value;
    }

    public void setRaw(boolean value) {
        this.raw = value;
    }

    public void setCompressed(boolean value) {
        this.compressed = value;
    }
}

