/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.installer;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.installer.InstallerActivator;
import org.eclipse.equinox.internal.p2.installer.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.installer.IInstallOperation;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class InstallUpdateProductOperation
implements IInstallOperation {
    private IArtifactRepositoryManager artifactRepoMan;
    private BundleContext bundleContext;
    private IDirector director;
    private final InstallDescription installDescription;
    private boolean isInstall = true;
    private IMetadataRepositoryManager metadataRepoMan;
    private IProfileRegistry profileRegistry;
    private IStatus result;
    private ArrayList serviceReferences = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public InstallUpdateProductOperation(BundleContext context, InstallDescription description) {
        this.bundleContext = context;
        this.installDescription = description;
    }

    private IInstallableUnit[] computeUnitsToInstall() throws CoreException {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        VersionedName[] roots = this.installDescription.getRoots();
        int i = 0;
        while (i < roots.length) {
            VersionedName root = roots[i];
            IInstallableUnit iu = this.findUnit(root);
            if (iu != null) {
                result.add(iu);
            }
            ++i;
        }
        return result.toArray(new IInstallableUnit[result.size()]);
    }

    private IInstallableUnit[] computeUnitsToUninstall(IProfile p) {
        Collector collector = p.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInstallableUnit[])collector.toArray((Class)clazz);
    }

    private IProfile createProfile() throws ProvisionException {
        IProfile profile = this.getProfile();
        if (profile == null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("org.eclipse.equinox.p2.installFolder", this.installDescription.getInstallLocation().toString());
            BundleContext bundleContext = InstallerActivator.getDefault().getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            String env = "osgi.os=" + info.getOS() + ",osgi.ws=" + info.getWS() + ",osgi.arch=" + info.getOSArch();
            properties.put("org.eclipse.equinox.p2.environments", env);
            properties.put("org.eclipse.equinox.p2.name", this.installDescription.getProductName());
            properties.putAll(this.installDescription.getProfileProperties());
            IPath location = this.installDescription.getBundleLocation();
            if (location != null) {
                properties.put("org.eclipse.equinox.p2.cache", location.toOSString());
            }
            profile = this.profileRegistry.addProfile(this.getProfileId(), properties);
        }
        return profile;
    }

    private void doInstall(SubMonitor monitor) throws CoreException {
        IStatus s;
        this.prepareMetadataRepositories();
        this.prepareArtifactRepositories();
        IProfile p = this.createProfile();
        IInstallableUnit[] toInstall = this.computeUnitsToInstall();
        monitor.worked(5);
        ProfileChangeRequest request = new ProfileChangeRequest(p);
        if (this.isInstall) {
            monitor.setTaskName(NLS.bind((String)Messages.Op_Installing, (Object)this.installDescription.getProductName()));
            request.addInstallableUnits(toInstall);
            s = this.director.provision(request, null, (IProgressMonitor)monitor.newChild(90));
        } else {
            monitor.setTaskName(NLS.bind((String)Messages.Op_Updating, (Object)this.installDescription.getProductName()));
            IInstallableUnit[] toUninstall = this.computeUnitsToUninstall(p);
            request.removeInstallableUnits(toUninstall);
            request.addInstallableUnits(toInstall);
            s = this.director.provision(request, null, (IProgressMonitor)monitor.newChild(90));
        }
        if (!s.isOK()) {
            throw new CoreException(s);
        }
    }

    private CoreException fail(String message) {
        return this.fail(message, null);
    }

    private CoreException fail(String message, Throwable throwable) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.installer", message, throwable));
    }

    private IInstallableUnit findUnit(VersionedName spec) throws CoreException {
        String id = spec.getId();
        if (id == null) {
            throw this.fail(Messages.Op_NoId);
        }
        Version version = spec.getVersion();
        VersionRange range = VersionRange.emptyRange;
        if (version != null && !version.equals((Object)Version.emptyVersion)) {
            range = new VersionRange(version, true, version, true);
        }
        InstallableUnitQuery query = new InstallableUnitQuery(id, range);
        Collector collector = new Collector();
        Iterator matches = this.metadataRepoMan.query((Query)query, collector, null).iterator();
        IInstallableUnit newest = null;
        while (matches.hasNext()) {
            IInstallableUnit candidate = (IInstallableUnit)matches.next();
            if (newest != null && newest.getVersion().compareTo((Object)candidate.getVersion()) >= 0) continue;
            newest = candidate;
        }
        if (newest == null) {
            throw this.fail(String.valueOf(Messages.Op_IUNotFound) + id);
        }
        return newest;
    }

    private IProfile getProfile() {
        return this.profileRegistry.getProfile(this.getProfileId());
    }

    private String getProfileId() {
        IPath location = this.installDescription.getInstallLocation();
        if (location != null) {
            return location.toString();
        }
        return this.installDescription.getProductName();
    }

    public IStatus getResult() {
        return this.result;
    }

    private Object getService(String name) throws CoreException {
        ServiceReference ref = this.bundleContext.getServiceReference(name);
        if (ref == null) {
            throw this.fail(String.valueOf(Messages.Op_NoService) + name);
        }
        Object service = this.bundleContext.getService(ref);
        if (service == null) {
            throw this.fail(String.valueOf(Messages.Op_NoServiceImpl) + name);
        }
        this.serviceReferences.add(ref);
        return service;
    }

    public IStatus install(IProgressMonitor pm) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (String)Messages.Op_Preparing, (int)100);
        try {
            try {
                try {
                    this.preInstall();
                    this.isInstall = this.getProfile() == null;
                    this.doInstall(monitor);
                    this.result = new Status(0, "org.eclipse.equinox.p2.installer", this.isInstall ? Messages.Op_InstallComplete : Messages.Op_UpdateComplete, null);
                    monitor.setTaskName(Messages.Op_Cleanup);
                }
                finally {
                    this.postInstall();
                }
            }
            catch (CoreException e) {
                this.result = e.getStatus();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return this.result;
    }

    public boolean isFirstInstall() {
        return this.isInstall;
    }

    private void postInstall() {
        Iterator it = this.serviceReferences.iterator();
        while (it.hasNext()) {
            ServiceReference sr = (ServiceReference)it.next();
            this.bundleContext.ungetService(sr);
        }
        this.serviceReferences.clear();
    }

    private void preInstall() throws CoreException {
        this.serviceReferences.clear();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IDirector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.director = (IDirector)this.getService(clazz.getName());
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.metadataRepoMan = (IMetadataRepositoryManager)this.getService(clazz2.getName());
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.artifactRepoMan = (IArtifactRepositoryManager)this.getService(clazz3.getName());
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.profileRegistry = (IProfileRegistry)this.getService(clazz4.getName());
    }

    private void prepareArtifactRepositories() throws ProvisionException {
        URI[] repos = this.installDescription.getArtifactRepositories();
        if (repos == null) {
            return;
        }
        int i = 0;
        while (i < repos.length) {
            this.artifactRepoMan.loadRepository(repos[i], null);
            ++i;
        }
    }

    private void prepareMetadataRepositories() throws ProvisionException {
        URI[] repos = this.installDescription.getMetadataRepositories();
        if (repos == null) {
            return;
        }
        int i = 0;
        while (i < repos.length) {
            this.metadataRepoMan.loadRepository(repos[i], null);
            ++i;
        }
    }
}

