/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionDescriptor {
    private final String extensionPointId;
    private boolean homogeneous = true;
    private Class<?> interfaceType;
    private int minOccurences = 0;
    private int maxOccurences = Integer.MAX_VALUE;
    public static final int UNBOUNDED = Integer.MAX_VALUE;

    public ExtensionDescriptor(String extensionPointId) {
        Assert.isNotNull((Object)extensionPointId, (String)"The extension id must not be null.");
        this.extensionPointId = extensionPointId;
    }

    public ExtensionDescriptor useType(Class<?> interfaceType) {
        Assert.isNotNull(interfaceType, (String)"Interface type must not be null.");
        Assert.isTrue((boolean)interfaceType.isInterface(), (String)"Interface type must be an interface.");
        Assert.isTrue((this.interfaceType == null ? 1 : 0) != 0, (String)"Interface type has already been set.");
        this.interfaceType = interfaceType;
        return this;
    }

    public ExtensionDescriptor heterogeneous() {
        this.homogeneous = false;
        return this;
    }

    public ExtensionInjector into(Object target) {
        Assert.isNotNull((Object)target, (String)"The target must not be null.");
        return new ExtensionInjector(this, target);
    }

    public ExtensionDescriptor expectingMinMax(int min, int max) {
        Assert.isLegal((max >= min ? 1 : 0) != 0, (String)"min must not be greater than max.");
        Assert.isLegal((min >= 0 ? 1 : 0) != 0, (String)"min must be greater or equal than zero.");
        Assert.isLegal((max > 0 ? 1 : 0) != 0, (String)"max must be greater than zero.");
        this.minOccurences = min;
        this.maxOccurences = max;
        return this;
    }

    public ExtensionDescriptor expectingExactly(int exactly) {
        return this.expectingMinMax(exactly, exactly);
    }

    String getExtensionPointId() {
        return this.extensionPointId;
    }

    Class<?> getInterfaceType() {
        return this.interfaceType;
    }

    int getMinOccurences() {
        return this.minOccurences;
    }

    int getMaxOccurences() {
        return this.maxOccurences;
    }

    boolean isHomogeneous() {
        return this.homogeneous;
    }

    boolean requiresArrayUpdateMethod() {
        return this.minOccurences > 1 || this.maxOccurences > 1;
    }
}

