/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.ReflectionUtilsHiddenConstructor;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class ReflectionUtilsTest
extends RienaTestCase {
    public void testNewInstance1() {
        Object o = ReflectionUtils.newInstance((String)"java.lang.String", (Object[])new Object[]{"Hello!"});
        ReflectionUtilsTest.assertTrue((boolean)(o instanceof String));
        ReflectionUtilsTest.assertEquals((Object)o, (Object)"Hello!");
    }

    public void testNewInstance2() {
        Object o = ReflectionUtils.newInstance((String)"java.lang.String", (Object[])new Object[0]);
        ReflectionUtilsTest.assertTrue((boolean)(o instanceof String));
        ReflectionUtilsTest.assertEquals((Object)o, (Object)"");
    }

    public void testNewInstance3() {
        Object o = ReflectionUtils.newInstance((String)"java.awt.Dimension", (Object[])new Object[]{2, 2});
        ReflectionUtilsTest.assertTrue((boolean)(o instanceof Dimension));
        Dimension dim = (Dimension)o;
        ReflectionUtilsTest.assertEquals((Object)new Dimension(2, 2), (Object)dim);
    }

    public void testNewInstance4() {
        String s = (String)ReflectionUtils.newInstance(String.class, (Object[])new Object[]{"Hello!"});
        ReflectionUtilsTest.assertEquals((String)s, (String)"Hello!");
    }

    public void testNewInstanceHidden1() {
        try {
            ReflectionUtils.newInstance(ReflectionUtilsHiddenConstructor.class, (Object[])new Object[]{"something"});
            ReflectionUtilsTest.fail((String)"That should not work!");
        }
        catch (ReflectionFailure reflectionFailure) {
            Nop.reason((String)"Expected!");
        }
        Object o = ReflectionUtils.newInstanceHidden(ReflectionUtilsHiddenConstructor.class, (Object[])new Object[]{"something"});
        ReflectionUtilsTest.assertEquals((String)"something", (String)o.toString());
    }

    public void testNewInstanceHidden2() {
        Object o = ReflectionUtils.newInstanceHidden((String)ReflectionUtilsHiddenConstructor.class.getName(), (Object[])new Object[]{"anything"});
        ReflectionUtilsTest.assertEquals((String)"anything", (String)o.toString());
    }

    public void testInvokeHidden() throws MalformedURLException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL url = new URL("file:c:\\");
        ReflectionUtils.invokeHidden((Object)sysloader, (String)"addURL", (Object[])new Object[]{url});
    }

    public void testInvokeWithNull() {
        String str = "Hello";
        ReflectionUtilsTest.assertFalse((boolean)((Boolean)ReflectionUtils.invoke((Object)str, (String)"equals", (Object[])new Object[1])));
    }

    public void testInvokeHiddenWithMalformedURLException() {
        Thrower object = new Thrower();
        try {
            ReflectionUtils.invokeHidden((Object)object, (String)"setUrl", MalformedURLException.class, (Object[])new Object[]{"filez://murks.at"});
            ReflectionUtilsTest.fail((String)"MalformedURLException expected");
        }
        catch (MalformedURLException malformedURLException) {
            this.ok("MalformedURLException expected");
        }
    }

    public void testInvokeHiddenWithPrimitves() {
        ReflectionUtils.invokeHidden(TestClass.class, (String)"setIntegerObject", (Object[])new Object[]{1});
        Integer outInteger = (Integer)ReflectionUtils.invokeHidden(TestClass.class, (String)"getIntegerObject", (Object[])new Object[0]);
        ReflectionUtilsTest.assertEquals((int)1, (int)outInteger);
        ReflectionUtils.invokeHidden(TestClass.class, (String)"setIntPrimitive", (Object[])new Object[]{23});
        int outInt = (Integer)ReflectionUtils.invokeHidden(TestClass.class, (String)"getIntPrimitive", (Object[])new Object[0]);
        ReflectionUtilsTest.assertEquals((int)23, (int)outInt);
    }

    public void testInvokeHiddenClass() {
        ReflectionUtils.invokeHidden(TestClass.class, (String)"setString", (Object[])new Object[]{"hihi"});
        String out = (String)ReflectionUtils.invokeHidden(TestClass.class, (String)"getString", (Object[])new Object[0]);
        ReflectionUtilsTest.assertEquals((String)out, (String)"hihi");
    }

    public void testInvokeHiddenClassWithIOException() {
        try {
            ReflectionUtils.invokeHidden(Thrower.class, (String)"throwIOException", IOException.class, (Object[])new Object[0]);
            ReflectionUtilsTest.fail();
        }
        catch (IOException e) {
            ReflectionUtilsTest.assertEquals((String)"Yippie!", (String)e.getMessage());
        }
    }

    public void testSetGetHiddenInstance() {
        String s = "Hallo";
        ReflectionUtils.setHidden((Object)s, (String)"count", (Object)2);
        Integer count = (Integer)ReflectionUtils.getHidden((Object)s, (String)"count");
        ReflectionUtilsTest.assertEquals((int)2, (int)count);
        ReflectionUtilsTest.assertEquals((String)s, (String)"Ha");
    }

    public void testSetGetHiddenClass() {
        ReflectionUtils.setHidden(TestClass.class, (String)"string", (Object)"hallo");
        String out = (String)ReflectionUtils.getHidden(TestClass.class, (String)"string");
        ReflectionUtilsTest.assertEquals((String)out, (String)"hallo");
    }

    public void testSetGetHiddenDeepField() {
        TestTestClass ttc = new TestTestClass("Hallo");
        ReflectionUtils.setHidden((Object)ttc, (String)"privateString", (Object)"hurz");
        String hurz = (String)ReflectionUtils.getHidden((Object)ttc, (String)"privateString");
        ReflectionUtilsTest.assertEquals((String)"hurz", (String)hurz);
    }

    public void testSetGetHiddenDeepClassField() throws Throwable {
        ReflectionUtils.setHidden(TestTestClass.class, (String)"string", (Object)"hallo");
        String out = (String)ReflectionUtils.getHidden(TestTestClass.class, (String)"string");
        ReflectionUtilsTest.assertEquals((String)out, (String)"hallo");
    }

    public void testNewLazyInstanceByClass() {
        HaeshMaep.created = false;
        Map map = (Map)ReflectionUtils.newLazyInstance(Map.class, HaeshMaep.class, (Object[])new Object[0]);
        ReflectionUtilsTest.assertFalse((boolean)HaeshMaep.created);
        map.put("hi", "there");
        ReflectionUtilsTest.assertTrue((boolean)HaeshMaep.created);
    }

    public void testNewLazyInstanceByString() {
        HaeshMaep.created = false;
        Map map = (Map)ReflectionUtils.newLazyInstance(Map.class, (String)HaeshMaep.class.getName(), (Object[])new Object[0]);
        ReflectionUtilsTest.assertFalse((boolean)HaeshMaep.created);
        map.put("hi", "there");
        ReflectionUtilsTest.assertTrue((boolean)HaeshMaep.created);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HaeshMaep<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;
        protected static boolean created;

        public HaeshMaep() {
            created = true;
        }
    }

    private static class TestClass {
        private String privateString;
        private static String string;
        private static Integer integerObject;
        private static int intPrimitive;

        private TestClass(String str) {
            this.privateString = str;
        }

        private static void setString(String string) {
            TestClass.string = string;
        }

        private static String getString() {
            return string;
        }

        private static void setIntegerObject(Integer integerObject) {
            TestClass.integerObject = integerObject;
        }

        private static Integer getIntegerObject() {
            return integerObject;
        }

        private static void setIntPrimitive(int intPrimitive) {
            TestClass.intPrimitive = intPrimitive;
        }

        private static int getIntPrimitive() {
            return intPrimitive;
        }
    }

    private static final class TestTestClass
    extends TestClass {
        private static String stringString;

        private TestTestClass(String str) {
            super(str);
        }

        private static void setString(String string) {
            stringString = string;
        }

        private static String getString() {
            return stringString;
        }
    }

    private static final class Thrower {
        private Thrower() {
        }

        private void setUrl(String url) throws MalformedURLException {
            new URL(url);
        }

        private static String throwIOException() throws IOException {
            throw new IOException("Yippie!");
        }
    }
}

