/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.model.ApplicationNode;

@NonUITestCase
public class ApplicationNodeManagerTest
extends TestCase {
    private IApplicationNode model = null;

    protected void setUp() throws Exception {
        ApplicationNodeManager.clear();
        this.model = new ApplicationNode();
    }

    protected void tearDown() throws Exception {
    }

    public void testAddDefaultModel() throws Exception {
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)this.model);
        IApplicationNode rModel = ApplicationNodeManager.getApplicationNode();
        ApplicationNodeManagerTest.assertNotNull((Object)rModel);
    }

    public void testAddNamedModel() throws Exception {
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)new ApplicationNode(null, "MyModel"));
        IApplicationNode rModel = ApplicationNodeManager.getApplicationNode((String)"MyModel");
        ApplicationNodeManagerTest.assertNotNull((Object)rModel);
    }

    public void testApplicationModelFailure() throws Exception {
        boolean exOk = false;
        try {
            ApplicationNodeManager.registerApplicationNode((IApplicationNode)this.model);
            ApplicationNodeManager.registerApplicationNode((IApplicationNode)this.model);
        }
        catch (ApplicationModelFailure applicationModelFailure) {
            exOk = true;
        }
        ApplicationNodeManagerTest.assertTrue((String)"duplicate default model registration didn't fire a ApplicationModelFailure", (boolean)exOk);
        exOk = false;
        try {
            ApplicationNodeManager.registerApplicationNode((IApplicationNode)new ApplicationNode(null, "MyModel"));
            ApplicationNodeManager.registerApplicationNode((IApplicationNode)new ApplicationNode(null, "MyModel"));
        }
        catch (ApplicationModelFailure applicationModelFailure) {
            exOk = true;
        }
        ApplicationNodeManagerTest.assertTrue((String)"duplicate named registration didn't fire a ApplicationModelFailure", (boolean)exOk);
    }

    public void testGetDefaultModel() throws Exception {
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)this.model);
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)new ApplicationNode(null, "MyModel"));
        IApplicationNode rModel = ApplicationNodeManager.getApplicationNode();
        ApplicationNodeManagerTest.assertNotNull((Object)rModel);
        ApplicationNodeManagerTest.assertSame((Object)this.model, (Object)rModel);
    }

    public void testGetDefaultModelWhenNamedAndSingle() throws Exception {
        this.model = new ApplicationNode(null, "MyModel");
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)this.model);
        IApplicationNode rModel = ApplicationNodeManager.getApplicationNode();
        ApplicationNodeManagerTest.assertNotNull((Object)rModel);
        ApplicationNodeManagerTest.assertSame((Object)this.model, (Object)rModel);
    }

    public void testGetNamedModel() throws Exception {
        this.model = new ApplicationNode(null, "MyModel");
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)this.model);
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)new ApplicationNode(null, "MyModell"));
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)new ApplicationNode(null, "MyModel2"));
        IApplicationNode rModel = ApplicationNodeManager.getApplicationNode((String)"MyModel");
        ApplicationNodeManagerTest.assertNotNull((Object)rModel);
        ApplicationNodeManagerTest.assertSame((Object)this.model, (Object)rModel);
    }
}

