/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.ShellRidget;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class ModuleControllerTest
extends TestCase {
    public void testAfterBind() throws Exception {
        ModuleNode node = new ModuleNode();
        node.setClosable(true);
        node.setLabel("Hello");
        ModuleController controller = new ModuleController((IModuleNode)node);
        ShellRidget shellRidget = new ShellRidget();
        Shell shell = new Shell();
        shellRidget.setUIControl((Object)shell);
        controller.setWindowRidget((IWindowRidget)shellRidget);
        controller.afterBind();
        ModuleControllerTest.assertTrue((boolean)controller.isCloseable());
        ModuleControllerTest.assertEquals((String)"Hello", (String)shellRidget.getTitle());
        node.setClosable(false);
        controller.configureRidgets();
        ModuleControllerTest.assertFalse((boolean)controller.isCloseable());
        shell.dispose();
    }

    public void testSetLabel() throws Exception {
        ModuleNode node = new ModuleNode();
        SubModuleNode subNode1 = new SubModuleNode();
        node.addChild((INavigationNode)subNode1);
        ModuleController controller = new ModuleController((IModuleNode)node);
        SubModuleController subModuleController1 = new SubModuleController((ISubModuleNode)subNode1);
        ShellRidget shellRidget = new ShellRidget();
        Shell shell = new Shell();
        shellRidget.setUIControl((Object)shell);
        controller.setWindowRidget((IWindowRidget)shellRidget);
        ShellRidget subModuleShellRidget1 = new ShellRidget();
        Shell subModuleShell1 = new Shell();
        subModuleShellRidget1.setUIControl((Object)subModuleShell1);
        subModuleController1.setWindowRidget((IWindowRidget)subModuleShellRidget1);
        node.setLabel("Hello");
        ModuleControllerTest.assertEquals((String)"Hello", (String)shellRidget.getTitle());
        ModuleControllerTest.assertEquals((String)"Hello", (String)subModuleShellRidget1.getTitle());
        shell.dispose();
        subModuleShell1.dispose();
        ModuleNode modNode = new ModuleNode();
        SubModuleNode subModNode1 = new SubModuleNode();
        SubModuleNode subModNode2 = new SubModuleNode();
        modNode.addChild((INavigationNode)subModNode1);
        modNode.addChild((INavigationNode)subModNode2);
        ModuleController modController = new ModuleController((IModuleNode)modNode);
        SubModuleController subModController1 = new SubModuleController((ISubModuleNode)subModNode1);
        SubModuleController subModController2 = new SubModuleController((ISubModuleNode)subModNode2);
        ShellRidget shellRidgetMod = new ShellRidget();
        Shell shellMod = new Shell();
        shellRidgetMod.setUIControl((Object)shellMod);
        modController.setWindowRidget((IWindowRidget)shellRidgetMod);
        ShellRidget subModShellRidget1 = new ShellRidget();
        Shell subModShell1 = new Shell();
        subModShellRidget1.setUIControl((Object)subModShell1);
        subModController1.setWindowRidget((IWindowRidget)subModShellRidget1);
        ShellRidget subModShellRidget2 = new ShellRidget();
        Shell subModShell2 = new Shell();
        subModShellRidget2.setUIControl((Object)subModShell2);
        subModController2.setWindowRidget((IWindowRidget)subModShellRidget2);
        modNode.setLabel("Module");
        subModNode1.setLabel("SubModule 1");
        subModNode2.setLabel("SubModule 2");
        ModuleControllerTest.assertEquals((String)"Module", (String)shellRidgetMod.getTitle());
        ModuleControllerTest.assertEquals((String)"Module - SubModule 1", (String)subModShellRidget1.getTitle());
        ModuleControllerTest.assertEquals((String)"Module - SubModule 2", (String)subModShellRidget2.getTitle());
        shellMod.dispose();
        subModShell1.dispose();
        subModShell2.dispose();
    }

    public void testGetVisibleChildren() {
        ModuleNode node = new ModuleNode();
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubModuleNode sub1 = new SubModuleNode();
        node.addChild((INavigationNode)sub1);
        SubModuleNode sub2 = new SubModuleNode();
        node.addChild((INavigationNode)sub2);
        SubModuleNode sub3 = new SubModuleNode();
        node.addChild((INavigationNode)sub3);
        ModuleController controller = new ModuleController((IModuleNode)node);
        List nodes = controller.getVisibleChildren((INavigationNode)node);
        ModuleControllerTest.assertEquals((int)3, (int)nodes.size());
        ModuleControllerTest.assertSame((Object)sub1, nodes.get(0));
        ModuleControllerTest.assertSame((Object)sub2, nodes.get(1));
        ModuleControllerTest.assertSame((Object)sub3, nodes.get(2));
        sub1.setEnabled(false);
        sub2.setVisible(false);
        nodes = controller.getVisibleChildren((INavigationNode)node);
        ModuleControllerTest.assertEquals((int)2, (int)nodes.size());
        ModuleControllerTest.assertSame((Object)sub1, nodes.get(0));
        ModuleControllerTest.assertSame((Object)sub3, nodes.get(1));
    }

    public void testHasSingleLeafChild() {
        ModuleNode node = new ModuleNode();
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubModuleNode sub1 = new SubModuleNode();
        node.addChild((INavigationNode)sub1);
        SubModuleNode sub2 = new SubModuleNode();
        node.addChild((INavigationNode)sub2);
        SubModuleNode sub3 = new SubModuleNode();
        sub2.addChild((INavigationNode)sub3);
        ModuleController controller = new ModuleController((IModuleNode)node);
        ModuleControllerTest.assertFalse((boolean)controller.hasSingleLeafChild());
        sub1.setVisible(false);
        ModuleControllerTest.assertFalse((boolean)controller.hasSingleLeafChild());
        sub1.setVisible(true);
        sub2.setVisible(false);
        ModuleControllerTest.assertTrue((boolean)controller.hasSingleLeafChild());
        sub2.setVisible(true);
        ModuleControllerTest.assertFalse((boolean)controller.hasSingleLeafChild());
        node.removeChild((INavigationNode)sub2);
        ModuleControllerTest.assertTrue((boolean)controller.hasSingleLeafChild());
    }
}

