/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf;

import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@NonUITestCase
public class LnfManagerTest
extends TestCase {
    private RienaDefaultLnf oldLnf;

    protected void setUp() throws Exception {
        this.oldLnf = LnfManager.getLnf();
    }

    protected void tearDown() throws Exception {
        LnfManager.setLnf((RienaDefaultLnf)this.oldLnf);
    }

    public void testGetLnfClassNameAndGetLnfUnderDifferentConfigurations() {
        LnfManagerTest.assertEquals((String)RienaDefaultLnf.class.getName(), (String)LnfManager.getLnfClassName());
        LnfManagerTest.assertEquals(RienaDefaultLnf.class, LnfManager.getLnf().getClass());
        OtherDefaultTestLnf otherDefaultLnf = new OtherDefaultTestLnf();
        LnfManager.setDefaultLnf((RienaDefaultLnf)otherDefaultLnf);
        LnfManagerTest.assertEquals((String)((Object)((Object)otherDefaultLnf)).getClass().getName(), (String)LnfManager.getLnfClassName());
        LnfManagerTest.assertEquals(((Object)((Object)otherDefaultLnf)).getClass(), LnfManager.getLnf().getClass());
        LnfManager.setLnf((String)(String.valueOf(FrameworkUtil.getBundle(LnfManagerTest.class).getSymbolicName()) + ":" + TestLnf1.class.getName()));
        LnfManagerTest.assertEquals((String)TestLnf1.class.getName(), (String)LnfManager.getLnfClassName());
        LnfManagerTest.assertEquals(TestLnf1.class, LnfManager.getLnf().getClass());
        LnfManager.setLnf(null);
        LnfManagerTest.assertEquals((String)((Object)((Object)otherDefaultLnf)).getClass().getName(), (String)LnfManager.getLnfClassName());
        LnfManagerTest.assertEquals(((Object)((Object)otherDefaultLnf)).getClass(), LnfManager.getLnf().getClass());
    }

    public void testGetLnfClassNameAndGetLnfWithSystemProperty() {
        LnfManager.setLnf(null);
        Bundle bundle = FrameworkUtil.getBundle(LnfManagerTest.class);
        LnfManagerTest.assertNotNull((Object)bundle);
        try {
            System.setProperty("riena.lnf", String.valueOf(bundle.getSymbolicName()) + ":" + TestLnf1.class.getName());
            LnfManagerTest.assertEquals((String)TestLnf1.class.getName(), (String)LnfManager.getLnfClassName());
            LnfManagerTest.assertEquals(TestLnf1.class, LnfManager.getLnf().getClass());
            LnfManager.setLnf((RienaDefaultLnf)new TestLnf2());
            LnfManagerTest.assertEquals((String)TestLnf2.class.getName(), (String)LnfManager.getLnfClassName());
            LnfManagerTest.assertEquals(TestLnf2.class, LnfManager.getLnf().getClass());
        }
        finally {
            System.clearProperty("riena.lnf");
        }
    }

    public void testDispose() {
        RienaDefaultLnf myLnf = new RienaDefaultLnf();
        LnfManager.setLnf((RienaDefaultLnf)myLnf);
        myLnf.initialize();
        LnfManagerTest.assertNotNull((Object)myLnf.getColor("EmbeddedTitlebar.foreground"));
        LnfManager.dispose();
        LnfManagerTest.assertNull((Object)myLnf.getColor("EmbeddedTitlebar.foreground"));
    }

    public static class OtherDefaultTestLnf
    extends RienaDefaultLnf {
    }

    public static class TestLnf1
    extends RienaDefaultLnf {
    }

    public static class TestLnf2
    extends RienaDefaultLnf {
    }
}

