/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MasterDetailsCompositeTest
extends TestCase {
    private Shell shell;
    private MasterDetailsComposite masterDetails;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.masterDetails = new MasterDetailsComposite((Composite)this.shell, 0);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testGetUIControlsWithBindingProperty() {
        Text txtFirstName = UIControlsFactory.createText((Composite)this.masterDetails.getDetails(), (int)2048, (String)"txtFirstName");
        Text txtLastName = UIControlsFactory.createText((Composite)this.masterDetails.getDetails(), (int)2048, (String)"txtLastName");
        Text txtWithoutID = UIControlsFactory.createText((Composite)this.masterDetails.getDetails(), (int)2048);
        List controls = this.masterDetails.getUIControls();
        MasterDetailsCompositeTest.assertNotNull((Object)controls);
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(txtFirstName));
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(txtLastName));
        MasterDetailsCompositeTest.assertFalse((boolean)controls.contains(txtWithoutID));
    }

    public void testGetUIControlsWithBindingPropertyFromComposite() {
        Composite detail = new Composite(this.masterDetails.getDetails(), 0);
        Text txtFirstName = UIControlsFactory.createText((Composite)detail, (int)2048, (String)"txtFirstName");
        Text txtLastName = UIControlsFactory.createText((Composite)detail, (int)2048, (String)"txtLastName");
        Text txtWithoutID = UIControlsFactory.createText((Composite)detail, (int)2048);
        List controls = this.masterDetails.getUIControls();
        MasterDetailsCompositeTest.assertNotNull((Object)controls);
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(txtFirstName));
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(txtLastName));
        MasterDetailsCompositeTest.assertFalse((boolean)controls.contains(txtWithoutID));
    }
}

