/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeRidget
extends AbstractRidget
implements IComplexRidget {
    private IComplexComponent uiControl;
    private Map<String, IRidget> ridgets = new HashMap<String, IRidget>();
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    protected boolean markedHidden = false;
    private boolean enabled = true;
    private String toolTip = null;

    @Override
    public boolean isVisible() {
        if (this.markedHidden) {
            return false;
        }
        if (this.getUIControl() != null) {
            return this.isUIControlVisible();
        }
        return this.savedVisibleState;
    }

    protected boolean isUIControlVisible() {
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.markedHidden == visible) {
            this.markedHidden = !visible;
            this.updateVisible();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.updateEnabled();
        }
    }

    public IComplexComponent getUIControl() {
        return this.uiControl;
    }

    @Override
    public void setUIControl(Object uiControl) {
        if (uiControl != null && !(uiControl instanceof IComplexComponent)) {
            throw new UIBindingFailure("uiControl of a AbstractCompositeRidget must be a IComplexComponent but was a " + uiControl.getClass().getSimpleName());
        }
        this.checkUIControl(uiControl);
        this.unbindUIControl();
        this.savedVisibleState = this.getUIControl() != null ? this.isUIControlVisible() : this.savedVisibleState;
        this.uiControl = (IComplexComponent)uiControl;
        this.updateVisible();
        this.updateEnabled();
        this.updateToolTipText();
        this.bindUIControl();
    }

    protected void checkUIControl(Object uiControl) {
    }

    protected void bindUIControl() {
    }

    protected void unbindUIControl() {
    }

    @Override
    public void addRidget(String id, IRidget ridget) {
        ridget.addPropertyChangeListener(this.propertyChangeListener);
        this.ridgets.put(id, ridget);
    }

    @Override
    public IRidget getRidget(String id) {
        return this.ridgets.get(id);
    }

    @Override
    public Collection<? extends IRidget> getRidgets() {
        return this.ridgets.values();
    }

    @Override
    public void requestFocus() {
        if (!this.getRidgets().isEmpty()) {
            this.getRidgets().iterator().next().requestFocus();
        }
    }

    @Override
    public boolean hasFocus() {
        Collection<? extends IRidget> myRidgets = this.getRidgets();
        for (IRidget iRidget : myRidgets) {
            if (!iRidget.hasFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        for (IRidget iRidget : this.getRidgets()) {
            iRidget.setFocusable(focusable);
        }
    }

    @Override
    public boolean isFocusable() {
        for (IRidget iRidget : this.getRidgets()) {
            if (!iRidget.isFocusable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getToolTipText() {
        return this.toolTip;
    }

    @Override
    public void setToolTipText(String toolTipText) {
        String oldValue = this.toolTip;
        this.toolTip = toolTipText;
        this.updateToolTipText();
        this.firePropertyChange("tooltip", oldValue, this.toolTip);
    }

    @Override
    public void configureRidgets() {
    }

    @Override
    public String getID() {
        return null;
    }

    protected void updateVisible() {
    }

    protected void updateEnabled() {
    }

    protected void updateToolTipText() {
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractCompositeRidget.this.propertyChangeSupport.firePropertyChange(evt);
        }
    }
}

