/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.MessageMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.databinding.RidgetUpdateValueStrategy;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;
import org.eclipse.riena.ui.ridgets.validation.ValidatorCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueBindingSupport {
    private final IValidator NO_ERRORS_RULE = new IValidator(){

        public IStatus validate(Object value) {
            boolean isOk = ValueBindingSupport.this.markable.getMarkersOfType(ErrorMarker.class).isEmpty();
            return isOk ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }

        public String toString() {
            return "NO_ERRORS_RULE";
        }
    };
    private final ValidatorCollection afterGetValidators;
    private final ValidatorCollection onEditValidators;
    private Map<IValidator, Set<ValidationMessageMarker>> rule2messages;
    private Map<IValidator, IStatus> rule2status;
    private Map<IValidator, ErrorMessageMarker> rule2error;
    private DataBindingContext context;
    private IObservableValue targetOV;
    private IObservableValue modelOV;
    private Binding modelBinding;
    private IConverter uiControlToModelConverter;
    private IConverter modelToUIControlConverter;
    private IMarkable markable;

    public ValueBindingSupport(IObservableValue target) {
        this.bindToTarget(target);
        this.afterGetValidators = new ValidatorCollection();
        this.onEditValidators = new ValidatorCollection();
    }

    public ValueBindingSupport(IObservableValue target, IObservableValue model) {
        this(target);
        this.bindToModel(model);
    }

    public IConverter getUIControlToModelConverter() {
        return this.uiControlToModelConverter;
    }

    public void setUIControlToModelConverter(IConverter uiControlToModelConverter) {
        this.uiControlToModelConverter = uiControlToModelConverter;
    }

    public IConverter getModelToUIControlConverter() {
        return this.modelToUIControlConverter;
    }

    public void setModelToUIControlConverter(IConverter modelToUIControlConverter) {
        this.modelToUIControlConverter = modelToUIControlConverter;
    }

    public Collection<IValidator> getValidationRules() {
        ArrayList<IValidator> allValidationRules = new ArrayList<IValidator>(this.onEditValidators.getValidators());
        allValidationRules.addAll(this.afterGetValidators.getValidators());
        return allValidationRules;
    }

    public ValidatorCollection getAllValidators() {
        ValidatorCollection result = new ValidatorCollection();
        for (IValidator validationRule : this.onEditValidators) {
            result.add(validationRule);
        }
        for (IValidator validationRule : this.afterGetValidators) {
            result.add(validationRule);
        }
        return result;
    }

    public ValidatorCollection getOnEditValidators() {
        return this.onEditValidators;
    }

    public ValidatorCollection getAfterGetValidators() {
        return this.afterGetValidators;
    }

    public boolean addValidationRule(IValidator validationRule, ValidationTime validationTime) {
        Assert.isNotNull((Object)validationRule);
        if (validationTime == ValidationTime.ON_UI_CONTROL_EDIT) {
            this.onEditValidators.add(validationRule);
            return true;
        }
        if (validationTime == ValidationTime.ON_UPDATE_TO_MODEL) {
            this.afterGetValidators.add(validationRule);
            return false;
        }
        throw new UnsupportedOperationException();
    }

    public boolean removeValidationRule(IValidator validationRule) {
        if (validationRule == null) {
            return false;
        }
        this.removeErrorMarker(validationRule);
        this.removeMessages(validationRule);
        this.clearStatus(validationRule);
        this.afterGetValidators.remove(validationRule);
        if (this.onEditValidators.contains(validationRule)) {
            this.onEditValidators.remove(validationRule);
            return true;
        }
        return false;
    }

    public void bindToTarget(IObservableValue observableValue) {
        this.targetOV = observableValue;
        this.rebindToModel();
    }

    public void bindToModel(IObservableValue observableValue) {
        this.modelOV = observableValue;
        this.rebindToModel();
    }

    public void bindToModel(Object valueHolder, String valuePropertyName) {
        this.modelOV = PojoObservables.observeValue((Object)valueHolder, (String)valuePropertyName);
        this.rebindToModel();
    }

    public void rebindToModel() {
        if (this.modelOV == null || this.targetOV == null) {
            return;
        }
        RidgetUpdateValueStrategy uiControlToModelStrategy = new RidgetUpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        RidgetUpdateValueStrategy modelToUIControlStrategy = new RidgetUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        uiControlToModelStrategy.setAfterGetValidator(this.afterGetValidators);
        if (this.uiControlToModelConverter != null && this.targetOV.getValueType() == this.uiControlToModelConverter.getFromType() && this.modelOV.getValueType() == this.uiControlToModelConverter.getToType()) {
            uiControlToModelStrategy.setConverter(this.uiControlToModelConverter);
        }
        if (this.modelToUIControlConverter != null && this.targetOV.getValueType() == this.modelToUIControlConverter.getToType() && this.modelOV.getValueType() == this.modelToUIControlConverter.getFromType()) {
            modelToUIControlStrategy.setConverter(this.modelToUIControlConverter);
        }
        if (this.modelBinding != null) {
            this.modelBinding.dispose();
            this.getContext().removeBinding(this.modelBinding);
        }
        this.modelBinding = this.getContext().bindValue(this.targetOV, this.modelOV, (UpdateValueStrategy)uiControlToModelStrategy, (UpdateValueStrategy)modelToUIControlStrategy);
        AggregateValidationStatus validationStatus = new AggregateValidationStatus((IObservableCollection)this.getContext().getBindings(), 2);
        validationStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                IStatus newStatus = (IStatus)((ComputedValue)event.getSource()).getValue();
                this.updateValidationMessages(newStatus);
            }

            private void updateValidationMessages(IStatus newStatus) {
                if (ValueBindingSupport.this.targetOV != null) {
                    Object value = ValueBindingSupport.this.targetOV.getValue();
                    ValueBindingSupport.this.updateValidationStatus(ValueBindingSupport.this.NO_ERRORS_RULE, newStatus);
                    for (IValidator rule : ValueBindingSupport.this.getAfterGetValidators()) {
                        ValueBindingSupport.this.updateValidationStatus(rule, rule.validate(value));
                    }
                }
            }
        });
    }

    public IObservableValue getModelObservable() {
        return this.modelOV;
    }

    public Binding getModelBinding() {
        return this.modelBinding;
    }

    public void setMarkable(IMarkable markable) {
        this.markable = markable;
    }

    public void updateFromModel() {
        if (this.modelBinding != null) {
            this.modelBinding.updateModelToTarget();
        }
    }

    public void updateFromTarget() {
        if (this.modelBinding != null) {
            this.modelBinding.updateTargetToModel();
        }
    }

    public DataBindingContext getContext() {
        if (this.context == null) {
            this.context = new DataBindingContext();
        }
        return this.context;
    }

    public void addValidationMessage(String message) {
        this.addValidationMessage(message, this.NO_ERRORS_RULE);
    }

    public void addValidationMessage(IMessageMarker messageMarker) {
        this.addValidationMessage(messageMarker, this.NO_ERRORS_RULE);
    }

    public void addValidationMessage(String message, IValidator validationRule) {
        this.addValidationMessage((IMessageMarker)new MessageMarker(message), validationRule);
    }

    public void addValidationMessage(IMessageMarker messageMarker, IValidator validationRule) {
        Set<ValidationMessageMarker> messages;
        Assert.isNotNull((Object)messageMarker, (String)"messageMarker cannot be null");
        Assert.isNotNull((Object)validationRule, (String)"validationRule cannot be null");
        ValidationMessageMarker validationMessageMarker = new ValidationMessageMarker(messageMarker, validationRule);
        if (this.rule2messages == null) {
            this.rule2messages = new HashMap<IValidator, Set<ValidationMessageMarker>>();
        }
        if ((messages = this.rule2messages.get(validationRule)) == null) {
            messages = new HashSet<ValidationMessageMarker>();
            this.rule2messages.put(validationRule, messages);
        }
        messages.add(validationMessageMarker);
        this.updateValidationMessageMarker(validationRule);
    }

    public void removeValidationMessage(String message) {
        this.removeValidationMessage(message, this.NO_ERRORS_RULE);
    }

    public void removeValidationMessage(IMessageMarker messageMarker) {
        this.removeValidationMessage(messageMarker, this.NO_ERRORS_RULE);
    }

    public void removeValidationMessage(String message, IValidator validationRule) {
        this.removeValidationMessage((IMessageMarker)new MessageMarker(message), validationRule);
    }

    public void removeValidationMessage(IMessageMarker messageMarker, IValidator validationRule) {
        ValidationMessageMarker validationMessageMarker = new ValidationMessageMarker(messageMarker, validationRule);
        if (this.rule2messages != null) {
            Set<ValidationMessageMarker> messages = this.rule2messages.get(validationRule);
            messages.remove((Object)validationMessageMarker);
            this.markable.removeMarker((IMarker)validationMessageMarker);
            if (messages.isEmpty()) {
                this.rule2messages.remove(validationRule);
            }
        }
    }

    public void updateValidationStatus(IStatus status) {
        this.updateValidationStatus(this.NO_ERRORS_RULE, status);
    }

    public void updateValidationStatus(IValidator validationRule, IStatus status) {
        this.storeStatus(validationRule, status);
        if (!status.isOK()) {
            this.addErrorMarker(validationRule, status);
            this.addMessages(validationRule);
        } else {
            this.removeErrorMarker(validationRule);
            this.removeMessages(validationRule);
        }
    }

    private void addErrorMarker(IValidator validationRule, IStatus status) {
        ErrorMessageMarker errorMarker;
        if (status.getCode() == 1024 || validationRule == this.NO_ERRORS_RULE) {
            return;
        }
        if (this.rule2error == null) {
            this.rule2error = new HashMap<IValidator, ErrorMessageMarker>();
        }
        if ((errorMarker = this.rule2error.get(validationRule)) == null) {
            errorMarker = new ErrorMessageMarker(status.getMessage());
            this.rule2error.put(validationRule, errorMarker);
        } else {
            errorMarker.setMessage(status.getMessage());
        }
        this.markable.addMarker((IMarker)errorMarker);
    }

    private void addMessages(IValidator validationRule) {
        if (this.rule2messages != null && this.rule2messages.containsKey(validationRule)) {
            Set<ValidationMessageMarker> messages = this.rule2messages.get(validationRule);
            for (ValidationMessageMarker message : messages) {
                this.markable.addMarker((IMarker)message);
            }
        }
    }

    private void clearStatus(IValidator validationRule) {
        if (this.rule2status != null) {
            this.rule2status.remove(validationRule);
        }
    }

    private IStatus getStatus(IValidator validationRule) {
        return this.rule2status != null ? this.rule2status.get(validationRule) : null;
    }

    private void storeStatus(IValidator validationRule, IStatus status) {
        if (this.rule2status == null) {
            this.rule2status = new HashMap<IValidator, IStatus>();
        }
        this.rule2status.put(validationRule, status);
    }

    private void removeErrorMarker(IValidator validationRule) {
        ErrorMessageMarker errorMarker;
        if (this.rule2error != null && (errorMarker = this.rule2error.remove(validationRule)) != null) {
            this.markable.removeMarker((IMarker)errorMarker);
        }
    }

    private void removeMessages(IValidator validationRule) {
        if (this.rule2messages != null && this.rule2messages.containsKey(validationRule)) {
            Set<ValidationMessageMarker> messages = this.rule2messages.get(validationRule);
            for (ValidationMessageMarker message : messages) {
                this.markable.removeMarker((IMarker)message);
            }
        }
    }

    private void updateValidationMessageMarker(IValidator validationRule) {
        IStatus status = this.getStatus(validationRule);
        if (status != null) {
            this.updateValidationStatus(validationRule, status);
        }
    }
}

