/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConverterFactory<K, L> {
    private final Class<K> fromType;
    private final Class<L> toType;
    private final Map<K, L> modelToUI;

    public ConverterFactory(Class<K> fromType, Class<L> toType) {
        Assert.isLegal((fromType != toType ? 1 : 0) != 0);
        this.fromType = fromType;
        this.toType = toType;
        this.modelToUI = new HashMap<K, L>();
    }

    public ConverterFactory<K, L> add(K fromValue, L toValue) {
        this.modelToUI.put(fromValue, toValue);
        return this;
    }

    public IConverter createFromToConverter() {
        return new Converter(this.fromType, this.toType){

            public Object convert(Object fromObject) {
                return ConverterFactory.this.modelToUI.get(fromObject);
            }
        };
    }

    public IConverter createToFromConverter() {
        return new Converter(this.toType, this.fromType){

            public Object convert(Object fromObject) {
                Object result = null;
                Iterator iter = ConverterFactory.this.modelToUI.entrySet().iterator();
                while (result == null && iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (!entry.getValue().equals(fromObject)) continue;
                    result = entry.getKey();
                }
                return result;
            }
        };
    }
}

