/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.uibinding.ICorrespondingLabelConfigExtension;
import org.eclipse.riena.ui.ridgets.uibinding.ILabelFinderStrategy;
import org.eclipse.riena.ui.ridgets.uibinding.ILabelFinderStrategyExtension;

public class CorrespondingLabelMapper {
    private String labelPrefix = "label";
    private IRidgetContainer ridgetContainer;
    private ILabelFinderStrategy labelFinderStrategy;

    public CorrespondingLabelMapper(IRidgetContainer ridgetContainer) {
        this.ridgetContainer = ridgetContainer;
        this.labelFinderStrategy = new DefaultLabelFinderStrategy();
    }

    @InjectExtension(id="org.eclipse.riena.ui.ridgets.correspondinglabel.config", min=0, max=1)
    public void setCorrespondingLabelConfig(ICorrespondingLabelConfigExtension labelProperties) {
        if (labelProperties != null && labelProperties.getLabelPrefix() != null) {
            this.labelPrefix = labelProperties.getLabelPrefix();
        }
    }

    @InjectExtension(id="org.eclipse.riena.ui.ridgets.labelfinderstrategy", min=0, max=1)
    public void setLabelFinderStrategy(ILabelFinderStrategyExtension strategyProperties) {
        ILabelFinderStrategy customLabelFinderStrategy;
        if (strategyProperties != null && StringUtils.isGiven((CharSequence)strategyProperties.getClassName()) && (customLabelFinderStrategy = strategyProperties.createFinderStrategy()) != null) {
            this.labelFinderStrategy = customLabelFinderStrategy;
        }
    }

    public boolean connectCorrespondingLabel(final IRidget ridget, String ridgetId) {
        final ILabelRidget labelRidget = this.labelFinderStrategy.findLabelRidget(this.ridgetContainer, ridgetId);
        if (labelRidget == null) {
            return false;
        }
        ridget.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    labelRidget.setEnabled(ridget.isEnabled());
                }
            }
        });
        return true;
    }

    private class DefaultLabelFinderStrategy
    implements ILabelFinderStrategy {
        private DefaultLabelFinderStrategy() {
        }

        public ILabelRidget findLabelRidget(IRidgetContainer iridgetContainer, String ridgetID) {
            String labelID = String.valueOf(CorrespondingLabelMapper.this.labelPrefix) + ridgetID;
            IRidget labelRidget = iridgetContainer.getRidget(labelID);
            if (labelRidget != null && labelRidget instanceof ILabelRidget) {
                return (ILabelRidget)labelRidget;
            }
            return null;
        }
    }
}

