/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;
import org.eclipse.riena.ui.ridgets.listener.IWindowRidgetListener;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class ShellRidget
extends AbstractSWTWidgetRidget
implements IWindowRidget {
    private static Image missingImage;
    private boolean closeable = true;
    private boolean titleAlreadyInitialized = false;
    private String title = "";
    private String icon;
    private ListenerList<IWindowRidgetListener> windowRidgetListeners = new ListenerList(IWindowRidgetListener.class);
    private ShellListener shellListener = new RidgetShellListener();

    public ShellRidget() {
    }

    public ShellRidget(Shell shell) {
        this();
        this.setUIControl(shell);
    }

    public Shell getUIControl() {
        return (Shell)super.getUIControl();
    }

    protected void checkUIControl(Object uiControl) {
        if (uiControl != null && !(uiControl instanceof Shell)) {
            throw new UIBindingFailure("uiControl of a ShellRidget must be a Shell but was a " + uiControl.getClass().getSimpleName());
        }
    }

    protected void unbindUIControl() {
        this.savedVisibleState = this.isVisible();
        this.removeShellListener();
    }

    protected void bindUIControl() {
        this.addShellListener();
        this.updateToolTip();
        this.updateCloseable();
        this.updateTitle();
        this.updateIcon();
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    private void addShellListener() {
        if (this.getUIControl() != null) {
            this.getUIControl().addShellListener(this.shellListener);
        }
    }

    private void removeShellListener() {
        if (this.getUIControl() != null) {
            this.getUIControl().removeShellListener(this.shellListener);
        }
    }

    public void addWindowRidgetListener(IWindowRidgetListener listener) {
        this.windowRidgetListeners.add((Object)listener);
    }

    public void removeWindowRidgetListener(IWindowRidgetListener listener) {
        this.windowRidgetListeners.remove((Object)listener);
    }

    public void dispose() {
        this.getUIControl().dispose();
    }

    public void setTitle(String title) {
        this.titleAlreadyInitialized = true;
        if (title != null && !this.title.equals(title)) {
            this.title = title;
            this.updateTitle();
        }
    }

    private void updateTitle() {
        if (this.getUIControl() != null) {
            if (this.titleAlreadyInitialized) {
                this.getUIControl().setText(this.title);
            } else {
                this.titleAlreadyInitialized = true;
                this.title = this.getUIControl().getText();
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setIcon(String icon) {
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon)) {
            this.updateIcon();
        }
    }

    private void updateIcon() {
        Shell control = this.getUIControl();
        if (control != null) {
            Image image = null;
            if (this.icon != null) {
                image = this.getManagedImage(this.icon);
            }
            control.setImage(image);
        }
    }

    protected Image getManagedImage(String key) {
        Image image = ImageStore.getInstance().getImage(key);
        if (image == null) {
            image = this.getMissingImage();
        }
        return image;
    }

    public final synchronized Image getMissingImage() {
        if (missingImage == null) {
            missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return missingImage;
    }

    protected boolean hasChanged(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return !oldValue.equals(newValue);
    }

    public void setDefaultButton(Object defaultButton) {
        if (defaultButton instanceof Button) {
            this.getUIControl().setDefaultButton((Button)defaultButton);
        }
    }

    public Object getDefaultButton() {
        return this.getUIControl().getDefaultButton();
    }

    public void requestFocus() {
        if (this.getUIControl() != null) {
            this.getUIControl().setFocus();
        }
    }

    public boolean hasFocus() {
        if (this.getUIControl() != null) {
            return this.getUIControl().isFocusControl();
        }
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public void setFocusable(boolean focusable) {
    }

    protected void updateEnabled() {
        if (this.getUIControl() != null) {
            this.getUIControl().setEnabled(this.isEnabled());
        }
    }

    protected void updateToolTip() {
        if (this.getUIControl() != null) {
            this.getUIControl().setToolTipText(this.getToolTipText());
        }
    }

    public void setActive(boolean active) {
        this.setEnabled(active);
    }

    public void setCloseable(boolean closeable) {
        if (this.closeable != closeable) {
            this.closeable = closeable;
            this.updateCloseable();
        }
    }

    private void updateCloseable() {
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.getUIControl() != null) {
            this.updateTitle();
            this.updateIcon();
        }
    }

    public String getID() {
        if (this.getUIControl() != null) {
            SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
            return locator.locateBindingProperty((Object)this.getUIControl());
        }
        return null;
    }

    public boolean isDisableMandatoryMarker() {
        return false;
    }

    public boolean isVisible() {
        if (!this.getMarkersOfType(HiddenMarker.class).isEmpty()) {
            return false;
        }
        if (this.getUIControl() != null) {
            return this.getUIControl().isVisible();
        }
        return this.savedVisibleState;
    }

    private class RidgetShellListener
    implements ShellListener {
        private RidgetShellListener() {
        }

        public void shellActivated(ShellEvent e) {
            IWindowRidgetListener[] iWindowRidgetListenerArray = (IWindowRidgetListener[])ShellRidget.this.windowRidgetListeners.getListeners();
            int n = iWindowRidgetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWindowRidgetListener l = iWindowRidgetListenerArray[n2];
                l.activated();
                ++n2;
            }
        }

        public void shellClosed(ShellEvent e) {
            IWindowRidgetListener[] iWindowRidgetListenerArray = (IWindowRidgetListener[])ShellRidget.this.windowRidgetListeners.getListeners();
            int n = iWindowRidgetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWindowRidgetListener l = iWindowRidgetListenerArray[n2];
                l.closed();
                ++n2;
            }
        }

        public void shellDeactivated(ShellEvent e) {
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }
    }
}

