/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeRidgetLabelProvider
extends TableRidgetLabelProvider
implements IColorProvider {
    private static final UpdateIconsTreeListener LISTENER = new UpdateIconsTreeListener();
    private final TreeViewer viewer;
    private final IObservableMap enablementAttribute;
    private final IObservableMap imageAttribute;

    public static TreeRidgetLabelProvider createLabelProvider(TreeViewer viewer, Class<?> treeElementClass, IObservableSet knownElements, String[] valueAccessors, String enablementAccessor, String imageAccessor, IColumnFormatter[] formatters) {
        IObservableMap[] map = TreeRidgetLabelProvider.createAttributeMap(treeElementClass, knownElements, valueAccessors, enablementAccessor, imageAccessor);
        int numColumns = valueAccessors.length;
        return new TreeRidgetLabelProvider(viewer, map, enablementAccessor, imageAccessor, formatters, numColumns);
    }

    private static IObservableMap[] createAttributeMap(Class<?> treeElementClass, IObservableSet knownElements, String[] valueAccessors, String enablementAccessor, String imageAccessor) {
        String[] attributes = TreeRidgetLabelProvider.computeAttributes(valueAccessors, enablementAccessor, imageAccessor);
        IObservableMap[] result = AbstractSWTWidgetRidget.isBean(treeElementClass) ? BeansObservables.observeMaps((IObservableSet)knownElements, treeElementClass, (String[])attributes) : PojoObservables.observeMaps((IObservableSet)knownElements, treeElementClass, (String[])attributes);
        return result;
    }

    private static String[] computeAttributes(String[] valueAccessors, String enablementAccessor, String imageAccessor) {
        int length = valueAccessors.length;
        if (enablementAccessor != null) {
            ++length;
        }
        if (imageAccessor != null) {
            ++length;
        }
        String[] attributes = new String[Math.max(length, valueAccessors.length)];
        System.arraycopy(valueAccessors, 0, attributes, 0, valueAccessors.length);
        if (length > valueAccessors.length) {
            int index = valueAccessors.length;
            if (enablementAccessor != null) {
                attributes[index++] = enablementAccessor;
            }
            if (imageAccessor != null) {
                attributes[index++] = imageAccessor;
            }
        }
        return attributes;
    }

    private TreeRidgetLabelProvider(TreeViewer viewer, IObservableMap[] attributeMap, String enablementAccessor, String imageAccessor, IColumnFormatter[] formatters, int numColumns) {
        super(attributeMap, formatters, numColumns);
        viewer.getTree().removeTreeListener((TreeListener)LISTENER);
        viewer.getTree().addTreeListener((TreeListener)LISTENER);
        this.enablementAttribute = this.findAttribute(attributeMap, enablementAccessor);
        this.imageAttribute = this.findAttribute(attributeMap, imageAccessor);
        this.viewer = viewer;
    }

    @Override
    public Image getImage(Object element) {
        String key = this.getImageKey(element);
        return Activator.getSharedImage(key);
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        Image result = null;
        if (columnIndex == 0) {
            IColumnFormatter formatter = this.getFormatter(columnIndex);
            if (formatter != null) {
                result = (Image)formatter.getImage(element);
            }
            if (result == null) {
                result = this.getImage(element);
            }
        } else {
            result = super.getColumnImage(element, columnIndex);
        }
        return result;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Object value;
        Color result = null;
        if (this.enablementAttribute != null && Boolean.FALSE.equals(value = this.enablementAttribute.get(element))) {
            result = this.viewer.getControl().getDisplay().getSystemColor(15);
        }
        return result;
    }

    private IObservableMap findAttribute(IObservableMap[] attributeMap, String accessor) {
        IObservableMap result = null;
        if (accessor != null) {
            int i = attributeMap.length - 1;
            while (result == null && i > -1) {
                String property;
                IObservableMap attribute = attributeMap[i];
                IBeanObservable beanObservable = (IBeanObservable)attribute;
                PropertyDescriptor pd = beanObservable.getPropertyDescriptor();
                String string = property = pd != null ? pd.getName() : null;
                if (accessor.equals(property)) {
                    result = attribute;
                }
                --i;
            }
        }
        return result;
    }

    private String getImageKey(Object element) {
        String key;
        Object value;
        block5: {
            try {
                if (!this.viewer.isExpandable(element)) break block5;
                boolean isExpanded = this.viewer.getExpandedState(element);
                if (isExpanded) {
                    return "IMG_NODE_EXPANDED";
                }
                return "IMG_NODE_COLLAPSED";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "IMG_LEAF";
            }
        }
        if (this.imageAttribute != null && (value = this.imageAttribute.get(element)) != null && Activator.getSharedImage(key = (String)value) != null) {
            return key;
        }
        return "IMG_LEAF";
    }

    private static final class UpdateIconsTreeListener
    implements TreeListener {
        private UpdateIconsTreeListener() {
        }

        public void treeCollapsed(TreeEvent e) {
            this.updateIcon((TreeItem)e.item, false);
        }

        public void treeExpanded(TreeEvent e) {
            this.updateIcon((TreeItem)e.item, true);
        }

        private void updateIcon(TreeItem item, boolean isExpanded) {
            String key = isExpanded ? "IMG_NODE_EXPANDED" : "IMG_NODE_COLLAPSED";
            Image image = Activator.getSharedImage(key);
            item.setImage(image);
        }
    }
}

