/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.swt.AbstractMasterDetailsComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMasterDetailsRidget
extends AbstractCompositeRidget
implements IMasterDetailsRidget {
    private IObservableList rowObservables;
    private IMasterDetailsDelegate delegate;
    private DataBindingContext dbc;
    private boolean isDirectWriting;
    private Object editable;
    private IRidgetContainer detailRidgets;

    public AbstractMasterDetailsRidget() {
        this.addPropertyChangeListener(null, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (AbstractMasterDetailsRidget.this.delegate == null || AbstractMasterDetailsRidget.this.editable == null || "marker".equals(evt.getPropertyName()) || "enabled".equals(evt.getPropertyName()) || "output".equals(evt.getPropertyName())) {
                    return;
                }
                boolean isChanged = AbstractMasterDetailsRidget.this.areDetailsChanged();
                AbstractMasterDetailsRidget.this.getApplyButtonRidget().setEnabled(isChanged);
            }
        });
    }

    public final void bindToModel(IObservableList rowObservables, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        this.rowObservables = rowObservables;
        this.bindTableToModel(rowObservables, rowClass, columnPropertyNames, columnHeaders);
    }

    public final void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] headerNames) {
        IObservableList rowObservableList = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowObservableList, rowClass, columnPropertyNames, headerNames);
    }

    public void configureRidgets() {
        this.configureTableRidget();
        if (this.hasNewButton()) {
            this.getNewButtonRidget().addListener(new IActionListener(){

                public void callback() {
                    if (AbstractMasterDetailsRidget.this.canAdd()) {
                        AbstractMasterDetailsRidget.this.handleAdd();
                    }
                }
            });
        }
        if (this.hasRemoveButton()) {
            this.getRemoveButtonRidget().addListener(new IActionListener(){

                public void callback() {
                    AbstractMasterDetailsRidget.this.handleRemove();
                }
            });
        }
        this.getApplyButtonRidget().addListener(new IActionListener(){

            public void callback() {
                if (AbstractMasterDetailsRidget.this.canApply()) {
                    AbstractMasterDetailsRidget.this.handleApply();
                }
            }
        });
        this.detailRidgets = new DetailRidgetContainer();
        this.setEnabled(false, false);
        final IObservableValue viewerSelection = this.getSelectionObservable();
        Assert.isLegal((this.dbc == null ? 1 : 0) != 0);
        if (this.hasRemoveButton()) {
            this.dbc = new DataBindingContext();
            this.bindEnablementToValue(this.dbc, (IRidget)this.getRemoveButtonRidget(), (IObservableValue)new ComputedValue(Boolean.TYPE){

                protected Object calculate() {
                    return viewerSelection.getValue() != null;
                }
            });
        }
        for (IRidget ridget : this.detailRidgets.getRidgets()) {
            ridget.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (!AbstractMasterDetailsRidget.this.isDirectWriting || AbstractMasterDetailsRidget.this.delegate == null || AbstractMasterDetailsRidget.this.editable == null || "marker".equals(evt.getPropertyName()) || "enabled".equals(evt.getPropertyName()) || "output".equals(evt.getPropertyName())) {
                        return;
                    }
                    AbstractMasterDetailsRidget.this.delegate.copyBean(AbstractMasterDetailsRidget.this.delegate.getWorkingCopy(), AbstractMasterDetailsRidget.this.editable);
                    AbstractMasterDetailsRidget.this.getTableRidget().updateFromModel();
                    AbstractMasterDetailsRidget.this.setTableSelection(AbstractMasterDetailsRidget.this.editable);
                }
            });
        }
    }

    public final IMasterDetailsDelegate getDelegate() {
        return this.delegate;
    }

    public final Object getSelection() {
        return this.getSelectionObservable().getValue();
    }

    public AbstractMasterDetailsComposite getUIControl() {
        return (AbstractMasterDetailsComposite)super.getUIControl();
    }

    public boolean isDirectWriting() {
        return this.isDirectWriting;
    }

    public final void setDelegate(IMasterDetailsDelegate delegate) {
        Assert.isLegal((this.delegate == null ? 1 : 0) != 0, (String)"setDelegate can only be called once");
        Assert.isLegal((delegate != null ? 1 : 0) != 0, (String)"delegate cannot be null");
        this.delegate = delegate;
        delegate.configureRidgets(this.detailRidgets);
    }

    public void setDirectWriting(boolean directWriting) {
        if (directWriting != this.isDirectWriting) {
            this.isDirectWriting = directWriting;
            this.getApplyButtonRidget().setVisible(!directWriting);
        }
    }

    public void setSelection(Object newSelection) {
        this.setTableSelection(newSelection);
        this.handleSelectionChange(newSelection);
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            this.revealTableSelection();
        }
    }

    public void updateFromModel() {
        this.checkDelegate();
        super.updateFromModel();
        IRidget tableRidget = this.getTableRidget();
        if (tableRidget != null) {
            tableRidget.updateFromModel();
        }
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, AbstractMasterDetailsComposite.class);
    }

    protected abstract void bindTableToModel(IObservableList var1, Class<? extends Object> var2, String[] var3, String[] var4);

    protected abstract void configureTableRidget();

    protected abstract void clearTableSelection();

    protected abstract Object getTableSelection();

    protected abstract IObservableValue getSelectionObservable();

    protected abstract void revealTableSelection();

    protected abstract void setTableSelection(Object var1);

    protected final boolean areDetailsChanged() {
        return this.editable != null && this.delegate.isChanged(this.editable, this.delegate.getWorkingCopy());
    }

    protected final void handleSelectionChange(Object newSelection) {
        if (newSelection != null) {
            this.editable = newSelection;
            this.setEnabled(false, true);
            this.updateDetails(this.editable);
        } else {
            this.clearSelection();
            this.setEnabled(false, false);
        }
    }

    protected boolean isUIControlVisible() {
        return this.getUIControl().isVisible();
    }

    protected final void updateEnabled() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setEnabled(this.isEnabled());
        }
    }

    protected final void updateToolTipText() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setToolTipText(this.getToolTipText());
        }
    }

    protected final void updateVisible() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setVisible(!this.markedHidden);
        }
    }

    private void assertIsBoundToModel() {
        if (this.rowObservables == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        Assert.isNotNull((Object)ridget);
        Assert.isNotNull((Object)value);
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    private boolean canAdd() {
        boolean result = true;
        boolean isChanged = this.areDetailsChanged();
        if (isChanged) {
            result = this.getUIControl().confirmDiscardChanges();
        }
        return result;
    }

    private boolean canApply() {
        String reason = this.delegate.isValid(this.detailRidgets);
        if (reason != null) {
            this.getUIControl().warnApplyFailed(reason);
        }
        return reason == null;
    }

    private void checkDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("no delegate: call setDelegate(...)");
        }
    }

    private void clearSelection() {
        this.updateDetails(this.delegate.createWorkingCopy());
        this.editable = null;
    }

    private IRidget getTableRidget() {
        return this.getRidget("mdTable");
    }

    private IActionRidget getNewButtonRidget() {
        return (IActionRidget)this.getRidget("mdNewButton");
    }

    private IActionRidget getRemoveButtonRidget() {
        return (IActionRidget)this.getRidget("mdRemoveButton");
    }

    private IActionRidget getApplyButtonRidget() {
        return (IActionRidget)this.getRidget("mdApplyButton");
    }

    private boolean hasNewButton() {
        return this.getNewButtonRidget() != null;
    }

    private boolean hasRemoveButton() {
        return this.getRemoveButtonRidget() != null;
    }

    private void setEnabled(boolean applyEnabled, boolean detailsEnabled) {
        this.getApplyButtonRidget().setEnabled(applyEnabled);
        for (IRidget ridget : this.detailRidgets.getRidgets()) {
            ridget.setEnabled(detailsEnabled);
        }
    }

    private void updateDetails(Object bean) {
        Assert.isNotNull((Object)bean);
        this.delegate.copyBean(bean, this.delegate.getWorkingCopy());
        this.delegate.updateDetails(this.detailRidgets);
    }

    public void handleAdd() {
        if (!this.isDirectWriting) {
            this.editable = this.delegate.createWorkingCopy();
            this.setEnabled(false, true);
            this.updateDetails(this.editable);
            this.clearTableSelection();
            this.getUIControl().getDetails().setFocus();
        } else {
            this.editable = this.delegate.createWorkingCopy();
            this.rowObservables.add(this.editable);
            this.getTableRidget().updateFromModel();
            this.setSelection(this.editable);
            this.setEnabled(false, true);
            this.updateDetails(this.editable);
            this.getUIControl().getDetails().setFocus();
        }
    }

    public void handleRemove() {
        this.assertIsBoundToModel();
        Object selection = this.getSelection();
        Assert.isNotNull((Object)selection);
        this.rowObservables.remove(selection);
        this.clearSelection();
        this.clearTableSelection();
        this.getTableRidget().updateFromModel();
        this.setEnabled(false, false);
    }

    public void handleApply() {
        this.assertIsBoundToModel();
        Assert.isNotNull((Object)this.editable);
        this.delegate.copyBean(this.delegate.getWorkingCopy(), this.editable);
        if (!this.rowObservables.contains(this.editable)) {
            this.rowObservables.add(this.editable);
            this.getTableRidget().updateFromModel();
            this.setSelection(this.editable);
        } else {
            this.getTableRidget().updateFromModel();
        }
        this.setEnabled(false, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DetailRidgetContainer
    implements IRidgetContainer {
        private final List<IRidget> detailRidgets = this.getDetailRidgets();

        public void addRidget(String id, IRidget ridget) {
            throw new UnsupportedOperationException("not supported");
        }

        public void configureRidgets() {
            throw new UnsupportedOperationException("not supported");
        }

        public IRidget getRidget(String id) {
            return AbstractMasterDetailsRidget.this.getRidget(id);
        }

        public Collection<? extends IRidget> getRidgets() {
            return this.detailRidgets;
        }

        private List<IRidget> getDetailRidgets() {
            ArrayList<IRidget> result = new ArrayList<IRidget>(AbstractMasterDetailsRidget.this.getRidgets());
            result.remove(AbstractMasterDetailsRidget.this.getNewButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getRemoveButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getApplyButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getTableRidget());
            return result;
        }
    }
}

