/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import org.eclipse.riena.core.injector.extension.ExtensionInterface;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.navigation.Activator;
import org.eclipse.riena.navigation.INavigationNodeProvider;

public final class NavigationNodeProvider {
    private static final NavigationNodeProvider NAVIGATION_NODE_PROVIDER = new NavigationNodeProvider();
    private INavigationNodeProvider provider;

    static {
        Wire.instance((Object)NAVIGATION_NODE_PROVIDER).andStart(Activator.getDefault().getContext());
    }

    private NavigationNodeProvider() {
    }

    public static INavigationNodeProvider getInstance() {
        return NAVIGATION_NODE_PROVIDER.getProvider();
    }

    private INavigationNodeProvider getProvider() {
        return this.provider;
    }

    @InjectExtension(id="org.eclipse.riena.navigation.navigationNodeProvider")
    public void update(INavigationNodeProviderExtension[] availableExtensions) {
        if (this.provider != null) {
            this.provider.cleanUp();
        }
        INavigationNodeProviderExtension found = null;
        int maxPriority = Integer.MIN_VALUE;
        this.provider = null;
        INavigationNodeProviderExtension[] iNavigationNodeProviderExtensionArray = availableExtensions;
        int n = availableExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            INavigationNodeProviderExtension probe = iNavigationNodeProviderExtensionArray[n2];
            int p = probe.getPriority();
            if (found == null || p > maxPriority) {
                found = probe;
                maxPriority = p;
            }
            ++n2;
        }
        if (found != null) {
            this.provider = found.createClass();
        }
    }

    @ExtensionInterface
    public static interface INavigationNodeProviderExtension {
        public static final String EXTENSION_POINT_ID = "org.eclipse.riena.navigation.navigationNodeProvider";

        public String getId();

        public int getPriority();

        public INavigationNodeProvider createClass();
    }
}

