/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.splashHandlers;

import org.eclipse.equinox.app.IApplication;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.navigation.ui.swt.login.ILoginSplashView;
import org.eclipse.riena.navigation.ui.swt.login.ILoginSplashViewDefinition;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.splash.AbstractSplashHandler;

public abstract class AbstractLoginSplashHandler
extends AbstractSplashHandler {
    protected ILoginSplashViewDefinition loginSplashViewDefinition;
    private Composite loginComposite;
    private ILoginSplashView loginView;

    public AbstractLoginSplashHandler() {
        this.initialzeLoginSplashViewDefinition();
    }

    public void init(Shell splash) {
        super.init(splash);
        if (this.loginSplashViewDefinition != null) {
            this.configureUISplash();
            this.createUI();
            splash.layout(true);
            if (splash.isVisible()) {
                this.doEventLoop();
            }
        }
    }

    public int getResult() {
        return this.loginView.getResult();
    }

    private void doEventLoop() {
        Shell splash = this.getSplash();
        while (!splash.isDisposed()) {
            if (splash.getDisplay().readAndDispatch()) continue;
            splash.getDisplay().sleep();
        }
        if (!IApplication.EXIT_OK.equals(this.loginView.getResult())) {
            PlatformUI.getWorkbench().getDisplay().close();
            System.exit(0);
        }
    }

    private void createUI() {
        this.loginComposite = new Composite((Composite)this.getSplash(), 2048);
        GridLayout layout = new GridLayout(1, false);
        this.loginComposite.setLayout((Layout)layout);
        this.loginComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.loginComposite.setBackgroundMode(1);
        this.loginView = this.loginSplashViewDefinition.createViewClass();
        this.loginView.build(this.loginComposite);
    }

    protected void configureUISplash() {
        GridLayout layout = new GridLayout(1, false);
        this.getSplash().setLayout((Layout)layout);
        this.getSplash().setBackgroundMode(1);
    }

    public void dispose() {
        if (!this.getSplash().isDisposed()) {
            this.getSplash().close();
        }
        super.init(null);
        this.loginComposite = null;
        this.loginView = null;
    }

    public void update(ILoginSplashViewDefinition[] data) {
        if (data.length > 0) {
            this.loginSplashViewDefinition = data[0];
        }
    }

    private void initialzeLoginSplashViewDefinition() {
        Inject.extension((String)"org.eclipse.riena.navigation.ui.swt.loginSplashViewDefinition").useType(ILoginSplashViewDefinition.class).into((Object)this).andStart(Activator.getDefault().getContext());
    }
}

