/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.IModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.IViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.NodeIdentificationSupport;
import org.eclipse.riena.navigation.ui.swt.views.ScrollingSupport;
import org.eclipse.riena.navigation.ui.swt.views.desc.IModuleDesc;
import org.eclipse.riena.navigation.ui.swt.views.desc.IModuleGroupDesc;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class NavigationViewPart
extends ViewPart
implements IModuleNavigationComponentProvider {
    public static final String ID = "org.eclipse.riena.navigation.ui.swt.views.navigationViewPart";
    private IViewFactory viewFactory;
    private Composite parent;
    private ResizeListener resizeListener;
    private Composite scrolledComposite;
    private ScrollingSupport scrollingSupport;
    private List<ModuleGroupView> moduleGroupViews = new ArrayList<ModuleGroupView>();
    private Composite navigationMainComposite;
    private NavigationTreeObserver navigationTreeObserver;
    private Map<INavigationNode<?>, ModuleGroupView> moduleGroupNodesToViews;
    private Map<INavigationNode<?>, ModuleView> moduleNodesToViews;

    public NavigationViewPart() {
        this.markAsNavigation();
        this.moduleGroupNodesToViews = new HashMap();
        this.moduleNodesToViews = new HashMap();
    }

    protected IViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new NavigationViewFactory();
            Inject.extension((String)"org.eclipse.riena.navigation.ui.swt.moduleView").expectingMinMax(0, 1).useType(IModuleDesc.class).into((Object)this.viewFactory).andStart(Activator.getDefault().getContext());
            Inject.extension((String)"org.eclipse.riena.navigation.ui.swt.moduleGroupView").expectingMinMax(0, 1).useType(IModuleGroupDesc.class).into((Object)this.viewFactory).andStart(Activator.getDefault().getContext());
        }
        return this.viewFactory;
    }

    private void markAsNavigation() {
        this.setPartProperty("navigation", String.valueOf(Boolean.TRUE));
    }

    public ISubApplicationNode getSubApplicationNode() {
        String perspectiveID = this.getViewSite().getPage().getPerspective().getId();
        return SwtViewProvider.getInstance().getNavigationNode(perspectiveID, ISubApplicationNode.class);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.initLayoutParts();
        this.buildNavigationViewHierarchy();
        this.initModelObserver();
    }

    private void initLayoutParts() {
        this.parent.setLayout((Layout)new FormLayout());
        this.parent.setBackground(LnfManager.getLnf().getColor("Navigation.background"));
        this.resizeListener = new ResizeListener();
        this.parent.addControlListener((ControlListener)this.resizeListener);
        this.navigationMainComposite = new Composite(this.parent, 0x20000000);
        this.navigationMainComposite.setLayout((Layout)new FormLayout());
        this.navigationMainComposite.setBackground(LnfManager.getLnf().getColor("Navigation.background"));
        this.scrolledComposite = new Composite(this.navigationMainComposite, 0x20000000);
        this.scrolledComposite.setBackground(LnfManager.getLnf().getColor("Navigation.background"));
        this.scrolledComposite.setLayout((Layout)new FormLayout());
        WidgetIdentificationSupport.setIdentification((Widget)this.scrolledComposite, (String[])new String[]{"NavigationView"});
        this.scrollingSupport = new ScrollingSupport(this.parent, 0, this);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, -15);
        this.navigationMainComposite.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.navigationMainComposite, 0);
        this.scrollingSupport.getScrollComposite().setLayoutData((Object)formData);
    }

    public void dispose() {
        super.dispose();
        if (this.parent != null && !this.parent.isDisposed() && this.resizeListener != null) {
            this.parent.removeControlListener((ControlListener)this.resizeListener);
        }
    }

    private void buildNavigationViewHierarchy() {
        ISubApplicationNode subApplicationNode = this.getSubApplicationNode();
        for (IModuleGroupNode moduleGroupNode : subApplicationNode.getChildren()) {
            this.createModuleGroupView(moduleGroupNode);
        }
        this.updateNavigationSize();
    }

    private void initModelObserver() {
        this.navigationTreeObserver = new NavigationTreeObserver();
        this.navigationTreeObserver.addListener((ISubApplicationNodeListener)new SubApplicationListener());
        this.navigationTreeObserver.addListener((IModuleGroupNodeListener)new ModuleGroupListener());
        this.navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        this.navigationTreeObserver.addListenerTo(this.getSubApplicationNode());
    }

    public ModuleGroupView getModuleGroupViewForNode(IModuleGroupNode source) {
        return this.moduleGroupNodesToViews.get(source);
    }

    public ModuleView getModuleViewForNode(IModuleNode source) {
        return this.moduleNodesToViews.get(source);
    }

    private void createModuleGroupView(IModuleGroupNode moduleGroupNode) {
        ModuleGroupView moduleGroupView = this.getViewFactory().createModuleGroupView(this.scrolledComposite);
        NodeIdentificationSupport.setIdentification((Widget)moduleGroupView, "moduleGroupView", (INavigationNode)moduleGroupNode);
        this.moduleGroupNodesToViews.put((INavigationNode<?>)moduleGroupNode, moduleGroupView);
        moduleGroupView.addUpdateListener(new ModuleGroupViewObserver());
        this.registerModuleGroupView(moduleGroupView);
        this.getViewFactory().createModuleGroupController(moduleGroupNode);
        moduleGroupView.bind((ModuleGroupNode)moduleGroupNode);
        moduleGroupView.setLayout((Layout)new FormLayout());
        Composite moduleGroupBody = new Composite((Composite)moduleGroupView, 0);
        FormData formData = new FormData();
        int padding = this.getModuleGroupPadding();
        formData.top = new FormAttachment(0, padding);
        formData.left = new FormAttachment(0, padding);
        formData.bottom = new FormAttachment(100, -padding);
        formData.right = new FormAttachment(100, -padding);
        moduleGroupBody.setLayoutData((Object)formData);
        for (IModuleNode moduleNode : moduleGroupNode.getChildren()) {
            this.createModuleView(moduleNode, moduleGroupView);
        }
    }

    private void registerModuleGroupView(ModuleGroupView moduleGroupView) {
        this.moduleGroupViews.add(moduleGroupView);
    }

    public void unregisterModuleGroupView(IModuleGroupNode moduleGroupNode) {
        for (ModuleGroupView moduleGroupView : this.moduleGroupViews) {
            if (moduleGroupView.getNavigationNode() != moduleGroupNode) continue;
            this.unregisterModuleGroupView(moduleGroupView, moduleGroupNode);
            break;
        }
    }

    private void unregisterModuleGroupView(ModuleGroupView moduleGroupView, IModuleGroupNode node) {
        this.moduleGroupNodesToViews.remove(node);
        this.moduleGroupViews.remove(moduleGroupView);
    }

    private void createModuleView(IModuleNode moduleNode, ModuleGroupView moduleGroupView) {
        Composite moduleGroupBody = (Composite)moduleGroupView.getChildren()[0];
        FormLayout layout = new FormLayout();
        moduleGroupBody.setLayout((Layout)layout);
        ModuleView moduleView = this.viewFactory.createModuleView(moduleGroupBody);
        NodeIdentificationSupport.setIdentification((Widget)moduleView.getTitle(), "titleBar", (INavigationNode)moduleNode);
        NodeIdentificationSupport.setIdentification((Widget)moduleView.getTree(), "tree", (INavigationNode)moduleNode);
        this.moduleNodesToViews.put((INavigationNode<?>)moduleNode, moduleView);
        this.getViewFactory().createModuleController(moduleNode);
        moduleView.bind((ModuleNode)moduleNode);
        moduleGroupView.registerModuleView(moduleView);
    }

    public void updateNavigationSize() {
        this.calculateBounds();
        this.scrolledComposite.layout();
        this.navigationMainComposite.layout();
        this.scrollingSupport.scroll();
    }

    public IModuleGroupNode getActiveModuleGroupNode() {
        IModuleGroupNode active = null;
        Iterator it = this.getSubApplicationNode().getChildren().iterator();
        while (active == null && it.hasNext()) {
            active = (IModuleGroupNode)it.next();
            if (active.isActivated()) continue;
            active = null;
        }
        return active;
    }

    public int calculateBounds() {
        int yPosition = 0;
        for (ModuleGroupView moduleGroupView : this.moduleGroupViews) {
            yPosition = moduleGroupView.calculateBounds(yPosition);
        }
        return yPosition;
    }

    private ModuleGroupRenderer getModuleGroupRenderer() {
        ModuleGroupRenderer renderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (renderer == null) {
            renderer = new ModuleGroupRenderer();
        }
        return renderer;
    }

    private EmbeddedBorderRenderer getLnfBorderRenderer() {
        EmbeddedBorderRenderer renderer = (EmbeddedBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.borderRenderer");
        if (renderer == null) {
            renderer = new EmbeddedBorderRenderer();
        }
        return renderer;
    }

    private int getModuleGroupPadding() {
        return this.getModuleGroupRenderer().getModuleGroupPadding() + this.getLnfBorderRenderer().getBorderWidth();
    }

    public void setFocus() {
        this.navigationMainComposite.setFocus();
    }

    public Composite getNavigationComponent() {
        return this.navigationMainComposite;
    }

    public Composite getScrolledComponent() {
        return this.scrolledComposite;
    }

    private class ModuleGroupListener
    extends ModuleGroupNodeListener {
        private ModuleGroupListener() {
        }

        public void childAdded(IModuleGroupNode source, IModuleNode child) {
            ModuleGroupView moduleGroupView = NavigationViewPart.this.getModuleGroupViewForNode(source);
            NavigationViewPart.this.createModuleView(child, moduleGroupView);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void childRemoved(IModuleGroupNode source, IModuleNode child) {
            NavigationViewPart.this.moduleNodesToViews.remove(child);
        }

        public void disposed(IModuleGroupNode source) {
            super.disposed((INavigationNode)source);
            NavigationViewPart.this.unregisterModuleGroupView(source);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void markerChanged(IModuleGroupNode source, IMarker marker) {
            if (marker instanceof HiddenMarker) {
                NavigationViewPart.this.updateNavigationSize();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ModuleGroupViewObserver
    implements IComponentUpdateListener {
        private ModuleGroupViewObserver() {
        }

        @Override
        public void update(INavigationNode<?> node) {
            NavigationViewPart.this.updateNavigationSize();
        }
    }

    private final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            NavigationViewPart.this.updateNavigationSize();
            NavigationViewPart.this.parent.layout();
        }
    }

    private class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void childAdded(ISubApplicationNode source, IModuleGroupNode child) {
            NavigationViewPart.this.createModuleGroupView(child);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void childRemoved(ISubApplicationNode source, IModuleGroupNode child) {
            NavigationViewPart.this.unregisterModuleGroupView(child);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void markerChanged(ISubApplicationNode source, IMarker marker) {
            if (marker instanceof HiddenMarker) {
                NavigationViewPart.this.updateNavigationSize();
            }
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void markerChanged(ISubModuleNode source, IMarker marker) {
            if (marker instanceof HiddenMarker) {
                NavigationViewPart.this.updateNavigationSize();
            }
        }
    }
}

