/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.server;

import java.util.Hashtable;
import org.eclipse.riena.communication.core.hooks.IServiceHook;
import org.eclipse.riena.core.RienaPlugin;
import org.eclipse.riena.core.cache.GenericObjectCache;
import org.eclipse.riena.core.cache.IGenericObjectCache;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.security.server.SecurityServiceHook;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.session.ISessionHolder;
import org.eclipse.riena.security.server.session.ISessionService;
import org.osgi.framework.BundleContext;

public class Activator
extends RienaPlugin {
    public static final String PLUGIN_ID = "de.compeople.scp.security.server";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        GenericObjectCache principalCache = new GenericObjectCache();
        principalCache.setName("principalCache");
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("cache.type", "PrincipalCache");
        context.registerService(IGenericObjectCache.class.getName(), (Object)principalCache, props);
        this.createSecurityServiceHookAndInjectors();
    }

    private void createSecurityServiceHookAndInjectors() {
        SecurityServiceHook securityServiceHook = new SecurityServiceHook();
        this.getContext().registerService(IServiceHook.class.getName(), (Object)securityServiceHook, null);
        Inject.service(IGenericObjectCache.class).useFilter("(cache.type=PrincipalCache)").into((Object)securityServiceHook).andStart(Activator.getDefault().getContext());
        Inject.service(ISessionService.class).useRanking().into((Object)securityServiceHook).andStart(Activator.getDefault().getContext());
        Inject.service(ISubjectHolder.class).useRanking().into((Object)securityServiceHook).andStart(Activator.getDefault().getContext());
        Inject.service(ISessionHolder.class).useRanking().into((Object)securityServiceHook).andStart(Activator.getDefault().getContext());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

