/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.sample.app.server;

import java.util.Hashtable;
import org.eclipse.riena.communication.publisher.Publish;
import org.eclipse.riena.core.RienaPlugin;
import org.eclipse.riena.internal.sample.app.server.AttachmentService;
import org.eclipse.riena.internal.sample.app.server.Customers;
import org.eclipse.riena.internal.sample.app.server.ExceptionService;
import org.eclipse.riena.internal.sample.app.server.HelloWorldService;
import org.eclipse.riena.internal.sample.app.server.SimpleMonitoringReceiver;
import org.eclipse.riena.internal.sample.app.server.TestGregorianCalendar;
import org.eclipse.riena.monitor.common.IReceiver;
import org.eclipse.riena.sample.app.common.attachment.IAttachmentService;
import org.eclipse.riena.sample.app.common.calendar.ITestGregorianCalendar;
import org.eclipse.riena.sample.app.common.exception.IExceptionService;
import org.eclipse.riena.sample.app.common.model.ICustomerSearch;
import org.eclipse.riena.sample.app.common.model.ICustomers;
import org.eclipse.riena.sample.app.common.model.IHelloWorldService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends RienaPlugin {
    private static final String REMOTE_PROTOCOL_HESSIAN = "hessian";
    private Customers customers;
    private ServiceRegistration regCustomerSearch;
    private ServiceRegistration regCustomers;
    private HelloWorldService helloWorldService;
    private IReceiver monitoringReceiver;
    private ServiceRegistration regHelloWorldService;
    private ServiceRegistration regCollectibleReceiver;
    private ServiceRegistration regAttachmentService;
    private static Activator plugin;

    public Activator() {
        plugin = this;
        this.customers = new Customers();
        this.helloWorldService = new HelloWorldService();
        this.monitoringReceiver = new SimpleMonitoringReceiver();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.startCustomerSearch(context);
        this.startCustomers(context);
        this.startHelloWorldService(context);
        this.startCollectibleReceiver(context);
        this.startAttachmentService(context);
        this.startTestGregorianCalendar(context);
        context.registerService(IExceptionService.class.getName(), (Object)new ExceptionService(), null);
        Publish.service((String)IExceptionService.class.getName()).usingPath("/ExceptionService").withProtocol(REMOTE_PROTOCOL_HESSIAN).andStart(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.stopCustomerSearch();
        this.stopCustomers();
        this.stopHelloWorldService();
        this.stopAttachmentService();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void startCustomerSearch(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", REMOTE_PROTOCOL_HESSIAN);
        properties.put("riena.remote.path", "/CustomerSearchWS");
        this.regCustomerSearch = context.registerService(ICustomerSearch.class.getName(), (Object)this.customers, properties);
    }

    public void stopCustomerSearch() {
        this.regCustomerSearch.unregister();
        this.regCustomerSearch = null;
    }

    private void startCustomers(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", REMOTE_PROTOCOL_HESSIAN);
        properties.put("riena.remote.path", "/CustomersWS");
        this.regCustomers = context.registerService(ICustomers.class.getName(), (Object)this.customers, properties);
    }

    public void stopCustomers() {
        this.regCustomers.unregister();
        this.regCustomers = null;
    }

    private void startHelloWorldService(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", REMOTE_PROTOCOL_HESSIAN);
        properties.put("riena.remote.path", "/HelloWorldServiceWS");
        this.regHelloWorldService = context.registerService(IHelloWorldService.class.getName(), (Object)this.helloWorldService, properties);
    }

    private void startCollectibleReceiver(BundleContext context) {
        this.regCollectibleReceiver = context.registerService(IReceiver.class.getName(), (Object)this.monitoringReceiver, null);
        Publish.service(IReceiver.class).usingPath("/CollectibleReceiverWS").withProtocol(REMOTE_PROTOCOL_HESSIAN).andStart(context);
    }

    private void startTestGregorianCalendar(BundleContext context) {
        context.registerService(ITestGregorianCalendar.class.getName(), (Object)new TestGregorianCalendar(), null);
        Publish.service(ITestGregorianCalendar.class).usingPath("/TestGregorianCalendarWS").withProtocol(REMOTE_PROTOCOL_HESSIAN).andStart(context);
    }

    public void stopHelloWorldService() {
        this.regHelloWorldService.unregister();
        this.regHelloWorldService = null;
    }

    public void stopCollectibleReceiver() {
        this.regCollectibleReceiver.unregister();
        this.regCollectibleReceiver = null;
    }

    private void startAttachmentService(BundleContext context) {
        this.regAttachmentService = context.registerService(IAttachmentService.class.getName(), (Object)new AttachmentService(), null);
        Publish.service((String)IAttachmentService.class.getName()).usingPath("/AttachmentService").withProtocol(REMOTE_PROTOCOL_HESSIAN).andStart(context);
    }

    private void stopAttachmentService() {
        this.regAttachmentService.unregister();
    }
}

