/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatePickerComposite
extends Composite {
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 16;
    private final Text textfield;
    private final Button calendarButton;
    private final DatePicker datePicker;

    public DatePickerComposite(Composite parent, int textStyles) {
        super(parent, 2048);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo((Composite)this);
        this.textfield = new Text((Composite)this, this.checkStyle(textStyles));
        this.setBackground(this.getDisplay().getSystemColor(1));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.textfield);
        this.calendarButton = new Button((Composite)this, 1028);
        this.calendarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DatePickerComposite.this.datePicker.isVisible()) {
                    Point p = DatePickerComposite.this.textfield.toDisplay(((DatePickerComposite)DatePickerComposite.this).textfield.getLocation().x, ((DatePickerComposite)DatePickerComposite.this).textfield.getLocation().y);
                    DatePickerComposite.this.datePicker.setLocation(p.x, p.y + ((DatePickerComposite)DatePickerComposite.this).textfield.getBounds().height);
                    DatePickerComposite.this.datePicker.open(DatePickerComposite.this.parseDateRegex(DatePickerComposite.this.textfield.getText()));
                } else {
                    DatePickerComposite.this.datePicker.close();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).align(131072, 4).hint(16, 16).applyTo((Control)this.calendarButton);
        this.datePicker = new DatePicker(this.textfield, this.calendarButton);
    }

    public Text getTextfield() {
        return this.textfield;
    }

    public void dispose() {
        this.datePicker.dispose();
        super.dispose();
    }

    private int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            style &= 0xFFFFF7FF;
        }
        return style;
    }

    private Calendar parseDateRegex(String dateString) {
        Calendar result = null;
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*?");
        Matcher matcher = pattern.matcher(dateString);
        if (matcher.matches() && matcher.groupCount() == 3) {
            int month = Integer.parseInt(matcher.group(2));
            --month;
            int year = Integer.parseInt(matcher.group(3));
            if (year < 100) {
                year += 1900;
            }
            result = Calendar.getInstance();
            result.set(5, Integer.parseInt(matcher.group(1)));
            result.set(2, month);
            result.set(1, year);
        }
        return result;
    }

    private static final class DatePicker {
        private Shell shell;
        private DateTime calendar;
        private final Text text;

        protected DatePicker(Text text, final Button pickerButton) {
            this.text = text;
            this.shell = new Shell(pickerButton.getDisplay(), 16392);
            this.shell.setBackground(this.shell.getDisplay().getSystemColor(2));
            GridLayoutFactory.fillDefaults().margins(1, 1).applyTo((Composite)this.shell);
            this.calendar = new DateTime((Composite)this.shell, 33792);
            this.calendar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            this.shell.pack();
            this.calendar.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (e.y < 45) {
                        return;
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.set(1, DatePicker.this.calendar.getYear());
                    cal.set(2, DatePicker.this.calendar.getMonth());
                    cal.set(5, DatePicker.this.calendar.getDay());
                    String out = new SimpleDateFormat("dd.MM.yyyy").format(cal.getTime());
                    DatePicker.this.setDateToTextfield(out);
                    DatePicker.this.close();
                }
            });
            this.calendar.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    Display display = e.widget.getDisplay();
                    Control focusControl = display.getCursorControl();
                    if (focusControl != pickerButton) {
                        DatePicker.this.close();
                    }
                }
            });
        }

        public void dispose() {
            if (!SwtUtilities.isDisposed((Widget)this.shell)) {
                this.shell.dispose();
            }
        }

        public void setLocation(int x, int y) {
            this.shell.setLocation(x, y);
        }

        public boolean isVisible() {
            return this.shell.isVisible();
        }

        public void close() {
            this.shell.setVisible(false);
        }

        public void open(Calendar newDate) {
            if (this.isVisible()) {
                return;
            }
            this.shell.open();
            this.shell.setVisible(true);
            if (newDate == null) {
                newDate = Calendar.getInstance();
                newDate.setTime(new Date());
            }
            this.calendar.setYear(newDate.get(1));
            this.calendar.setMonth(newDate.get(2));
            this.calendar.setDay(newDate.get(5));
        }

        private void setDateToTextfield(String dateString) {
            String oldText = this.text.getText();
            if (oldText.contains(":")) {
                Pattern pattern = Pattern.compile("([ \\d\\.]+)\\s+(.*?:.*?)");
                Matcher matcher = pattern.matcher(oldText);
                if (matcher.matches()) {
                    String oldTime = matcher.group(2);
                    this.text.setText(String.valueOf(dateString) + " " + oldTime);
                }
            } else {
                this.text.setText(dateString);
            }
            this.text.setFocus();
        }
    }
}

