/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.uiprocess;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SwtUISynchronizer
implements IUISynchronizer {
    public void synchronize(Runnable runnable) {
        if (!this.hasDisplay()) {
            this.waitForDisplay(15000);
        }
        Display display = null;
        if (this.hasDisplay() && !(display = PlatformUI.getWorkbench().getDisplay()).isDisposed()) {
            display.syncExec(runnable);
        }
        if (display == null || display.isDisposed()) {
            this.getLogger().log(1, "Could not obtain display for runnable");
        }
    }

    private Logger getLogger() {
        return Log4r.getLogger((IRienaActivator)Activator.getDefault(), SwtUISynchronizer.class);
    }

    private boolean hasDisplay() {
        return PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getDisplay() != null;
    }

    private void waitForDisplay(int timeoutMs) {
        Assert.isTrue((timeoutMs >= 0 ? 1 : 0) != 0);
        int time = 0;
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        } while ((time += 500) < timeoutMs && !this.hasDisplay());
    }
}

