/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.context;

import java.util.Stack;
import org.eclipse.riena.objecttransaction.IObjectTransaction;
import org.eclipse.riena.objecttransaction.ObjectTransactionManager;
import org.eclipse.riena.objecttransaction.context.IObjectTransactionContext;
import org.eclipse.riena.objecttransaction.context.ObjectTransactionContextFailure;

public class ObjectTransactionContext
implements IObjectTransactionContext {
    private Stack<IObjectTransaction> replaced = new Stack();
    private IObjectTransaction objectTransaction;

    public ObjectTransactionContext() {
    }

    public ObjectTransactionContext(IObjectTransaction transaction) {
        this.objectTransaction = transaction;
    }

    public void activate() {
        this.replaced.push(ObjectTransactionManager.getInstance().getCurrent());
        ObjectTransactionManager.getInstance().setCurrent(this.objectTransaction);
    }

    public void passivate() {
        if (!this.isActivated()) {
            throw new ObjectTransactionContextFailure("Inconsistency while passivating object transaction context!");
        }
        ObjectTransactionManager.getInstance().setCurrent(this.replaced.pop());
    }

    public IObjectTransaction getObjectTransaction() {
        return this.objectTransaction;
    }

    public void setObjectTransaction(IObjectTransaction pObjectTransaction) {
        this.objectTransaction = pObjectTransaction;
        if (this.isActivated()) {
            ObjectTransactionManager.getInstance().setCurrent(this.objectTransaction);
        }
    }

    public boolean isActivated() {
        return !this.replaced.empty();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "ObjectTransaction=" + this.objectTransaction;
    }
}

