/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.rollback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.director.SimplePlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class FormerState {
    public static ProfileChangeRequest generateProfileDeltaChangeRequest(IProfile current, IProfile target) {
        ProfileChangeRequest request = new ProfileChangeRequest(current);
        FormerState.synchronizeProfileProperties(request, current, target);
        FormerState.synchronizeMarkedIUs(request, current, target);
        FormerState.synchronizeAllIUProperties(request, current, target);
        return request;
    }

    private static void synchronizeAllIUProperties(ProfileChangeRequest request, IProfile current, IProfile target) {
        Collection currentIUs = current.query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection();
        Collection targetIUs = target.query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection();
        ArrayList iusToAdd = new ArrayList(targetIUs);
        iusToAdd.remove(currentIUs);
        Iterator iterator = iusToAdd.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            Iterator it = target.getInstallableUnitProperties(iu).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                request.setInstallableUnitProfileProperty(iu, key, value);
            }
        }
        ArrayList iusToUpdate = new ArrayList(targetIUs);
        iusToUpdate.remove(iusToAdd);
        Iterator iterator2 = iusToUpdate.iterator();
        while (iterator2.hasNext()) {
            String key;
            Map.Entry entry;
            IInstallableUnit iu = (IInstallableUnit)iterator2.next();
            HashMap propertiesToSet = new HashMap(target.getInstallableUnitProperties(iu));
            Iterator it = current.getInstallableUnitProperties(iu).entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                key = (String)entry.getKey();
                String newValue = (String)propertiesToSet.get(key);
                if (newValue == null) {
                    request.removeInstallableUnitProfileProperty(iu, key);
                    continue;
                }
                if (!newValue.equals(entry.getValue())) continue;
                propertiesToSet.remove(key);
            }
            it = propertiesToSet.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                key = (String)entry.getKey();
                String value = (String)entry.getValue();
                request.setInstallableUnitProfileProperty(iu, key, value);
            }
        }
    }

    private static void synchronizeMarkedIUs(ProfileChangeRequest request, IProfile current, IProfile target) {
        IInstallableUnit[] currentPlannerMarkedIUs = SimplePlanner.findPlannerMarkedIUs(current);
        IInstallableUnit[] targetPlannerMarkedIUs = SimplePlanner.findPlannerMarkedIUs(target);
        ArrayList<IInstallableUnit> markedIUsToAdd = new ArrayList<IInstallableUnit>(Arrays.asList(targetPlannerMarkedIUs));
        markedIUsToAdd.removeAll(Arrays.asList(currentPlannerMarkedIUs));
        request.addInstallableUnits(markedIUsToAdd.toArray(new IInstallableUnit[markedIUsToAdd.size()]));
        ArrayList<IInstallableUnit> markedIUsToRemove = new ArrayList<IInstallableUnit>(Arrays.asList(currentPlannerMarkedIUs));
        markedIUsToRemove.removeAll(Arrays.asList(targetPlannerMarkedIUs));
        request.removeInstallableUnits(markedIUsToRemove.toArray(new IInstallableUnit[markedIUsToRemove.size()]));
    }

    private static void synchronizeProfileProperties(ProfileChangeRequest request, IProfile current, IProfile target) {
        String key;
        Map.Entry entry;
        HashMap profilePropertiesToSet = new HashMap(target.getProperties());
        Iterator it = current.getProperties().entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = (String)entry.getKey();
            String newValue = (String)profilePropertiesToSet.get(key);
            if (newValue == null) {
                request.removeProfileProperty(key);
                continue;
            }
            if (!newValue.equals(entry.getValue())) continue;
            profilePropertiesToSet.remove(key);
        }
        it = profilePropertiesToSet.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = (String)entry.getKey();
            String value = (String)entry.getValue();
            request.setProfileProperty(key, value);
        }
    }
}

