/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.core.Activator;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizerExtension;

public final class UISynchronizer {
    private static UISynchronizer singelton = new UISynchronizer();
    private IUISynchronizerExtension[] synchronizerExtension;
    @Deprecated
    private IUISynchronizerExtension[] deprecatedSynchronizerExtension;

    static {
        Wire.instance((Object)singelton).andStart(Activator.getDefault().getContext());
    }

    private UISynchronizer() {
    }

    public static IUISynchronizer createSynchronizer() {
        return singelton.create();
    }

    private IUISynchronizer create() {
        if (this.synchronizerExtension != null && this.synchronizerExtension.length > 0) {
            return this.synchronizerExtension[0].createUISynchronizer();
        }
        if (this.deprecatedSynchronizerExtension != null && this.deprecatedSynchronizerExtension.length > 0) {
            return this.deprecatedSynchronizerExtension[0].createUISynchronizer();
        }
        throw new IllegalStateException("There is NO IUISynchronizer defined, but it must. Use extension point 'uiSynchronizer' to do this.");
    }

    @InjectExtension
    public void update(IUISynchronizerExtension[] synchronizerExtension) {
        this.synchronizerExtension = synchronizerExtension;
    }

    @InjectExtension(id="org.riena.ui.core.uiprocess")
    @Deprecated
    public void deprecatedUpdate(IUISynchronizerExtension[] synchronizerExtension) {
        this.deprecatedSynchronizerExtension = synchronizerExtension;
    }
}

