/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.factory.hessian;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.communication.core.hooks.ICallMessageContext;
import org.eclipse.riena.communication.core.hooks.ICallMessageContextAccessor;
import org.eclipse.riena.internal.communication.factory.hessian.RienaSerializerFactory;

public class RienaHessianProxyFactory
extends HessianProxyFactory {
    private ICallMessageContextAccessor mca;
    private static final ThreadLocal<HttpURLConnection> CONNECTIONS = new ThreadLocal();

    public RienaHessianProxyFactory() {
        this.getSerializerFactory().setAllowNonSerializable(true);
        this.getSerializerFactory().addFactory((AbstractSerializerFactory)new RienaSerializerFactory());
        this.setHessian2Request(true);
        this.setHessian2Reply(true);
    }

    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection connection;
        ICallMessageContext mc = this.mca.getMessageContext();
        String methodName = mc.getMethodName();
        String requestId = mc.getRequestId();
        if (methodName != null || requestId != null) {
            if (requestId != null) {
                methodName = String.valueOf(methodName) + "&" + requestId;
            }
            connection = super.openConnection(new URL(String.valueOf(url.toString()) + "?" + methodName));
        } else {
            connection = super.openConnection(url);
        }
        Map headers = mc.listRequestHeaders();
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                for (String hValue : (List)entry.getValue()) {
                    connection.addRequestProperty((String)entry.getKey(), hValue);
                }
            }
        }
        CONNECTIONS.set((HttpURLConnection)connection);
        return connection;
    }

    public AbstractHessianInput getHessianInput(final InputStream is) {
        final ICallMessageContext messageContext = this.mca.getMessageContext();
        if (messageContext.getProgressMonitorList() == null) {
            return super.getHessianInput(is);
        }
        return super.getHessianInput(new InputStream(){

            public int read() throws IOException {
                int b = is.read();
                if (b != -1) {
                    messageContext.fireReadEvent(1);
                }
                return b;
            }
        });
    }

    public AbstractHessianOutput getHessianOutput(final OutputStream os) {
        final ICallMessageContext messageContext = this.mca.getMessageContext();
        if (messageContext.getProgressMonitorList() == null) {
            return super.getHessianOutput(os);
        }
        return super.getHessianOutput(new OutputStream(){

            public void write(int b) throws IOException {
                os.write(b);
                messageContext.fireWriteEvent(1);
            }
        });
    }

    public void setCallMessageContextAccessor(ICallMessageContextAccessor mca) {
        this.mca = mca;
    }

    protected static HttpURLConnection getHttpURLConnection() {
        return CONNECTIONS.get();
    }
}

