/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpListener;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.Registration;
import org.eclipse.equinox.http.servlet.RequestDispatcherImpl;
import org.osgi.service.http.HttpContext;

public class ServletContextImpl
implements ServletContext {
    protected Hashtable attributes = null;
    protected Http http;
    protected HttpListener listener;
    protected HttpContext httpContext;
    protected int useCount;

    public ServletContextImpl(Http http, HttpListener listener, HttpContext httpContext) {
        this.http = http;
        this.listener = listener;
        this.httpContext = httpContext;
        this.useCount = 0;
    }

    public int incrUseCount() {
        ++this.useCount;
        return this.useCount;
    }

    public int decrUseCount() {
        --this.useCount;
        return this.useCount;
    }

    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        if (this.attributes != null) {
            return this.attributes.keys();
        }
        return new Vector(0).elements();
    }

    public ServletContext getContext(String uripath) {
        Registration reg = this.listener.getRegistration(uripath);
        if (reg == null) {
            return null;
        }
        if (this.httpContext != reg.getHttpContext()) {
            return null;
        }
        return this;
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String file) {
        String mimeType = this.httpContext.getMimeType(file);
        if (mimeType != null) {
            return mimeType;
        }
        return this.http.getMimeType(file);
    }

    public int getMinorVersion() {
        return 1;
    }

    public String getRealPath(String path) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String urlpath) {
        Registration reg = this.listener.getRegistration(urlpath);
        if (reg == null) {
            return null;
        }
        if (this.httpContext != reg.getHttpContext()) {
            return null;
        }
        return new RequestDispatcherImpl(reg, urlpath);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.httpContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        try {
            URL url = this.httpContext.getResource(path);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public String getServerInfo() {
        return "Equinox HttpService/1.0";
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServletNames() {
        return new Vector(0).elements();
    }

    public Enumeration getServlets() {
        return new Vector(0).elements();
    }

    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    public void log(String msg) {
        this.http.logInfo(msg);
    }

    public void log(String message, Throwable throwable) {
        this.http.logError(message, throwable);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object object) {
        if (this.attributes == null) {
            ServletContextImpl servletContextImpl = this;
            synchronized (servletContextImpl) {
                if (this.attributes == null) {
                    this.attributes = new Hashtable(31);
                }
            }
        }
        this.attributes.put(name, object);
    }

    public String getInitParameter(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Enumeration getInitParameterNames() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public RequestDispatcher getNamedDispatcher(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Set getResourcePaths(String path) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public String getServletContextName() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public String getContextPath() {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }
}

